/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.turret.energy;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.block.ModBlockEntities;
import net.shao.valkyrien_space_war.block.turret.base.AbstractTurretBE;
import net.shao.valkyrien_space_war.block.turret.energy.BasicEnergyTurret;
import net.shao.valkyrien_space_war.block.turret.energy.EnergyProjectileGenerator;
import net.shao.valkyrien_space_war.block.turret.energy.EnergyTurretMenu;
import net.shao.valkyrien_space_war.compat.gregtech.GTValuesDup;
import net.shao.valkyrien_space_war.projectile.EnergyProjectile;
import net.shao.valkyrien_space_war.projectile.base.ProjectileProperties;
import net.shao.valkyrien_space_war.projectile.base.VSSWProjectile;
import net.shao.valkyrien_space_war.sound.ModSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicEnergyTurretBE
extends AbstractTurretBE
implements EnergyProjectileGenerator {
    private final long energyCapacity;
    private final int voltageLevel;
    private byte gunLevel = (byte)this.getVoltageLevel();
    private float compressionRatio = 1.0f;
    public int color = 1426047231;
    public static final byte MIN_FIRE_TICKS = 3;
    public static final byte MAX_FIRE_TICKS = 10;
    private final Vec3 shootPosOffset;
    private final Vec3 shootPosOffset_invert;
    public final ResourceLocation texture;
    private static final Component NAME = Component.m_237115_((String)"block.valkyrien_space_war.basic_energy_turret");
    private static final Vec3 eyeOffset = new Vec3(0.0, 1.25, 0.0);
    private static final Vec3 eyeOffset_inverted = new Vec3(0.0, -1.0, 0.0);

    public BasicEnergyTurretBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.BASIC_ENERGY_TURRET_BE.get(), pPos, pBlockState);
        Block block = pBlockState.m_60734_();
        if (block instanceof BasicEnergyTurret) {
            BasicEnergyTurret turretBlock = (BasicEnergyTurret)block;
            this.energyCapacity = turretBlock.getEnergyCapacity();
            this.voltageLevel = turretBlock.getVoltageLevel();
            this.texture = turretBlock.getTexture();
            this.gunLevel = (byte)this.voltageLevel;
        } else {
            this.energyCapacity = 0L;
            this.voltageLevel = 0;
            this.texture = new ResourceLocation("valkyrien_space_war", "textures/block/basic_energy_turret.png");
        }
        this.shootPosOffset = new Vec3(0.0, 0.4, 3.0);
        this.shootPosOffset_invert = new Vec3(0.0, -0.5, 3.0);
        this.fireRate = (byte)3;
    }

    @Override
    public long getEnergyCapacity() {
        return this.energyCapacity;
    }

    @Override
    public int getVoltageLevel() {
        return this.voltageLevel;
    }

    @Override
    public long getInputAmperage() {
        return 2L;
    }

    @Override
    protected void shoot() {
        super.shoot();
        this.changeEnergy(-this.getProjectileEnergy());
        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.ELECTRONIC_SHOT_1.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        this.calcProjectile();
    }

    @Override
    protected boolean canShoot() {
        return this.fireTicks < 1 && this.getEnergyStored() >= this.getProjectileEnergy();
    }

    @Override
    protected int getMinFireRate() {
        return 3;
    }

    @Override
    protected int getMaxFireRate() {
        return this.getFireRate();
    }

    @Override
    protected VSSWProjectile spawnProjectile(Player owner, Level level, boolean isOnShip, Vec3 direction, Vec3 position) {
        return new EnergyProjectile(this.getProjectileProperties(), (Entity)owner, level, isOnShip, direction, position);
    }

    @Override
    public ProjectileProperties getProjectileProperties() {
        return new ProjectileProperties(this.getMuzzleVelocity(), 0.05f, 0.99f, this.getBlockDamage(), this.getEntityDamage(), 100, this.color);
    }

    @Override
    public int getRotationEnergyCost() {
        return 8;
    }

    @Override
    protected float getBarrelLength() {
        return 3.0f;
    }

    @Override
    public void tick(Level pLevel1, BlockPos pPos, BlockState pState1) {
        super.tick(pLevel1, pPos, pState1);
    }

    @Override
    public void setFireRate(byte fireRate) {
        fireRate = (byte)(fireRate < 3 ? 3 : (fireRate > 10 ? 10 : (int)fireRate));
        super.setFireRate(fireRate);
    }

    @Override
    public Vec3 getShootPosOffset() {
        return this.inverted ? this.shootPosOffset_invert : this.shootPosOffset;
    }

    public void setGunLevel(byte gunLevel) {
        this.gunLevel = gunLevel;
        this.syncToClient();
    }

    @Override
    public byte getGunLevel() {
        return this.gunLevel;
    }

    public void prevGunLevel() {
        byte newGunLevel = (byte)(this.gunLevel - 1);
        if (newGunLevel > 3) {
            this.setGunLevel(newGunLevel);
        }
    }

    public void nextGunLevel() {
        byte newGunLevel = (byte)(this.gunLevel + 1);
        if (newGunLevel < this.getVoltageLevel() + 2) {
            this.setGunLevel(newGunLevel);
        }
    }

    public void setCompressionRatio(float compressionRatio) {
        this.compressionRatio = compressionRatio;
        this.syncToClient();
    }

    @Override
    public float getCompressionRatio() {
        return this.compressionRatio;
    }

    public void setProjectileColor(int color) {
        this.color = color;
        this.syncToClient();
    }

    @Override
    public float getMaxRotationSpeed() {
        return 10.0f;
    }

    @Override
    public Vec3 getEyeOffset() {
        return this.inverted ? eyeOffset_inverted : eyeOffset;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new EnergyTurretMenu(pContainerId, pPlayerInventory, this);
    }

    @Override
    protected void putTag(CompoundTag tag) {
        super.putTag(tag);
        tag.m_128344_("GunLevel", this.gunLevel);
        tag.m_128350_("CompressionRatio", this.compressionRatio);
        tag.m_128405_("Color", this.color);
    }

    @Override
    protected void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        this.gunLevel = tag.m_128445_("GunLevel");
        this.compressionRatio = tag.m_128457_("CompressionRatio");
        this.color = tag.m_128451_("Color");
    }

    public long getProjectileEnergy() {
        return GTValuesDup.V[this.gunLevel] * 64L;
    }

    public long getProjectileCount() {
        return this.getEnergyStored() / this.getProjectileEnergy();
    }

    @NotNull
    public Component m_5446_() {
        return NAME;
    }
}

