/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.turret.machinegun;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.block.ModBlockEntities;
import net.shao.valkyrien_space_war.block.turret.base.AbstractItemTurretBE;
import net.shao.valkyrien_space_war.block.turret.base.fx.IMuzzleFlashTurret;
import net.shao.valkyrien_space_war.block.turret.base.fx.TurretObjModels;
import net.shao.valkyrien_space_war.block.turret.machinegun.MachineGunTurretMenu;
import net.shao.valkyrien_space_war.block.turret.machinegun.MachineGunTurretModel;
import net.shao.valkyrien_space_war.function.render.BakedModelRenderer;
import net.shao.valkyrien_space_war.function.render.CameraShakeEffect;
import net.shao.valkyrien_space_war.function.render.CustomRenderTypes;
import net.shao.valkyrien_space_war.item.ModItemTags;
import net.shao.valkyrien_space_war.item.projectile.ItemVsswProjectile;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.turret.MuzzleFlashPacket;
import net.shao.valkyrien_space_war.particle.ModParticles;
import net.shao.valkyrien_space_war.projectile.base.ProjectileProperties;
import net.shao.valkyrien_space_war.projectile.base.VSSWProjectile;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class MachineGunTurretBE
extends AbstractItemTurretBE
implements IMuzzleFlashTurret {
    private static final long energyCapacity = 2048L;
    private final Vec3 shootPosOffset;
    private final Vec3 shootPosOffset_invert;
    private static final Component NAME = Component.m_237115_((String)"block.valkyrien_space_war.machine_gun_turret");
    private final ArrayList<Long> muzzleFlashList = new ArrayList();
    private static final Vec3 eyeOffset = new Vec3(0.75, 0.5, 0.0);
    private static final Vec3 eyeOffset_inverted = new Vec3(0.75, -0.2, 0.0);

    public MachineGunTurretBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.MACHINE_GUN_TURRET_BE.get(), pPos, pBlockState);
        this.shootPosOffset = new Vec3(0.0, 0.4, 2.7);
        this.shootPosOffset_invert = new Vec3(0.0, -0.3, 2.7);
    }

    @Override
    public ArrayList<Long> getMuzzleFlashList() {
        return this.muzzleFlashList;
    }

    @Override
    public void addMuzzleFlash(long time) {
        this.muzzleFlashList.add(time);
        if (this.f_58857_ != null) {
            Vec3 shootPos = this.getShootPos();
            Vec3 dir = this.getShootDir();
            this.f_58857_.m_7106_((ParticleOptions)ModParticles.MUZZLE_FLASH_30MM_PARTICLE.get(), shootPos.m_7096_(), shootPos.m_7098_(), shootPos.m_7094_(), dir.m_7096_(), dir.m_7098_(), dir.m_7094_());
            CameraShakeEffect.triggerShakeScreen(shootPos.m_252839_(), 8.0f);
        }
    }

    @Override
    protected void shoot() {
        super.shoot();
        this.calcProjectile();
        ModNetworkHandler.sendToNearbyPlayers(10, this.f_58857_, this.m_58899_(), new MuzzleFlashPacket(this.m_58899_()));
    }

    @Override
    protected boolean canShoot() {
        if (this.fireTicks > 0) {
            return false;
        }
        return this.getNextAmmo(false) != null;
    }

    private ItemVsswProjectile getNextAmmo(boolean shrink) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_() || !stack.m_204117_(ModItemTags.MACHINE_GUN_PROJECTILE)) continue;
            ItemVsswProjectile item = (ItemVsswProjectile)stack.m_41720_();
            if (shrink) {
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
                }
                this.m_6596_();
            }
            return item;
        }
        return null;
    }

    @Override
    protected VSSWProjectile spawnProjectile(Player owner, Level level, boolean isVsPhyTick, Vec3 direction, Vec3 position) {
        ItemVsswProjectile nextAmmo = this.getNextAmmo(true);
        if (nextAmmo != null) {
            return nextAmmo.createProjectile(owner, level, isVsPhyTick, direction, position);
        }
        throw new IllegalStateException("\u6ca1\u6709\u53ef\u7528\u5f39\u836f! \u5750\u6807: " + this.m_58899_().m_123341_() + ", " + this.m_58899_().m_123342_() + ", " + this.m_58899_().m_123343_());
    }

    @Override
    public ProjectileProperties getProjectileProperties() {
        ItemVsswProjectile nextAmmo = this.getNextAmmo(false);
        if (nextAmmo != null) {
            return nextAmmo.getProjectileProperties();
        }
        return ItemVsswProjectile.TEMP_PROPERTIES;
    }

    @Override
    public int getRotationEnergyCost() {
        return 8;
    }

    @Override
    protected float getBarrelLength() {
        return 2.0f;
    }

    @Override
    protected int getMinFireRate() {
        return 3;
    }

    @Override
    protected int getMaxFireRate() {
        return 10;
    }

    @Override
    public Vec3 getShootPosOffset() {
        return this.inverted ? this.shootPosOffset_invert : this.shootPosOffset;
    }

    @Override
    public float getMaxRotationSpeed() {
        return 10.0f;
    }

    @Override
    public Vec3 getEyeOffset() {
        return this.inverted ? eyeOffset_inverted : eyeOffset;
    }

    @Override
    public long getEnergyCapacity() {
        return 2048L;
    }

    @Override
    public long getInputAmperage() {
        return 2L;
    }

    @Override
    public int getVoltageLevel() {
        return 1;
    }

    public Component m_5446_() {
        return NAME;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new MachineGunTurretMenu(pContainerId, pPlayerInventory, this);
    }

    public static class Renderer
    implements BlockEntityRenderer<MachineGunTurretBE> {
        private final MachineGunTurretModel model;
        public static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("valkyrien_space_war", "textures/block/machine_gun_turret.png");
        private static final RenderType RENDER_TYPE = CustomRenderTypes.createObjModelRenderTypeTranslucent();

        public Renderer(BlockEntityRendererProvider.Context context) {
            this.model = new MachineGunTurretModel(context.m_173582_(MachineGunTurretModel.LAYER_LOCATION));
        }

        public void render(MachineGunTurretBE be, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(0.5, 0.0, 0.5);
            pPoseStack.m_85841_(1.5f, 1.5f, 1.5f);
            this.model.render(be, pPoseStack, pBuffer.m_6299_(RenderType.m_110446_((ResourceLocation)TEXTURE_LOCATION)), pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            pPoseStack.m_85849_();
            this.renderMuzzleFlash(be, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        }

        private void renderMuzzleFlash(MachineGunTurretBE be, PoseStack poseStack, MultiBufferSource bufferSource, int pPackedLight, int pPackedOverlay) {
            if (TurretObjModels.MUZZLE_FLASH_30MM_BAKED_MODEL == null) {
                return;
            }
            if (be.getMuzzleFlashList().isEmpty()) {
                return;
            }
            be.updateMuzzleFlashes();
            float deltaFrameTime = be.getFrameTime();
            float yaw = (float)Math.toRadians(Mth.m_14179_((float)deltaFrameTime, (float)be.getOYaw(), (float)be.getYaw()));
            float pitch = (float)Math.toRadians(Mth.m_14179_((float)deltaFrameTime, (float)be.getOPitch(), (float)be.getPitch()));
            Vec3 pos = be.getShootPosOffset();
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_252781_(new Quaternionf().rotationY(-yaw));
            poseStack.m_252781_(new Quaternionf().rotationX(pitch));
            poseStack.m_85837_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
            poseStack.m_85841_(2.0f, 2.0f, 4.0f);
            PoseStack.Pose last = poseStack.m_85850_();
            VertexConsumer buffer = bufferSource.m_6299_(RENDER_TYPE);
            be.getMuzzleFlashList().forEach(time -> {
                float alpha = IMuzzleFlashTurret.getMuzzleFlashAlpha(time);
                float v = 1.0f - alpha;
                poseStack.m_85841_(v, v, v);
                BakedModelRenderer.renderWithAlpha(last, buffer, null, TurretObjModels.MUZZLE_FLASH_30MM_BAKED_MODEL, 1.0f, 1.0f, 1.0f, alpha, 0xF000F0, pPackedOverlay);
            });
            poseStack.m_85849_();
        }
    }
}

