/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.turret.machinegun;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.shao.valkyrien_space_war.block.turret.base.AbstractTurretBE;

public class MachineGunTurretModel
extends Model {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("valkyrien_space_war", "machine_gun_turret"), "main");
    private final ModelPart cannon;
    private final ModelPart base;
    private final ModelPart yaw;
    private final ModelPart pitch;

    public MachineGunTurretModel(ModelPart root) {
        super(RenderType::m_110446_);
        this.cannon = root.m_171324_("cannon");
        this.base = this.cannon.m_171324_("base");
        this.yaw = this.cannon.m_171324_("yaw");
        this.pitch = this.yaw.m_171324_("pitch");
        this.cannon.f_104203_ = (float)Math.PI;
        this.cannon.f_104204_ = (float)Math.PI;
        this.cannon.f_104201_ = 0.0f;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition cannon = partdefinition.m_171599_("cannon", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition base = cannon.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(44, 69).m_171488_(4.0f, -1.0f, -4.8f, 3.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(4, 30).m_171488_(2.0f, -3.0f, -6.8f, 2.0f, 3.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(78, 97).m_171488_(-1.0f, -3.25f, -5.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 30).m_171488_(-4.0f, -3.0f, -6.8f, 2.0f, 3.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(4, 53).m_171488_(-2.0f, -3.0f, -5.8f, 4.0f, 3.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(2, 72).m_171488_(-7.0f, -1.0f, -4.8f, 3.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(82, 36).m_171488_(-6.0f, -2.0f, -3.8f, 4.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(82, 47).m_171488_(2.0f, -2.0f, -3.8f, 4.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition yaw = cannon.m_171599_("yaw", CubeListBuilder.m_171558_().m_171514_(51, 15).m_171488_(-2.0f, -0.5f, -3.1f, 4.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition cube_r1 = yaw.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(14, 97).m_171488_(2.9f, 0.4131f, -0.7824f, 0.9f, 7.0f, 1.7f, new CubeDeformation(0.0f)).m_171514_(34, 70).m_171488_(0.2f, 0.4131f, -0.7824f, 0.9f, 7.0f, 1.7f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-6.4f, (float)1.1f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = yaw.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(21, 82).m_171488_(-1.0f, -2.2369f, -2.0824f, 2.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.45f, (float)1.9f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition pitch = yaw.m_171599_("pitch", CubeListBuilder.m_171558_().m_171514_(94, 15).m_171488_(-0.8f, -1.2f, -31.1f, 1.6f, 1.4f, 1.0f, new CubeDeformation(0.0f)).m_171514_(81, 19).m_171488_(-1.0f, -3.0f, -4.0f, 2.0f, 3.8f, 11.0f, new CubeDeformation(0.0f)).m_171514_(34, 82).m_171488_(-0.3f, -0.8f, -33.3f, 0.6f, 0.6f, 12.0f, new CubeDeformation(0.0f)).m_171514_(74, 67).m_171488_(-1.1f, 0.2f, -8.7f, 2.2f, 2.0f, 12.9f, new CubeDeformation(0.0f)).m_171514_(86, 94).m_171488_(-0.6f, -0.9f, -24.2f, 1.2f, 0.8f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-0.8f, -1.0f, -16.2f, 1.6f, 1.0f, 25.1f, new CubeDeformation(0.0f)).m_171514_(94, 11).m_171488_(-3.1f, -0.6f, 8.9f, 6.2f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(60, 95).m_171488_(-1.4f, -3.6f, 5.0f, 2.8f, 4.15f, 5.0f, new CubeDeformation(0.0f)).m_171514_(76, 103).m_171488_(-1.9f, 0.3f, 0.9f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(46, 104).m_171488_(-1.1f, 0.3f, 0.9f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(38, 104).m_171488_(-1.0f, -0.5612f, 0.932f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(88, 103).m_171488_(-2.1f, 0.3f, 0.9f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(54, 104).m_171488_(-0.9f, 0.3f, 0.9f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(100, 15).m_171488_(-0.8f, -1.2f, -33.2f, 1.6f, 1.4f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)3.0f));
        PartDefinition cube_r3 = pitch.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(55, 1).m_171488_(-4.0f, 1.0f, -6.0f, 5.0f, 3.0f, 14.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.4f, (float)-1.5612f, (float)0.032f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition cube_r4 = pitch.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(41, 50).m_171488_(-1.0f, 1.0f, -6.0f, 5.0f, 3.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.4f, (float)-1.5612f, (float)0.032f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition cube_r5 = pitch.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(93, -1).m_171488_(-1.5346f, -0.0522f, -1.9f, 3.1f, 3.8f, 7.0f, new CubeDeformation(0.0f)).m_171514_(42, 95).m_171488_(-1.0346f, 0.8478f, -8.0f, 2.6f, 2.9f, 6.1f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.6f, (float)3.9f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r6 = pitch.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(79, 55).m_171488_(-1.5654f, -0.0522f, -1.9f, 3.1f, 3.8f, 7.0f, new CubeDeformation(0.0f)).m_171514_(24, 95).m_171488_(-1.5654f, 0.8478f, -8.0f, 2.6f, 2.9f, 6.1f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.6f, (float)3.9f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r7 = pitch.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(86, 82).m_171488_(0.3154f, 0.7478f, -5.0f, 1.9f, 2.2f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.95f, (float)-2.2f, (float)-7.8f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r8 = pitch.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(0, 85).m_171488_(-2.2154f, 0.7478f, -5.0f, 1.9f, 2.2f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.95f, (float)-2.2f, (float)-7.8f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r9 = pitch.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(99, 60).m_171488_(-1.0f, 0.0824f, -4.6131f, 2.0f, 3.0f, 5.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.0f, (float)-1.1f, (float)3.9f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r10 = pitch.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(0, 97).m_171488_(-1.9f, -0.1522f, -2.1654f, 1.8f, 2.0f, 5.4f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-1.6f, (float)-6.9f, (float)0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void render(AbstractTurretBE be, PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        this.base.f_104204_ = (float)Math.toRadians(Mth.m_14177_((float)(be.faceAngle + 180.0f)));
        float deltaFrameTime = be.getFrameTime();
        this.yaw.f_104204_ = (float)Mth.m_14175_((double)(Math.toRadians(MachineGunTurretModel.lerp(deltaFrameTime, be.getOYaw(), be.getYaw())) + Math.PI));
        this.pitch.f_104203_ = (float)Math.toRadians(MachineGunTurretModel.lerp(deltaFrameTime, be.getOPitch(), be.getPitch()));
        if (be.inverted) {
            this.cannon.f_104203_ = 0.0f;
            this.cannon.f_104204_ = 0.0f;
            this.cannon.f_104201_ = 12.0f;
            this.yaw.f_104204_ = -this.yaw.f_104204_;
            this.pitch.f_104203_ = -this.pitch.f_104203_;
        } else {
            this.cannon.f_104203_ = (float)Math.PI;
            this.cannon.f_104204_ = (float)Math.PI;
            this.cannon.f_104201_ = 0.0f;
        }
        this.m_7695_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
    }

    public static float lerp(float pDelta, float pStart, float pEnd) {
        return pStart + pDelta * Mth.m_14177_((float)(pEnd - pStart));
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.cannon.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

