/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.function.schematic.VsswSchematic;
import net.shao.valkyrien_space_war.function.schematic.VsswVsManager;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import org.joml.Quaterniond;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.impl.config.VSCoreConfig;
import org.valkyrienskies.mod.common.command.RelativeVector3;
import org.valkyrienskies.mod.common.command.RelativeVector3Argument;

public class VsswCommands {
    private static final SuggestionProvider<CommandSourceStack> SCHEMATIC_SUGGESTIONS = (context, builder) -> VsswCommands.getSchematicSuggestions(builder);
    private static final SuggestionProvider<CommandSourceStack> SHIP_LIST_SUGGESTIONS = VsswCommands::getShipListSuggestions;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"vssw").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"schematic").then(Commands.m_82127_((String)"save").then(Commands.m_82129_((String)"shipName", (ArgumentType)StringArgumentType.string()).suggests(SHIP_LIST_SUGGESTIONS).then(Commands.m_82129_((String)"asName", (ArgumentType)StringArgumentType.string()).executes(VsswCommands::saveSchematic))))).then(Commands.m_82127_((String)"load").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"shipName", (ArgumentType)StringArgumentType.string()).suggests(SCHEMATIC_SUGGESTIONS).executes(ctx -> VsswCommands.loadSchematic((CommandContext<CommandSourceStack>)ctx, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(VsswCommands::loadSchematic)).then(Commands.m_82129_((String)"euler-angles", (ArgumentType)RelativeVector3Argument.Companion.relativeVector3()).executes(VsswCommands::loadSchematicWithEulerAngles)))))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"shipName", (ArgumentType)StringArgumentType.string()).suggests(SCHEMATIC_SUGGESTIONS).executes(VsswCommands::deleteSchematic)))).then(Commands.m_82127_((String)"list").executes(VsswCommands::listSchematics)))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"shipName", (ArgumentType)StringArgumentType.string()).suggests(SHIP_LIST_SUGGESTIONS).executes(ctx -> VsswCommands.deleteShip((CommandContext<CommandSourceStack>)ctx, false))))).then(Commands.m_82127_((String)"deleteAllRelatedShips").then(Commands.m_82129_((String)"shipName", (ArgumentType)StringArgumentType.string()).suggests(SHIP_LIST_SUGGESTIONS).executes(ctx -> VsswCommands.deleteShip((CommandContext<CommandSourceStack>)ctx, true))))).then(Commands.m_82127_((String)"deleteMasslessShips").executes(VsswCommands::deleteMasslessShips)));
    }

    private static CompletableFuture<Suggestions> getSchematicSuggestions(SuggestionsBuilder builder) {
        File dir = new File("vssw-schematics");
        if (!dir.exists() || !dir.isDirectory()) {
            return Suggestions.empty();
        }
        File[] files = dir.listFiles((d, name) -> name.endsWith(".vssw"));
        if (files == null || files.length == 0) {
            return Suggestions.empty();
        }
        String input = builder.getRemaining().toLowerCase();
        for (File file : files) {
            String name2 = file.getName().replace(".vssw", "");
            if (!name2.toLowerCase().startsWith(input)) continue;
            builder.suggest(name2);
        }
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> getShipListSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        QueryableShipData<LoadedServerShip> ships = VsUtil.getLoadedShips(level);
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (ships.isEmpty() || player == null) {
            return Suggestions.empty();
        }
        double shipLoadDistance = VSCoreConfig.SERVER.getShipLoadDistance();
        String input = builder.getRemaining().toLowerCase();
        for (Ship ship : ships) {
            String name;
            Vector3dc positionInWorld = ship.getTransform().getPositionInWorld();
            double length = new Vec3(positionInWorld.x(), positionInWorld.y(), positionInWorld.z()).m_82546_(player.m_20182_()).m_82553_();
            if (length >= shipLoadDistance || !(name = ship.getSlug()).toLowerCase().startsWith(input)) continue;
            builder.suggest(name);
        }
        return builder.buildFuture();
    }

    private static int saveSchematic(CommandContext<CommandSourceStack> ctx) {
        try {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            String shipName = StringArgumentType.getString(ctx, (String)"shipName");
            QueryableShipData<LoadedServerShip> ships = VsUtil.getLoadedShips(level);
            if (ships.isEmpty()) {
                return 0;
            }
            List<LoadedServerShip> list = ships.stream().filter(ship -> Objects.equals(ship.getSlug(), shipName)).toList();
            if (list.isEmpty()) {
                return 0;
            }
            LoadedServerShip loadedServerShip = list.get(0);
            String targetName = StringArgumentType.getString(ctx, (String)"asName");
            VsswVsManager.saveBlueprint(level, (ServerShip)loadedServerShip, targetName);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u84dd\u56fe\u5df2\u4fdd\u5b58: " + targetName)), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("\u4fdd\u5b58\u5931\u8d25: " + e.getMessage())));
            return 0;
        }
    }

    private static int loadSchematic(CommandContext<CommandSourceStack> ctx, Void unused) throws CommandSyntaxException {
        String name = StringArgumentType.getString(ctx, (String)"shipName");
        BlockPos centerPos = ((CommandSourceStack)ctx.getSource()).m_81375_().m_20183_();
        return VsswCommands.loadSchematicInternal(ctx, name, centerPos, new Quaterniond());
    }

    private static int loadSchematic(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String name = StringArgumentType.getString(ctx, (String)"shipName");
        BlockPos centerPos = BlockPosArgument.m_118242_(ctx, (String)"pos");
        return VsswCommands.loadSchematicInternal(ctx, name, centerPos, new Quaterniond());
    }

    private static int loadSchematicWithEulerAngles(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String name = StringArgumentType.getString(ctx, (String)"shipName");
        BlockPos centerPos = BlockPosArgument.m_118242_(ctx, (String)"pos");
        RelativeVector3 eulerAngles = RelativeVector3Argument.Companion.getRelativeVector3(ctx, "euler-angles");
        Vec2 rotation = ((CommandSourceStack)ctx.getSource()).m_81376_();
        Quaterniond eulerRotationFromMCEntity = eulerAngles.toEulerRotationFromMCEntity((double)rotation.f_82470_, (double)rotation.f_82471_);
        return VsswCommands.loadSchematicInternal(ctx, name, centerPos, eulerRotationFromMCEntity);
    }

    private static int loadSchematicInternal(CommandContext<CommandSourceStack> ctx, String name, BlockPos centerPos, Quaterniond rot) {
        try {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            VsswSchematic schematic = VsswSchematic.loadFromFile(name, level);
            VsswVsManager.loadBlueprint(level, schematic, centerPos, rot);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u84dd\u56fe '" + name + "' \u5df2\u52a0\u8f7d\u5230\u4f4d\u7f6e: " + centerPos.m_123341_() + ", " + centerPos.m_123342_() + ", " + centerPos.m_123343_())), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("\u52a0\u8f7d\u5931\u8d25: " + e.getMessage())));
            return 0;
        }
    }

    private static int deleteSchematic(CommandContext<CommandSourceStack> ctx) {
        try {
            String name = StringArgumentType.getString(ctx, (String)"shipName");
            File dir = new File("vssw-schematics");
            File file = new File(dir, name + ".vssw");
            if (!file.exists()) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("\u84dd\u56fe '" + name + "' \u4e0d\u5b58\u5728")));
                return 0;
            }
            if (file.delete()) {
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u84dd\u56fe '" + name + "' \u5df2\u5220\u9664")), true);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("\u65e0\u6cd5\u5220\u9664\u84dd\u56fe '" + name + "'")));
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("\u5220\u9664\u5931\u8d25: " + e.getMessage())));
            return 0;
        }
    }

    private static int deleteShip(CommandContext<CommandSourceStack> ctx, boolean delRelated) {
        try {
            String name = StringArgumentType.getString(ctx, (String)"shipName");
            if (delRelated) {
                VsswVsManager.deleteAllRelatedShips(((CommandSourceStack)ctx.getSource()).m_81372_(), name);
            } else {
                VsswVsManager.deleteShip(((CommandSourceStack)ctx.getSource()).m_81372_(), name);
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)(name + "' deleted")), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("\u5220\u9664\u5931\u8d25: " + e.getMessage())));
            return 0;
        }
    }

    private static int deleteMasslessShips(CommandContext<CommandSourceStack> ctx) {
        int count = VsUtil.deleteMasslessShips(((CommandSourceStack)ctx.getSource()).m_81372_());
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)(count + "ships deleted")), true);
        return 1;
    }

    private static int listSchematics(CommandContext<CommandSourceStack> ctx) {
        File dir = new File("vssw-schematics");
        if (!dir.exists() || !dir.isDirectory()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u84dd\u56fe\u76ee\u5f55\u4e0d\u5b58\u5728"));
            return 0;
        }
        File[] files = dir.listFiles((d, name) -> name.endsWith(".vssw"));
        if (files == null || files.length == 0) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u6ca1\u6709\u627e\u5230\u84dd\u56fe\u6587\u4ef6"));
            return 0;
        }
        ArrayList names = Lists.newArrayList();
        for (File file : files) {
            names.add(file.getName().replace(".vssw", ""));
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u53ef\u7528\u7684\u84dd\u56fe (" + names.size() + "):")), false);
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < names.size(); ++i) {
            if (i > 0 && i % 5 == 0) {
                String str = line.toString();
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)str), false);
                line = new StringBuilder();
            }
            if (line.length() > 0) {
                line.append(", ");
            }
            line.append((String)names.get(i));
        }
        if (line.length() > 0) {
            String str = line.toString();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)str), false);
        }
        return names.size();
    }
}

