/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.compat.computercraft;

import dan200.computercraft.api.peripheral.IPeripheral;
import javax.annotation.Nonnull;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ForgeRegistries;
import net.shao.valkyrien_space_war.block.seat.base.BaseShipControlSeatBE;
import net.shao.valkyrien_space_war.block.thruster.base.AbstractThrusterBE;
import net.shao.valkyrien_space_war.block.turret.base.AbstractTurretBE;
import net.shao.valkyrien_space_war.compat.computercraft.peripherals.AbstractPeripheral;
import net.shao.valkyrien_space_war.compat.computercraft.peripherals.ShipControlSeatPeripheral;
import net.shao.valkyrien_space_war.compat.computercraft.peripherals.ThrusterPeripheral;
import net.shao.valkyrien_space_war.compat.computercraft.peripherals.TurretPeripheral;

public class ComputerCapability {
    protected static final Capability<IPeripheral> PERIPHERAL_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPeripheral>(){});
    private LazyOptional<IPeripheral> peripheral;
    private final BlockEntity blockEntity;
    private AbstractPeripheral abstractPeripheral;

    public ComputerCapability(BlockEntity be) {
        this.blockEntity = be;
    }

    public static NonNullSupplier<IPeripheral> getPeripheralFor(BlockEntity be) {
        if (be instanceof AbstractThrusterBE) {
            AbstractThrusterBE thrust = (AbstractThrusterBE)be;
            return () -> new ThrusterPeripheral(thrust);
        }
        if (be instanceof BaseShipControlSeatBE) {
            BaseShipControlSeatBE seat = (BaseShipControlSeatBE)be;
            return () -> new ShipControlSeatPeripheral(seat);
        }
        if (be instanceof AbstractTurretBE) {
            AbstractTurretBE turret = (AbstractTurretBE)be;
            return () -> new TurretPeripheral(turret);
        }
        throw new IllegalArgumentException("No peripheral available for " + ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)be.m_58903_()));
    }

    public <T> boolean isPeripheralCap(Capability<T> cap) {
        return cap == PERIPHERAL_CAPABILITY;
    }

    @Nonnull
    public <T> LazyOptional<T> getPeripheralCapability() {
        if (this.peripheral == null || !this.peripheral.isPresent()) {
            this.abstractPeripheral = (AbstractPeripheral)ComputerCapability.getPeripheralFor(this.blockEntity).get();
            this.peripheral = LazyOptional.of(() -> this.abstractPeripheral);
        }
        return this.peripheral.cast();
    }

    public void queueEvent(String event, Object[] arguments) {
        this.getPeripheralCapability();
        if (this.abstractPeripheral != null) {
            this.abstractPeripheral.queueEvent(event, arguments);
        }
    }

    public void removePeripheral() {
        if (this.peripheral != null) {
            this.peripheral.invalidate();
            this.peripheral = null;
            this.abstractPeripheral = null;
        }
    }

    public AbstractPeripheral getAbstractPeripheral() {
        this.getPeripheralCapability();
        return this.abstractPeripheral;
    }
}

