/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.compat.computercraft;

import java.util.function.Function;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.loading.LoadingModList;
import net.shao.valkyrien_space_war.compat.computercraft.ComputerCapability;

public class ComputerCraftProxy {
    private static Function<BlockEntity, ? extends ComputerCapability> computerFactory;

    public static void register() {
        if (ComputerCraftProxy.computerCraftInstalled()) {
            ComputerCraftProxy.registerWithDependency();
        }
    }

    private static boolean computerCraftInstalled() {
        return LoadingModList.get().getModFileById("computercraft") != null;
    }

    private static void registerWithDependency() {
        computerFactory = ComputerCapability::new;
    }

    public static ComputerCapability create(BlockEntity be) {
        if (computerFactory != null) {
            return computerFactory.apply(be);
        }
        return null;
    }
}

