/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.compat.fe;

import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.energy.IEnergyStorage;
import net.shao.valkyrien_space_war.block.base.IVsswSyncBe;
import net.shao.valkyrien_space_war.compat.gregtech.GTValuesDup;

public class FeStorageCapability
implements IEnergyStorage {
    public static final int GT_MULTIPLIER = 4;
    protected IVsswSyncBe syncBe;
    private final int capacity;
    private int energyStored;
    private int maxRec;

    public FeStorageCapability(IVsswSyncBe be, int capacity, int voltageLevel, long amperage) {
        this.syncBe = be;
        this.capacity = capacity;
        this.maxRec = (int)(amperage * GTValuesDup.V[voltageLevel] * 4L);
    }

    public int changeEnergyFromGt(long change) {
        return this.changeEnergy((int)Math.max(Math.min(change * 4L, Integer.MAX_VALUE), Integer.MIN_VALUE));
    }

    public int changeEnergy(int change) {
        if (change > 0) {
            return this.receiveEnergy(change, false);
        }
        return this.extractEnergy(-change, false);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int limit = Math.min(this.maxRec, maxReceive);
        int newEnergy = Math.max(0, Math.min(this.capacity, this.energyStored + limit));
        int delta = newEnergy - this.energyStored;
        if (!simulate) {
            this.energyStored = newEnergy;
        }
        if (Math.abs(delta) > 1) {
            this.syncBe.syncToClient();
        }
        return delta;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int limit = Math.min(this.maxRec, maxExtract);
        int newEnergy = Math.max(0, Math.min(this.capacity, this.energyStored - limit));
        int delta = this.energyStored - newEnergy;
        if (!simulate) {
            this.energyStored = newEnergy;
        }
        if (Math.abs(delta) > 1) {
            this.syncBe.syncToClient();
        }
        return delta;
    }

    public int getGtEnergyStored() {
        return this.getEnergyStored() / 4;
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public void putTag(CompoundTag tag) {
        tag.m_128405_("fe_stored", this.energyStored);
    }

    public void loadTag(CompoundTag tag) {
        this.energyStored = tag.m_128451_("fe_stored");
    }
}

