/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.compat.gregtech;

import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ForgeRegistries;
import net.shao.valkyrien_space_war.block.energy_shield.AbstractEnergyShieldBE;
import net.shao.valkyrien_space_war.block.turret.base.AbstractTurretBE;
import net.shao.valkyrien_space_war.compat.gregtech.VsswGtEnergyContainer;

public class GtEnergyCapability {
    protected static final Capability<IEnergyContainer> GTENERGY_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IEnergyContainer>(){});
    private LazyOptional<IEnergyContainer> gtEnergyContainer;
    private final BlockEntity blockEntity;
    private VsswGtEnergyContainer gtEnergyContainerInstance;
    private boolean initialized = false;

    public GtEnergyCapability(BlockEntity be) {
        this.blockEntity = be;
    }

    public static NonNullSupplier<IEnergyContainer> getGtEnergyContainer(BlockEntity be) {
        if (be instanceof AbstractTurretBE) {
            AbstractTurretBE turret = (AbstractTurretBE)be;
            return () -> new VsswGtEnergyContainer(turret, turret.getEnergyCapacity(), turret.getVoltageLevel(), turret.getInputAmperage());
        }
        if (be instanceof AbstractEnergyShieldBE) {
            AbstractEnergyShieldBE shield = (AbstractEnergyShieldBE)be;
            return () -> new VsswGtEnergyContainer(shield, shield.getEnergyCapacity(), shield.getVoltageLevel(), shield.getInputAmperage());
        }
        throw new IllegalArgumentException("No gt energy container available for " + ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)be.m_58903_()));
    }

    public <T> boolean isGtEnergyCap(Capability<T> cap) {
        return cap == GTENERGY_CAPABILITY;
    }

    @Nonnull
    public <T> LazyOptional<T> getGtEnergyCapability() {
        if (this.gtEnergyContainer == null || !this.gtEnergyContainer.isPresent()) {
            this.gtEnergyContainerInstance = (VsswGtEnergyContainer)GtEnergyCapability.getGtEnergyContainer(this.blockEntity).get();
            this.gtEnergyContainer = LazyOptional.of(() -> this.gtEnergyContainerInstance);
            this.initialized = true;
        }
        return this.gtEnergyContainer.cast();
    }

    public void invalidate() {
        if (this.gtEnergyContainer != null) {
            this.gtEnergyContainer.invalidate();
            this.gtEnergyContainer = null;
            this.gtEnergyContainerInstance = null;
        }
    }

    public VsswGtEnergyContainer getGtEnergyContainerInstance() {
        if (!this.initialized) {
            this.getGtEnergyCapability();
        }
        return this.gtEnergyContainerInstance;
    }

    public long getEnergyCapacity() {
        return this.getGtEnergyContainerInstance().getEnergyCapacity();
    }

    public long getInputAmperage() {
        return this.getGtEnergyContainerInstance().getInputAmperage();
    }

    public long getInputVoltage() {
        return this.getGtEnergyContainerInstance().getInputVoltage();
    }

    public int getVoltageLevel() {
        return this.getGtEnergyContainerInstance().getVoltageLevel();
    }

    public void putTag(CompoundTag tag) {
        tag.m_128356_("gtEnergy", this.getGtEnergyContainerInstance().getEnergyStored());
    }

    public void loadTag(CompoundTag tag) {
        this.getGtEnergyContainerInstance().setEnergyStored(tag.m_128454_("gtEnergy"));
    }

    public long getEnergyStored() {
        return this.getGtEnergyContainerInstance().getEnergyStored();
    }

    public long changeEnergy(long l) {
        return this.getGtEnergyContainerInstance().changeEnergy(l);
    }
}

