/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.compat.gregtech;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import net.minecraft.core.Direction;
import net.shao.valkyrien_space_war.block.base.IVsswSyncBe;

public class VsswGtEnergyContainer
implements IEnergyContainer {
    protected IVsswSyncBe syncBe;
    private long energyCapacity;
    private int voltageLevel;
    private long inputAmperage;
    private long energyStored = 0L;

    public VsswGtEnergyContainer(IVsswSyncBe syncBe, long energyCapacity, int voltageLevel, long inputAmperage) {
        this.syncBe = syncBe;
        this.energyCapacity = energyCapacity;
        this.voltageLevel = voltageLevel;
        this.inputAmperage = inputAmperage;
    }

    public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
        if (voltage > this.getInputVoltage()) {
            return 0L;
        }
        long acceptableAmperage = Math.min(amperage, this.inputAmperage);
        long energyToAdd = voltage * acceptableAmperage;
        long actualAdded = this.addEnergy(energyToAdd);
        return actualAdded / voltage;
    }

    public boolean inputsEnergy(Direction side) {
        return true;
    }

    public long changeEnergy(long differenceAmount) {
        long newEnergy = Math.max(0L, Math.min(this.getEnergyCapacity(), this.energyStored + differenceAmount));
        long delta = newEnergy - this.energyStored;
        this.energyStored = newEnergy;
        if (Math.abs(delta) > 1L) {
            this.syncBe.syncToClient();
        }
        return delta;
    }

    public long getEnergyStored() {
        return this.energyStored;
    }

    public void setEnergyStored(long energyStored) {
        this.energyStored = energyStored;
    }

    public long getEnergyCapacity() {
        return this.energyCapacity;
    }

    public int getVoltageLevel() {
        return this.voltageLevel;
    }

    public long getInputAmperage() {
        return this.inputAmperage;
    }

    public long getInputVoltage() {
        return GTValues.V[this.getVoltageLevel()];
    }
}

