/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.entity.custom;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.shao.valkyrien_space_war.entity.ai.AlienAttackGoal;
import org.jetbrains.annotations.Nullable;

public class AlienEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(AlienEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState attackingAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;

    public AlienEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.attackAnimationTimeout <= 0) {
            if (this.isAttacking()) {
                this.attackingAnimationState.m_216977_(this.f_19797_);
            } else {
                this.attackingAnimationState.m_216973_();
            }
            this.attackAnimationTimeout = 10;
        } else {
            --this.attackAnimationTimeout;
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new AlienAttackGoal(this, 1.0, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AlienEntity.class, true));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22285_, 8.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22283_, 64.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_11799_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11804_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11802_;
    }
}

