/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.shao.valkyrien_space_war.block.base.ModConnectorBE;
import net.shao.valkyrien_space_war.block.base.ModGuestBE;
import net.shao.valkyrien_space_war.block.base.ModHostBE;
import net.shao.valkyrien_space_war.block.thruster.base.ThrusterTrail;
import net.shao.valkyrien_space_war.function.camera.VsCameraDistHelper;
import net.shao.valkyrien_space_war.function.manager.ModResourceManager;
import net.shao.valkyrien_space_war.function.render.BeaconStyleRenderer;
import net.shao.valkyrien_space_war.function.render.CustomRenderTypes;
import net.shao.valkyrien_space_war.function.render.VoxelShapeRenderer;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import net.shao.valkyrien_space_war.input.InputInterceptor;
import net.shao.valkyrien_space_war.item.ModItems;
import net.shao.valkyrien_space_war.item.tool.P2PConnector;
import net.shao.valkyrien_space_war.item.tool.RiveterArrowRender;
import net.shao.valkyrien_space_war.projectile.base.ProjectileManager;
import net.shao.valkyrien_space_war.sound.LoopSoundController;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.mod.common.VSClientGameUtils;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ModClientEvent {
    private static int cleanupCounter = 0;
    public static final RenderType thickLines = CustomRenderTypes.createOutlineRenderType(6.0f);
    private static final float RED = 1.0f;
    private static final float GREEN = 0.5f;
    private static final float BLUE = 1.0f;
    private static final float ALPHA = 0.7f;

    @SubscribeEvent
    public static void onRenderCrosshair(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type() && InputInterceptor.isInputBlocked) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerArm(RenderArmEvent event) {
        if (InputInterceptor.isInputBlocked || Minecraft.m_91087_().m_91288_() != event.getPlayer()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            LoopSoundController.ACTIVE_SOUNDS.forEach((be, sound) -> Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)sound));
            ModConnectorBE.ALL_CONNECTOR_BE.clear();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ModConnectorBE.ALL_CONNECTOR_BE.removeIf(be -> be == null || be.m_58901_() || be.getClientShip() == null);
            ModConnectorBE.ALL_CONNECTOR_BE.forEach(ModConnectorBE::clientTick);
            if (++cleanupCounter >= 5) {
                cleanupCounter = 0;
                LoopSoundController.checkAndCleanup();
            }
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            if (player == null) {
                return;
            }
            Item item = player.m_21205_().m_41720_();
            if (item == ModItems.P2P_CONNECTOR.get()) {
                ModClientEvent.renderConnector(event.getPoseStack(), player.m_9236_(), player.m_21205_(), event.getPartialTick());
            } else if (item == ModItems.RIVETER.get()) {
                CompoundTag tag = player.m_21205_().m_41783_();
                if (tag == null || !tag.m_128441_("Marks")) {
                    return;
                }
                ListTag marks = tag.m_128437_("Marks", 10);
                PoseStack poseStack = event.getPoseStack();
                MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
                poseStack.m_85836_();
                Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
                poseStack.m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
                for (int i = 0; i < marks.size(); ++i) {
                    CompoundTag markTag = marks.m_128728_(i);
                    BlockPos pos = BlockPos.m_122022_((long)markTag.m_128454_("Pos"));
                    Direction face = Direction.m_122376_((int)markTag.m_128451_("Face"));
                    int rotation = markTag.m_128451_("Rotation");
                    RiveterArrowRender.renderArrow(poseStack, buffer, pos, face, rotation);
                }
                poseStack.m_85849_();
                buffer.m_109911_();
            }
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            VsCameraDistHelper.update();
            PoseStack poseStack = event.getPoseStack();
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            poseStack.m_85836_();
            Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            poseStack.m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
            if (!mc.m_91104_()) {
                float partialTick = event.getPartialTick();
                ProjectileManager.getClientProjectile().forEach((id, projectile) -> projectile.render(poseStack, buffer, partialTick));
                ModConnectorBE.ALL_CONNECTOR_BE.forEach(ModConnectorBE::renderTick);
                ModResourceManager.ALL_THRUSTER_TRAILS.removeIf(ThrusterTrail::needRemove);
                ModResourceManager.ALL_THRUSTER_TRAILS.forEach(t -> t.render(poseStack, buffer, partialTick));
                if (player != null) {
                    QueryableShipData allShips = VSGameUtilsKt.getAllShips((Level)player.m_9236_());
                    allShips.forEach(ship -> {});
                }
            }
            poseStack.m_85849_();
            buffer.m_109911_();
        }
    }

    public static void renderConnector(PoseStack poseStack, Level level, ItemStack stack, float partialTick) {
        Object cBe;
        BlockEntity selectionBE;
        Minecraft mc = Minecraft.m_91087_();
        BlockPos selectionPos = P2PConnector.getSelectionPos(stack);
        if (selectionPos != null && (selectionBE = level.m_7702_(selectionPos)) instanceof ModConnectorBE) {
            cBe = (ModConnectorBE)selectionBE;
            int color = selectionBE instanceof ModHostBE ? 4244735 : 6942894;
            BlockState state = level.m_8055_(selectionPos);
            VoxelShape shape = state.m_60808_((BlockGetter)level, selectionPos);
            ModClientEvent.renderBlockOutline(poseStack, mc, ((ModConnectorBE)cBe).getClientShip(), selectionPos, shape, color);
        }
        if ((cBe = mc.f_91077_) instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)cBe;
            BlockPos hitPos = blockHitResult.m_82425_();
            VoxelShape shape = level.m_8055_(hitPos).m_60808_((BlockGetter)level, hitPos);
            BlockEntity hitBE = level.m_7702_(hitPos);
            boolean isConnectorBE = hitBE instanceof ModConnectorBE;
            int color2 = isConnectorBE ? (hitBE instanceof ModHostBE ? 4244735 : 6942894) : 0xFF0000;
            ClientShip ship = VsUtil.getClientShip(hitPos.m_123341_(), hitPos.m_123342_(), hitPos.m_123343_());
            ModClientEvent.renderBlockOutline(poseStack, mc, ship, hitPos, shape, color2);
        }
        ModGuestBE.activeBE.removeIf(be -> be.getClientShip() == null || !ModClientEvent.isBlockEntityValid(be));
        ModGuestBE.activeBE.forEach(blockEntity -> {
            if (blockEntity.m_58904_() != level) {
                return;
            }
            ModClientEvent.renderConnections(blockEntity, poseStack, partialTick);
        });
    }

    public static void renderBlockOutline(PoseStack poseStack, Minecraft mc, ClientShip ship, BlockPos bp, VoxelShape shape, int color) {
        Vec3 pos;
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        Vec3 camera = mc.f_91063_.m_109153_().m_90583_();
        poseStack.m_85836_();
        VertexConsumer consumer = buffer.m_6299_(thickLines);
        Quaterniond rot = null;
        if (ship != null) {
            Matrix4dc shipToWorld = ship.getRenderTransform().getShipToWorld();
            Vector3d vector3d = shipToWorld.transformPosition(new Vector3d((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_()));
            pos = new Vec3(vector3d.x, vector3d.y, vector3d.z);
            rot = shipToWorld.getNormalizedRotation(new Quaterniond());
        } else {
            pos = new Vec3((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_());
        }
        poseStack.m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
        VoxelShapeRenderer.renderVoxelShape(poseStack, consumer, shape, pos.f_82479_, pos.f_82480_, pos.f_82481_, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 0.8f, false, rot, false);
        poseStack.m_85849_();
        buffer.m_109911_();
    }

    private static void renderConnections(ModGuestBE blockEntity, PoseStack poseStack, float partialTick) {
        BlockPos parentPos = blockEntity.getParent();
        if (parentPos == null) {
            return;
        }
        poseStack.m_85836_();
        Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        poseStack.m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
        BlockPos bePos = blockEntity.m_58899_();
        Vec3 start = new Vec3((double)bePos.m_123341_() + 0.5, (double)bePos.m_123342_() + 0.5, (double)bePos.m_123343_() + 0.5);
        ClientShip startPosShip = VSClientGameUtils.getClientShip((double)start.f_82479_, (double)start.f_82480_, (double)start.f_82481_);
        if (startPosShip != null) {
            Vector3d vector3d = startPosShip.getRenderTransform().getShipToWorld().transformPosition(new Vector3d(start.f_82479_, start.f_82480_, start.f_82481_));
            start = new Vec3(vector3d.x, vector3d.y, vector3d.z);
        }
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 end = new Vec3((double)parentPos.m_123341_() + 0.5, (double)parentPos.m_123342_() + 0.5, (double)parentPos.m_123343_() + 0.5);
        ClientShip endPosShip = VSClientGameUtils.getClientShip((double)end.f_82479_, (double)end.f_82480_, (double)end.f_82481_);
        if (endPosShip != null) {
            Vector3d vector3d = endPosShip.getRenderTransform().getShipToWorld().transformPosition(new Vector3d(end.f_82479_, end.f_82480_, end.f_82481_));
            end = new Vec3(vector3d.x, vector3d.y, vector3d.z);
        }
        BeaconStyleRenderer.renderCustomBeam(poseStack, (MultiBufferSource)buffer, partialTick, 1.0f, Minecraft.m_91087_().f_91073_.m_46467_(), start, end, new float[]{0.3f, 1.0f, 0.75f}, 0.01f, 0.075f, 1.0f, 0.5f);
        poseStack.m_85849_();
        buffer.m_109911_();
    }

    private static void renderLine(PoseStack poseStack, VertexConsumer consumer, Vec3 start, Vec3 end) {
        Vec3 direction = end.m_82546_(start);
        direction = direction.m_82541_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        consumer.m_252986_(matrix, (float)start.f_82479_, (float)start.f_82480_, (float)start.f_82481_).m_85950_(1.0f, 0.5f, 1.0f, 0.7f).m_5601_((float)direction.f_82479_, (float)direction.f_82480_, (float)direction.f_82481_).m_5752_();
        consumer.m_252986_(matrix, (float)end.f_82479_, (float)end.f_82480_, (float)end.f_82481_).m_85950_(1.0f, 0.5f, 1.0f, 0.7f).m_5601_((float)direction.f_82479_, (float)direction.f_82480_, (float)direction.f_82481_).m_5752_();
    }

    public static boolean isBlockEntityValid(BlockEntity be) {
        Level level = be.m_58904_();
        if (level == null) {
            return false;
        }
        BlockPos pos = be.m_58899_();
        return level.m_46805_(pos);
    }
}

