/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.shao.valkyrien_space_war.block.base.ModConnectorBE;
import net.shao.valkyrien_space_war.block.base.PhyGuestBE;
import net.shao.valkyrien_space_war.block.turret.base.TurretCameraEntity;
import net.shao.valkyrien_space_war.event.VSPhyTickEvent;
import net.shao.valkyrien_space_war.function.manager.EntityClassifier;
import net.shao.valkyrien_space_war.function.manager.ModResourceManager;
import net.shao.valkyrien_space_war.function.terrain.ChunkLoadManager;
import net.shao.valkyrien_space_war.function.terrain.ServerTerrainCache3d;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.turret.ResetCameraZoomPacket;
import net.shao.valkyrien_space_war.projectile.base.ProjectileManager;
import net.shao.valkyrien_space_war.projectile.base.VSSWProjectile;
import net.shao.valkyrien_space_war.projectile.base.VSSWProjectileEvent;

@Mod.EventBusSubscriber(modid="valkyrien_space_war", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEvent {
    private static final ArrayList<Task> ON_SERVER_TICK_LISTENERS = new ArrayList();

    public static void addOnServerTickListener(int delayTick, Runnable listener) {
        ON_SERVER_TICK_LISTENERS.add(new Task(delayTick, listener));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ON_SERVER_TICK_LISTENERS.forEach(task -> --task.delay);
            ON_SERVER_TICK_LISTENERS.removeIf(task -> {
                if (task.delay <= 0) {
                    task.runnable.run();
                    return true;
                }
                return false;
            });
            event.getServer().m_129785_().iterator().forEachRemaining(world -> ChunkLoadManager.getManagerForLevel(world).checkExpiredChunks());
            ProjectileManager.getServerProjectile().forEach((id, projectile) -> projectile.tick());
        }
        if (event.phase == TickEvent.Phase.END) {
            ModResourceManager.allConnectorBe.removeIf(BlockEntity::m_58901_);
            ModResourceManager.allConnectorBe.forEach(ModConnectorBE::tickEnd);
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        if (!event.getLevel().m_5776_()) {
            ChunkLoadManager.getManagerForLevel((ServerLevel)event.getLevel()).onWorldUnload();
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            ServerTerrainCache3d.updateCache(level, event.getChunk().m_7697_());
        }
    }

    @SubscribeEvent
    public static void vsPhyTick(VSPhyTickEvent event) {
        ProjectileManager.getServerProjectile().forEach((id, projectile) -> {
            if (projectile.isVsPhyTick()) {
                projectile.vsPhyTick();
            }
        });
        if (ModResourceManager.allConnectorBe != null) {
            ModResourceManager.allConnectorBe.forEach(connector -> {
                if (!connector.m_58901_() && connector instanceof PhyGuestBE) {
                    PhyGuestBE be = (PhyGuestBE)((Object)connector);
                    be.phyTick();
                }
            });
        }
    }

    @SubscribeEvent
    public static void onVSSWProjectileSpawn(VSSWProjectileEvent.OnSpawn event) {
        VSSWProjectile projectile = event.getProjectile();
        ProjectileManager.addServerProjectile(projectile);
    }

    @SubscribeEvent
    public static void onVSSWProjectileRemove(VSSWProjectileEvent.OnRemove event) {
        VSSWProjectile projectile = event.getProjectile();
        ProjectileManager.getServerProjectile().remove(projectile.getID());
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        Level level = event.getLevel();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            switch (EntityClassifier.classify(entity)) {
                case MONSTER: {
                    ModResourceManager.allMonsters.computeIfAbsent(level, k -> new HashSet()).add(livingEntity);
                    break;
                }
                case ANIMAL: {
                    ModResourceManager.allAnimals.computeIfAbsent(level, k -> new HashSet()).add(livingEntity);
                    break;
                }
                case PLAYER: {
                    ModResourceManager.allPlayers.computeIfAbsent(level, k -> new HashSet()).add(livingEntity);
                }
            }
            ModResourceManager.allLivingEntities.computeIfAbsent(level, k -> new HashSet()).add(livingEntity);
        } else if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            ModResourceManager.allProjectiles.computeIfAbsent(level, k -> new HashMap()).put(projectile.m_19879_(), projectile);
        }
    }

    @SubscribeEvent
    public static void onEntityLeave(EntityLeaveLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        Level level = event.getLevel();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            switch (EntityClassifier.classify(entity)) {
                case MONSTER: {
                    ModResourceManager.allMonsters.get(level).remove(livingEntity);
                    break;
                }
                case ANIMAL: {
                    ModResourceManager.allAnimals.get(level).remove(livingEntity);
                    break;
                }
                case PLAYER: {
                    ModResourceManager.allPlayers.get(level).remove(livingEntity);
                }
            }
            ModResourceManager.allLivingEntities.get(level).remove(livingEntity);
        } else if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            ModResourceManager.allProjectiles.get(level).remove(projectile.m_19879_());
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        ServerPlayer player;
        TurretCameraEntity turretCameraEntity;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (turretCameraEntity = TurretCameraEntity.cameraEntities.get(player = (ServerPlayer)livingEntity)) != null) {
            turretCameraEntity.remove();
            player.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)player));
            ModNetworkHandler.sendToPlayer(player, new ResetCameraZoomPacket());
        }
    }

    private static class Task {
        public int delay;
        public Runnable runnable;

        public Task(int delay, Runnable runnable) {
            this.delay = delay;
            this.runnable = runnable;
        }
    }
}

