/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.mixinducks.ISilentExplosionDuck;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.particle.HighExplosionParticlePacket;
import net.shao.valkyrien_space_war.particle.explotion.HighExplosionOptions;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ExplosionHelper {
    public static Explosion createSilentExplosion(Level level, @Nullable Entity source, double x, double y, double z, float radius, boolean fire, Explosion.BlockInteraction interaction) {
        Explosion explosion = new Explosion(level, source, x, y, z, radius, fire, interaction);
        ((ISilentExplosionDuck)explosion).setSilent(true);
        return explosion;
    }

    public static void performSilentExplosion(Level level, @Nullable Entity source, double x, double y, double z, float radius, boolean fire, Explosion.BlockInteraction interaction) {
        Explosion explosion = ExplosionHelper.createSilentExplosion(level, source, x, y, z, radius, fire, interaction);
        explosion.m_46061_();
        explosion.m_46075_(false);
    }

    public static void createHighExplosion(Level level, @Nullable Entity source, Vector3f dir, Vec3 pos, float power, boolean fire) {
        ExplosionHelper.createHighExplosion(level, source, dir, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), power, fire);
    }

    public static void createHighExplosion(Level level, @Nullable Entity source, Vector3f dir, double x, double y, double z, float power, boolean fire) {
        float scale = 0.5f + power * 1.25f;
        float expansionSpeed = 0.15f + power * 0.05f;
        int duration = 40 + (int)(power * 10.0f);
        if (level.f_46443_) {
            level.m_7106_((ParticleOptions)new HighExplosionOptions(scale, expansionSpeed, dir.x(), dir.y(), dir.z(), duration), x, y, z, 0.0, 0.0, 0.0);
        } else {
            ServerLevel serverLevel = (ServerLevel)level;
            ModNetworkHandler.sendToNearbyPlayers(128, (Level)serverLevel, new BlockPos((int)x, (int)y, (int)z), new HighExplosionParticlePacket(x, y, z, scale, expansionSpeed, dir, duration));
        }
        ExplosionHelper.performSilentExplosion(level, null, x, y, z, power, fire, Explosion.BlockInteraction.DESTROY_WITH_DECAY);
    }
}

