/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.camera;

import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="valkyrien_space_war", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
@OnlyIn(value=Dist.CLIENT)
public class CameraZoomHandler {
    private static final float ZOOM_SPEED = 0.25f;
    private static float targetZoom = 1.0f;
    private static float currentZoom = 1.0f;
    private static boolean isZooming = false;
    public static double baseSensitivity;
    private static int callCount;

    public static void zoomIn() {
        CameraZoomHandler.setTargetZoom(currentZoom + 0.5f);
    }

    public static void zoomOut() {
        CameraZoomHandler.setTargetZoom(currentZoom - 0.5f);
    }

    public static boolean isZooming() {
        return isZooming;
    }

    private static void setTargetZoom(float zoom) {
        targetZoom = Mth.m_14036_((float)zoom, (float)1.0f, (float)10.0f);
        isZooming = true;
    }

    public static void scale(float zoom) {
        CameraZoomHandler.setTargetZoom(currentZoom + zoom);
    }

    public static void init() {
        baseSensitivity = (Double)Minecraft.m_91087_().f_91066_.m_231964_().m_231551_() * 0.6 + 0.2;
    }

    public static double getEffectiveSensitivity() {
        if (++callCount >= 100) {
            CameraZoomHandler.init();
            callCount = 0;
        }
        return baseSensitivity * (double)(1.0f / currentZoom);
    }

    public static void resetZoom() {
        targetZoom = 1.0f;
        isZooming = true;
    }

    @SubscribeEvent
    public static void onCameraZoom(ViewportEvent.ComputeFov event) {
        if (isZooming) {
            float deltaTime = Minecraft.m_91087_().m_91297_();
            float damping = 0.25f * deltaTime;
            currentZoom += (targetZoom - currentZoom) * damping;
            if (Math.abs(targetZoom - (currentZoom = Mth.m_14036_((float)currentZoom, (float)1.0f, (float)10.0f))) < 0.001f) {
                currentZoom = targetZoom;
                isZooming = !Mth.m_14033_((float)currentZoom, (float)1.0f);
            }
            double originalFOV = event.getFOV();
            double scaledFOV = originalFOV / (double)currentZoom;
            event.setFOV(Math.max(scaledFOV, 5.0));
        }
    }

    static {
        callCount = 100;
    }
}

