/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.camera;

public class VsCameraDistHelper {
    private static double currentDistMultiplier = 1.0;
    private static double targetDistMultiplier = 1.0;
    private static final double SMOOTH_SPEED = 0.05;
    private static final double ZOOM_STEP = 1.01;
    private static final double MIN = 0.25;
    private static final double MAX = 10.0;

    private VsCameraDistHelper() {
    }

    public static void update() {
        if (Math.abs(targetDistMultiplier - (currentDistMultiplier += (targetDistMultiplier - currentDistMultiplier) * 0.05)) < 0.001) {
            currentDistMultiplier = targetDistMultiplier;
        }
    }

    public static void setDistMultiplier(double multiplier) {
        targetDistMultiplier = Math.min(10.0, Math.max(0.25, multiplier));
    }

    public static double getDistMultiplier() {
        return currentDistMultiplier;
    }

    public static void zoomIn() {
        VsCameraDistHelper.setDistMultiplier(targetDistMultiplier / 1.01);
    }

    public static void zoomOut() {
        VsCameraDistHelper.setDistMultiplier(targetDistMultiplier * 1.01);
    }
}

