/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class EntityClassifier {
    public static final Set<EntityType<?>> MONSTER_TYPES = Set.of(EntityType.f_20501_, EntityType.f_20524_, EntityType.f_20558_, EntityType.f_20566_, EntityType.f_20479_, EntityType.f_20554_, EntityType.f_20495_, EntityType.f_20551_, EntityType.f_20453_, EntityType.f_20468_, EntityType.f_20526_, EntityType.f_20509_, EntityType.f_20493_, EntityType.f_20568_, EntityType.f_20513_, EntityType.f_20518_, EntityType.f_20458_, EntityType.f_20481_, EntityType.f_20455_, EntityType.f_20563_, EntityType.f_20521_, EntityType.f_20523_, EntityType.f_20567_, EntityType.f_20491_, EntityType.f_20456_, EntityType.f_20500_, EntityType.f_20511_, EntityType.f_20512_, EntityType.f_20531_, EntityType.f_217015_, EntityType.f_20565_, EntityType.f_20496_);
    public static final Set<EntityType<?>> ANIMAL_TYPES = Set.of(EntityType.f_20557_, EntityType.f_20510_, EntityType.f_20520_, EntityType.f_20555_, EntityType.f_20517_, EntityType.f_20457_, EntityType.f_20560_, EntityType.f_20503_, EntityType.f_20466_, EntityType.f_20488_, EntityType.f_20452_, EntityType.f_20507_, EntityType.f_20514_, EntityType.f_20505_, EntityType.f_20553_, EntityType.f_20499_, EntityType.f_20508_, EntityType.f_20490_, EntityType.f_20559_, EntityType.f_20550_, EntityType.f_147039_, EntityType.f_147035_, EntityType.f_217012_, EntityType.f_271264_);
    public static final EntityType<?> PLAYER_TYPE = EntityType.f_20532_;
    private static final Map<EntityType<?>, Category> TYPE_CACHE = new HashMap();

    public static Category classify(Entity entity) {
        return TYPE_CACHE.getOrDefault(entity.m_6095_(), Category.OTHER);
    }

    static {
        MONSTER_TYPES.forEach(t -> TYPE_CACHE.put((EntityType<?>)t, Category.MONSTER));
        ANIMAL_TYPES.forEach(t -> TYPE_CACHE.put((EntityType<?>)t, Category.ANIMAL));
        TYPE_CACHE.put(PLAYER_TYPE, Category.PLAYER);
    }

    public static enum Category {
        MONSTER,
        ANIMAL,
        PLAYER,
        OTHER;

    }
}

