/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BeaconStyleRenderer {
    private static final ResourceLocation OPA_BEACON_BEAM = new ResourceLocation("valkyrien_space_war", "textures/entity/opa_beacon_beam.png");
    private static final RenderType BEACON_BEAM = RenderType.m_110460_((ResourceLocation)OPA_BEACON_BEAM, (boolean)false);
    private static final RenderType BEACON_BEAM_GLOW = RenderType.m_110460_((ResourceLocation)OPA_BEACON_BEAM, (boolean)true);

    public static void renderCustomBeam(PoseStack poseStack, MultiBufferSource bufferSource, float partialTick, float textureScale, long gameTime, Vec3 start, Vec3 end, float[] colors, float beamRadius, float glowRadius, float alpha1, float alpha2) {
        BeaconStyleRenderer.renderCustomBeamWithRenderType(poseStack, bufferSource, partialTick, textureScale, gameTime, start, end, colors, beamRadius, glowRadius, alpha1, alpha2, BEACON_BEAM, BEACON_BEAM_GLOW);
    }

    public static void renderCustomBeamWithRenderType(PoseStack poseStack, MultiBufferSource bufferSource, float partialTick, float textureScale, long gameTime, Vec3 start, Vec3 end, float[] colors, float beamRadius, float glowRadius, float alpha1, float alpha2, RenderType inner, RenderType outer) {
        Vec3 direction = end.m_82546_(start);
        float height = (float)direction.m_82553_();
        direction = direction.m_82541_();
        Quaternionf rotation = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)new Vector3f((float)direction.f_82479_, (float)direction.f_82480_, (float)direction.f_82481_));
        poseStack.m_85836_();
        poseStack.m_85837_(start.f_82479_, start.f_82480_, start.f_82481_);
        poseStack.m_252781_(rotation);
        float f = (float)Math.floorMod(gameTime, 40) + partialTick;
        float f1 = height < 0.0f ? f : -f;
        float f2 = Mth.m_14187_((float)(f1 * 0.2f - (float)Mth.m_14143_((float)(f1 * 0.1f))));
        boolean yOffset = false;
        int renderHeight = (int)height;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(f * 9.0f - 45.0f));
        float f9 = -beamRadius;
        float f15 = -1.0f + f2;
        float f16 = (float)renderHeight * textureScale * (0.5f / beamRadius) + f15;
        BeaconStyleRenderer.renderPart(poseStack, bufferSource.m_6299_(BEACON_BEAM), colors[0], colors[1], colors[2], alpha1, (float)yOffset, renderHeight, 0.0f, beamRadius, beamRadius, 0.0f, f9, 0.0f, 0.0f, f9, 0.0f, 1.0f, f16, f15);
        f9 = -glowRadius;
        f15 = -1.0f + f2;
        f16 = (float)renderHeight * textureScale + f15;
        BeaconStyleRenderer.renderPart(poseStack, bufferSource.m_6299_(BEACON_BEAM_GLOW), colors[0], colors[1], colors[2], alpha2, (float)yOffset, renderHeight, 0.0f, glowRadius, glowRadius, 0.0f, f9, 0.0f, 0.0f, f9, 0.0f, 1.0f, f16, f15);
        poseStack.m_85849_();
    }

    private static void renderPart(PoseStack pPoseStack, VertexConsumer pConsumer, float pRed, float pGreen, float pBlue, float pAlpha, float pMinY, float pMaxY, float pX0, float pZ0, float pX1, float pZ1, float pX2, float pZ2, float pX3, float pZ3, float pMinU, float pMaxU, float pMinV, float pMaxV) {
        PoseStack.Pose posestack$pose = pPoseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        BeaconStyleRenderer.renderQuad(matrix4f, matrix3f, pConsumer, pRed, pGreen, pBlue, pAlpha, pMinY, pMaxY, pX0, pZ0, pX1, pZ1, pMinU, pMaxU, pMinV, pMaxV);
        BeaconStyleRenderer.renderQuad(matrix4f, matrix3f, pConsumer, pRed, pGreen, pBlue, pAlpha, pMinY, pMaxY, pX3, pZ3, pX2, pZ2, pMinU, pMaxU, pMinV, pMaxV);
        BeaconStyleRenderer.renderQuad(matrix4f, matrix3f, pConsumer, pRed, pGreen, pBlue, pAlpha, pMinY, pMaxY, pX1, pZ1, pX3, pZ3, pMinU, pMaxU, pMinV, pMaxV);
        BeaconStyleRenderer.renderQuad(matrix4f, matrix3f, pConsumer, pRed, pGreen, pBlue, pAlpha, pMinY, pMaxY, pX2, pZ2, pX0, pZ0, pMinU, pMaxU, pMinV, pMaxV);
    }

    private static void renderQuad(Matrix4f pPose, Matrix3f pNormal, VertexConsumer pConsumer, float pRed, float pGreen, float pBlue, float pAlpha, float pMinY, float pMaxY, float pMinX, float pMinZ, float pMaxX, float pMaxZ, float pMinU, float pMaxU, float pMinV, float pMaxV) {
        BeaconStyleRenderer.addVertex(pPose, pNormal, pConsumer, pRed, pGreen, pBlue, pAlpha, pMaxY, pMinX, pMinZ, pMaxU, pMinV);
        BeaconStyleRenderer.addVertex(pPose, pNormal, pConsumer, pRed, pGreen, pBlue, pAlpha, pMinY, pMinX, pMinZ, pMaxU, pMaxV);
        BeaconStyleRenderer.addVertex(pPose, pNormal, pConsumer, pRed, pGreen, pBlue, pAlpha, pMinY, pMaxX, pMaxZ, pMinU, pMaxV);
        BeaconStyleRenderer.addVertex(pPose, pNormal, pConsumer, pRed, pGreen, pBlue, pAlpha, pMaxY, pMaxX, pMaxZ, pMinU, pMinV);
    }

    private static void addVertex(Matrix4f pPose, Matrix3f pNormal, VertexConsumer pConsumer, float pRed, float pGreen, float pBlue, float pAlpha, float pY, float pX, float pZ, float pU, float pV) {
        pConsumer.m_252986_(pPose, pX, pY, pZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_7421_(pU, pV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

