/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.render;

import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class CameraShakeEffect {
    private static float shakeIntensity = 0.0f;
    private static float currentShake = 0.0f;
    private static int shakeDuration = 0;
    private static int shakeTimer = 0;
    private static final Random random = new Random();
    private static final float DECAY_RATE = 0.5f;
    private static final float MAX_SHAKE = 0.05f;
    private static final float NOISE_SPEED = 0.5f;
    private static final float ROTATION_INTENSITY = 0.05f;
    private static final float SMOOTH_FACTOR = 0.15f;
    private static final float NOISE_SCALE = 0.05f;
    private static float prevPitchOffset = 0.0f;
    private static float prevYawOffset = 0.0f;
    private static float prevRollOffset = 0.0f;

    public static void shakeScreen(float intensity, int duration) {
        shakeIntensity = Mth.m_14036_((float)intensity, (float)0.0f, (float)1.0f);
        shakeDuration = duration;
        shakeTimer = 0;
        currentShake = intensity;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (shakeDuration > 0) {
                currentShake = shakeIntensity * (float)Math.pow(0.5, ++shakeTimer);
                if (shakeTimer >= shakeDuration || currentShake < 0.001f) {
                    currentShake = 0.0f;
                    shakeDuration = 0;
                }
            } else {
                currentShake = 0.0f;
                shakeDuration = 0;
            }
        }
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SKY) {
            return;
        }
        if (currentShake < 0.001f) {
            return;
        }
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Matrix4f projectionMatrix = event.getProjectionMatrix();
        Vector3f offset = CameraShakeEffect.calculateShakeOffset();
        Matrix4f shakeMatrix = new Matrix4f();
        shakeMatrix.translation(offset.x, offset.y, offset.z);
        Minecraft.m_91087_().f_91063_.m_252879_(projectionMatrix.mul((Matrix4fc)shakeMatrix));
    }

    @SubscribeEvent
    public static void onComputeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        if (currentShake < 0.001f) {
            return;
        }
        float partialTick = Minecraft.m_91087_().getPartialTick();
        float time = ((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTick) * 0.5f;
        Vector3f noise = new Vector3f(CameraShakeEffect.perlinNoise(time, 0.035f), CameraShakeEffect.perlinNoise(time + 1000.0f, 0.025f), CameraShakeEffect.perlinNoise(time + 2000.0f, 0.015000001f));
        float targetPitch = (float)(Math.toDegrees(noise.x * 2.0f - 1.0f) * (double)currentShake * (double)0.05f);
        float targetYaw = (float)(Math.toDegrees(noise.y * 2.0f - 1.0f) * (double)currentShake * (double)0.05f);
        float targetRoll = (float)(Math.toDegrees(noise.z * 2.0f - 1.0f) * (double)currentShake * (double)0.05f * 0.5);
        float smoothPitch = CameraShakeEffect.lerp(prevPitchOffset, targetPitch, 0.15f);
        float smoothYaw = CameraShakeEffect.lerp(prevYawOffset, targetYaw, 0.15f);
        float smoothRoll = CameraShakeEffect.lerp(prevRollOffset, targetRoll, 0.15f);
        event.setPitch(event.getPitch() + smoothPitch);
        event.setYaw(event.getYaw() + smoothYaw);
        event.setRoll(event.getRoll() + smoothRoll);
        prevPitchOffset = smoothPitch;
        prevYawOffset = smoothYaw;
        prevRollOffset = smoothRoll;
    }

    private static float lerp(float a, float b, float t) {
        return a + t * (b - a);
    }

    private static Vector3f calculateShakeOffset() {
        float time = (float)Minecraft.m_91087_().f_91074_.f_19797_ * 0.5f;
        float actualIntensity = currentShake * 0.05f;
        float x = CameraShakeEffect.perlinNoise(time, 20.0f) * actualIntensity;
        float y = CameraShakeEffect.perlinNoise(time + 1000.0f, 100.0f) * actualIntensity;
        float z = CameraShakeEffect.perlinNoise(time + 500.0f, 100.0f) * actualIntensity;
        return new Vector3f(x, y, z);
    }

    private static float perlinNoise(float x, float frequency) {
        float fx = x * frequency;
        int ix = (int)fx;
        float frac = fx - (float)ix;
        float grad1 = random.nextFloat() * 2.0f - 1.0f;
        float grad2 = random.nextFloat() * 2.0f - 1.0f;
        float u = frac * frac * (3.0f - 2.0f * frac);
        return grad1 * (1.0f - u) + grad2 * u;
    }

    public static void triggerShakeScreen(Vector3f explosionPos, float maxDis) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        float distance = (float)Math.sqrt(Mth.m_14207_((float)(explosionPos.x - (float)mc.f_91074_.m_20185_())) + Mth.m_14207_((float)(explosionPos.z - (float)mc.f_91074_.m_20189_())));
        float intensity = Mth.m_14036_((float)(1.0f - distance / maxDis), (float)0.0f, (float)1.0f);
        if (intensity > 0.1f) {
            CameraShakeEffect.shakeScreen(intensity, 1 + (int)(maxDis * intensity));
        }
    }
}

