/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class ModGuiUtil {
    private static final float DEG_TO_RAD = (float)Math.PI / 180;

    public static float parseFloat(String value) {
        String cleanedValue = value.replaceAll("[^\\d.-]", "");
        if (cleanedValue.isEmpty()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(cleanedValue);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static boolean isAllDigits(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String filterNumbers(String inputStr) {
        if (inputStr == null) {
            return "";
        }
        return inputStr.replaceAll("[^0-9]", "");
    }

    public static int filterToInt(String inputStr) {
        String numbers = ModGuiUtil.filterNumbers(inputStr);
        if (numbers.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(numbers);
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }

    public static String formatNumberRightAlign(int number, int length) {
        int availableLength;
        String s = String.valueOf(number);
        boolean isNegative = s.startsWith("-");
        String numPart = isNegative ? s.substring(1) : s;
        int n = availableLength = isNegative ? length - 1 : length;
        if (numPart.length() > availableLength) {
            numPart = numPart.substring(numPart.length() - availableLength);
        }
        Object result = isNegative ? "-" + numPart : numPart;
        return String.format("%" + length + "s", result);
    }

    public static String[] splitFirstOccurrence(String input, String delimiter) {
        if (input == null || input.isEmpty() || delimiter == null || delimiter.isEmpty()) {
            return new String[2];
        }
        String regex = Pattern.quote(delimiter);
        return input.split(regex, 2);
    }

    public static void fillSector(GuiGraphics guiGraphics, int centerX, int centerY, int radius, float startAngle, float endAngle, int color) {
        int rsq = radius * radius;
        TreeMap<Integer, List> yIntervals = new TreeMap<Integer, List>();
        for (int x = centerX - radius; x <= centerX + radius; ++x) {
            for (int y2 = centerY - radius; y2 <= centerY + radius; ++y2) {
                float angle;
                int dx = centerX - x;
                int dy = y2 - centerY;
                if (dx * dx + dy * dy > rsq || !ModGuiUtil.isAngleInRange(angle = (float)Math.toDegrees(Math.atan2(dx, dy)), startAngle, endAngle, 0.5f)) continue;
                yIntervals.computeIfAbsent(y2, k -> new ArrayList()).add(new int[]{x, x});
            }
        }
        TreeMap mergedYIntervals = new TreeMap();
        yIntervals.forEach((y, intervals) -> mergedYIntervals.put(y, ModGuiUtil.mergeIntervals(intervals)));
        ArrayList<int[]> verticalRects = new ArrayList<int[]>();
        int[] currentRect = null;
        for (Map.Entry entry : mergedYIntervals.entrySet()) {
            int y3 = (Integer)entry.getKey();
            List intervals2 = (List)entry.getValue();
            for (int[] interval : intervals2) {
                if (currentRect != null && currentRect[0] == interval[0] && currentRect[1] == interval[1] && currentRect[3] == y3 - 1) {
                    currentRect[3] = y3;
                    continue;
                }
                currentRect = new int[]{interval[0], y3, interval[1], y3};
                verticalRects.add(currentRect);
            }
        }
        for (int[] rect : verticalRects) {
            guiGraphics.m_280509_(rect[0], rect[1], rect[2] + 1, rect[3] + 1, color);
        }
    }

    private static List<int[]> mergeIntervals(List<int[]> intervals) {
        if (intervals.isEmpty()) {
            return intervals;
        }
        intervals.sort(Comparator.comparingInt(a -> a[0]));
        ArrayList<int[]> merged = new ArrayList<int[]>();
        int[] current = intervals.get(0);
        for (int[] next : intervals) {
            if (next[0] <= current[1] + 1) {
                current[1] = Math.max(current[1], next[1]);
                continue;
            }
            merged.add(current);
            current = next;
        }
        merged.add(current);
        return merged;
    }

    private static boolean isAngleInRange(float angle, float start, float end, float tolerance) {
        if ((angle = (angle + 360.0f) % 360.0f) > 180.0f) {
            angle -= 360.0f;
        }
        if (start > end) {
            return angle >= start - tolerance || angle <= end + tolerance;
        }
        return angle >= start - tolerance && angle <= end + tolerance;
    }

    public static String formatEnergyValue(long value) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        String[] units = new String[]{"K", "M", "G", "T"};
        long[] thresholds = new long[]{1000L, 1000000L, 1000000000L, 1000000000000L};
        int unitIndex = -1;
        for (int i = thresholds.length - 1; i >= 0; --i) {
            if (value < thresholds[i]) continue;
            unitIndex = i;
            break;
        }
        if (unitIndex == -1) {
            unitIndex = units.length - 1;
        }
        double converted = (double)value / (double)thresholds[unitIndex];
        String unit = units[unitIndex];
        if (unitIndex > 0 && value < thresholds[unitIndex]) {
            converted = (double)value / (double)thresholds[unitIndex - 1];
            unit = units[unitIndex - 1];
        }
        DecimalFormat df = new DecimalFormat("#.#");
        df.setRoundingMode(RoundingMode.HALF_UP);
        return df.format(converted) + unit;
    }

    public static int convertToColorInt(String input) {
        String cleanInput = input.replaceAll("^0[xX]", "");
        StringBuilder hexBuilder = new StringBuilder();
        Pattern pattern = Pattern.compile("[0-9a-fA-F]");
        Matcher matcher = pattern.matcher(cleanInput);
        while (matcher.find()) {
            hexBuilder.append(matcher.group().toUpperCase());
        }
        String hexStr = hexBuilder.toString();
        hexStr = hexStr.length() < 8 ? String.format("%-8s", hexStr).replace(' ', 'F') : hexStr.substring(0, 8);
        try {
            long longValue = Long.parseLong(hexStr, 16);
            return (int)longValue;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static String intToHexString(int color) {
        long unsignedColor = (long)color & 0xFFFFFFFFL;
        return String.format("0x%08X", unsignedColor);
    }

    public static void drawLine(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, float width, int color) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float length = Mth.m_14116_((float)(dx * dx + dy * dy));
        float angle = (float)Math.toDegrees(Math.atan2(dy, dx));
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x1, y1, 0.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(angle));
        guiGraphics.m_285795_(RenderType.m_285907_(), 0, -((int)width) / 2, (int)length, (int)width / 2, 0, color);
        poseStack.m_85849_();
    }

    public static void drawRoundedLine(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, float width, int color) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float length = Mth.m_14116_((float)(dx * dx + dy * dy));
        if (length < 0.001f) {
            return;
        }
        float halfWidth = width / 2.0f;
        float angle = (float)Math.atan2(dy, dx);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x1, y1, 0.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252961_(angle));
        guiGraphics.m_285795_(RenderType.m_285907_(), 0, -((int)halfWidth), (int)length, (int)halfWidth, 0, color);
        ModGuiUtil.drawTransformedCircle(guiGraphics, 0.0f, 0.0f, halfWidth, color);
        ModGuiUtil.drawTransformedCircle(guiGraphics, length, 0.0f, halfWidth, color);
        poseStack.m_85849_();
    }

    private static void drawTransformedCircle(GuiGraphics guiGraphics, float x, float y, float radius, int color) {
        PoseStack poseStack = guiGraphics.m_280168_();
        MultiBufferSource.BufferSource bufferSource = guiGraphics.m_280091_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_285907_());
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        int segments = Mth.m_14045_((int)((int)(radius * 4.0f)), (int)8, (int)32);
        float angleStep = (float)Math.PI * 2 / (float)segments;
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        for (int i = 0; i < segments; ++i) {
            float angle1 = (float)i * angleStep;
            float angle2 = (float)(i + 1) * angleStep;
            float x1 = Mth.m_14089_((float)angle1) * radius;
            float y1 = Mth.m_14031_((float)angle1) * radius;
            float x2 = Mth.m_14089_((float)angle2) * radius;
            float y2 = Mth.m_14031_((float)angle2) * radius;
            vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
            vertexConsumer.m_252986_(matrix, x1, y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
            vertexConsumer.m_252986_(matrix, x2, y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        }
        poseStack.m_85849_();
        bufferSource.m_109911_();
    }
}

