/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.function.render.CustomRenderTypes;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModProjectileRenderer {
    private static final int SEGMENTS = 4;
    private static final int packedLight = 0xF000F0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderProjectile(PoseStack poseStack, MultiBufferSource bufferSource, Vec3 start, Vec3 end, float innerRadius, float outerRadius, float[] innerColor, float[] outerColor) {
        Vec3 direction = end.m_82546_(start);
        float length = (float)direction.m_82553_();
        Vec3 normalizedDir = direction.m_82541_();
        Quaternionf rotation = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)new Vector3f((float)normalizedDir.f_82479_, (float)normalizedDir.f_82480_, (float)normalizedDir.f_82481_));
        RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
        RenderSystem.setShaderFogEnd((float)Float.MAX_VALUE);
        poseStack.m_85836_();
        try {
            poseStack.m_85837_(start.f_82479_, start.f_82480_, start.f_82481_);
            poseStack.m_252781_(rotation);
            ModProjectileRenderer.renderBeamCylinder(poseStack, bufferSource, length, outerRadius, outerColor);
            ModProjectileRenderer.renderBeamCylinder(poseStack, bufferSource, length, innerRadius, innerColor);
        }
        finally {
            poseStack.m_85849_();
        }
    }

    private static void renderBeamCylinder(PoseStack poseStack, MultiBufferSource bufferSource, float length, float radius, float[] color) {
        VertexConsumer consumer = bufferSource.m_6299_(CustomRenderTypes.COLOR_CUBE_RENDERTYPE);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float halfLength = length / 2.0f;
        float angleStep = 1.5707964f;
        for (int i = 0; i < 4; ++i) {
            Vector3f[] quadVertices;
            float angle1 = (float)i * angleStep;
            float angle2 = (float)(i + 1) * angleStep;
            for (Vector3f vert : quadVertices = new Vector3f[]{ModProjectileRenderer.getCylinderPoint(radius, angle1, -halfLength), ModProjectileRenderer.getCylinderPoint(radius, angle2, -halfLength), ModProjectileRenderer.getCylinderPoint(radius, angle2, halfLength), ModProjectileRenderer.getCylinderPoint(radius, angle1, halfLength)}) {
                consumer.m_252986_(matrix, vert.x(), vert.y(), vert.z()).m_85950_(color[0], color[1], color[2], color[3]).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
            }
        }
        ModProjectileRenderer.renderEndCap(matrix, consumer, radius, -halfLength, color);
        ModProjectileRenderer.renderEndCap(matrix, consumer, radius, halfLength, color);
    }

    private static Vector3f getCylinderPoint(float radius, float angle, float y) {
        return new Vector3f(radius * (float)Math.cos(angle), y, radius * (float)Math.sin(angle));
    }

    private static void renderEndCap(Matrix4f matrix, VertexConsumer consumer, float radius, float yPos, float[] color) {
        consumer.m_252986_(matrix, 0.0f, yPos, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_7421_(0.5f, 0.5f).m_85969_(0xF000F0).m_5752_();
        for (int i = 0; i <= 4; ++i) {
            float angle = (float)i * 1.5707964f;
            Vector3f point = ModProjectileRenderer.getCylinderPoint(radius, angle, yPos);
            consumer.m_252986_(matrix, point.x(), yPos, point.z()).m_85950_(color[0], color[1], color[2], color[3]).m_7421_(0.5f + 0.5f * (float)Math.cos(angle), 0.5f + 0.5f * (float)Math.sin(angle)).m_85969_(0xF000F0).m_5752_();
        }
    }
}

