/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.function.render.CustomRenderTypes;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModTrailRenderer {
    private static final int SEGMENTS = 4;
    private static final int packedLight = 0xF000F0;
    private static final float TEXTURE_REPEAT = 1.0f;
    public static final ResourceLocation TEXTURE = new ResourceLocation("valkyrien_space_war", "textures/block/fx/trail.png");

    public static void renderTrail(PoseStack poseStack, MultiBufferSource bufferSource, Vec3[] trailPoints, float radius, float[] color) {
        if (trailPoints.length < 2) {
            return;
        }
        VertexConsumer consumer = bufferSource.m_6299_(CustomRenderTypes.TRAIL_RENDERTYPE);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float totalLength = ModTrailRenderer.calculateTotalLength(trailPoints);
        float accumulatedLength = 0.0f;
        Vector3f[] prevRing = null;
        for (int i = 0; i < trailPoints.length - 1; ++i) {
            Vec3 end = trailPoints[i + 1];
            Vec3 start = trailPoints[i];
            Vec3 segment = end.m_82546_(start);
            float segmentLength = (float)segment.m_82553_();
            if (segmentLength < 0.001f) continue;
            Vec3 direction = segment.m_82541_();
            float currentRadius = ModTrailRenderer.calculateRadius(radius, accumulatedLength += segmentLength, totalLength);
            Quaternionf rotation = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)new Vector3f((float)direction.f_82479_, (float)direction.f_82480_, (float)direction.f_82481_));
            Vector3f[] currentRing = ModTrailRenderer.calculateRingVertices(currentRadius, rotation);
            if (prevRing != null) {
                float t = accumulatedLength / totalLength;
                float interpolatedAlpha = ModTrailRenderer.interpolateAlpha(t);
                ModTrailRenderer.connectRings(matrix, consumer, start, prevRing, end, currentRing, color, interpolatedAlpha * color[3], segmentLength, true);
            }
            prevRing = currentRing;
        }
    }

    private static Vector3f[] calculateRingVertices(float radius, Quaternionf rotation) {
        Vector3f[] ring = new Vector3f[4];
        float angleStep = 1.5707964f;
        for (int j = 0; j < 4; ++j) {
            float angle = (float)j * angleStep;
            Vector3f point = new Vector3f(radius * (float)Math.cos(angle), 0.0f, radius * (float)Math.sin(angle));
            point.rotate((Quaternionfc)rotation);
            ring[j] = point;
        }
        return ring;
    }

    private static void connectRings(Matrix4f matrix, VertexConsumer consumer, Vec3 startPos, Vector3f[] ring1, Vec3 endPos, Vector3f[] ring2, float[] color, float alpha, float segmentLength, boolean doubleSided) {
        for (int j = 0; j < 4; ++j) {
            int nextJ = (j + 1) % 4;
            Vector3f v1 = ring1[j];
            Vector3f v2 = ring1[nextJ];
            Vector3f v3 = ring2[nextJ];
            Vector3f v4 = ring2[j];
            ModTrailRenderer.addQuad(matrix, consumer, startPos, v1, 0.0f, 0.0f, startPos, v2, 1.0f, 0.0f, endPos, v3, 1.0f, 1.0f, endPos, v4, 0.0f, 1.0f, color, alpha);
            if (!doubleSided) continue;
            ModTrailRenderer.addQuad(matrix, consumer, endPos, v4, 0.0f, 1.0f, endPos, v3, 1.0f, 1.0f, startPos, v2, 1.0f, 0.0f, startPos, v1, 0.0f, 0.0f, color, alpha);
        }
    }

    private static void addQuad(Matrix4f matrix, VertexConsumer consumer, Vec3 pos1, Vector3f local1, float u1, float v1, Vec3 pos2, Vector3f local2, float u2, float v2, Vec3 pos3, Vector3f local3, float u3, float v3, Vec3 pos4, Vector3f local4, float u4, float v4, float[] color, float alpha) {
        ModTrailRenderer.addVertex(matrix, consumer, pos1, local1, u1, v1, color, alpha);
        ModTrailRenderer.addVertex(matrix, consumer, pos2, local2, u2, v2, color, alpha);
        ModTrailRenderer.addVertex(matrix, consumer, pos3, local3, u3, v3, color, alpha);
        ModTrailRenderer.addVertex(matrix, consumer, pos4, local4, u4, v4, color, alpha);
    }

    private static void addVertex(Matrix4f matrix, VertexConsumer consumer, Vec3 position, Vector3f localOffset, float u, float v, float[] color, float alpha) {
        consumer.m_252986_(matrix, (float)(position.f_82479_ + (double)localOffset.x), (float)(position.f_82480_ + (double)localOffset.y), (float)(position.f_82481_ + (double)localOffset.z)).m_85950_(color[0], color[1], color[2], alpha).m_7421_(u, v).m_85969_(0xF000F0).m_5752_();
    }

    private static float calculateTotalLength(Vec3[] points) {
        float length = 0.0f;
        for (int i = 0; i < points.length - 1; ++i) {
            length += (float)points[i].m_82554_(points[i + 1]);
        }
        return length;
    }

    private static float interpolateAlpha(float t) {
        if (t < 0.3f) {
            return ModTrailRenderer.lerp(0.0f, 1.0f, t / 0.3f);
        }
        if (t > 0.7f) {
            return ModTrailRenderer.lerp(1.0f, 0.0f, (t - 0.7f) / 0.3f);
        }
        return 1.0f;
    }

    private static float calculateRadius(float radius, float accumulatedLength, float totalLength) {
        return ModTrailRenderer.lerp(radius * 2.0f, 0.0f, accumulatedLength / totalLength);
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }
}

