/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaterniond;
import org.joml.Vector3f;

public class VoxelShapeRenderer {
    public static void renderVoxelShape(PoseStack pPoseStack, VertexConsumer pConsumer, VoxelShape pShape, double pX, double pY, double pZ, float pRed, float pGreen, float pBlue, float pAlpha, boolean p_286443_, Quaterniond rotation, boolean center) {
        List list = pShape.m_83299_();
        if (!list.isEmpty()) {
            int i = p_286443_ ? list.size() : list.size() * 8;
            VoxelShapeRenderer.renderShape(pPoseStack, pConsumer, Shapes.m_83064_((AABB)((AABB)list.get(0))), pX, pY, pZ, pRed, pGreen, pBlue, pAlpha, rotation, center);
            for (int j = 1; j < list.size(); ++j) {
                AABB aabb = (AABB)list.get(j);
                float f = (float)j / (float)i;
                Vec3 vec3 = VoxelShapeRenderer.shiftHue(pRed, pGreen, pBlue, f);
                VoxelShapeRenderer.renderShape(pPoseStack, pConsumer, Shapes.m_83064_((AABB)aabb), pX, pY, pZ, (float)vec3.f_82479_, (float)vec3.f_82480_, (float)vec3.f_82481_, pAlpha, rotation, center);
            }
        }
    }

    private static void renderShape(PoseStack pPoseStack, VertexConsumer pConsumer, VoxelShape pShape, double pX, double pY, double pZ, float pRed, float pGreen, float pBlue, float pAlpha, Quaterniond rotation, boolean center) {
        PoseStack.Pose posestack$pose = pPoseStack.m_85850_();
        pShape.m_83224_((startXLocal, startYLocal, startZLocal, endXLocal, endYLocal, endZLocal) -> {
            float endZ;
            float dz;
            float endY;
            float dy;
            Vector3f startVec = new Vector3f((float)startXLocal, (float)startYLocal, (float)startZLocal);
            if (rotation != null) {
                if (center) {
                    startVec.sub(0.5f, 0.5f, 0.5f);
                    rotation.transform(startVec);
                    startVec.add(0.5f, 0.5f, 0.5f);
                } else {
                    rotation.transform(startVec);
                }
            }
            Vector3f endVec = new Vector3f((float)endXLocal, (float)endYLocal, (float)endZLocal);
            if (rotation != null) {
                if (center) {
                    endVec.sub(0.5f, 0.5f, 0.5f);
                    rotation.transform(endVec);
                    endVec.add(0.5f, 0.5f, 0.5f);
                } else {
                    rotation.transform(endVec);
                }
            }
            float startX = (float)pX + startVec.x();
            float startY = (float)pY + startVec.y();
            float startZ = (float)pZ + startVec.z();
            float endX = (float)pX + endVec.x();
            float dx = endX - startX;
            float length = Mth.m_14116_((float)(dx * dx + (dy = (endY = (float)pY + endVec.y()) - startY) * dy + (dz = (endZ = (float)pZ + endVec.z()) - startZ) * dz));
            if (length != 0.0f) {
                dx /= length;
                dy /= length;
                dz /= length;
            }
            pConsumer.m_252986_(posestack$pose.m_252922_(), startX, startY, startZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(posestack$pose.m_252943_(), dx, dy, dz).m_5752_();
            pConsumer.m_252986_(posestack$pose.m_252922_(), endX, endY, endZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(posestack$pose.m_252943_(), dx, dy, dz).m_5752_();
        });
    }

    private static Vec3 shiftHue(float pRed, float pGreen, float pBlue, float pHue) {
        Vec3 vec3 = VoxelShapeRenderer.mixColor(pHue).m_82490_((double)pRed);
        Vec3 vec31 = VoxelShapeRenderer.mixColor((pHue + 0.33333334f) % 1.0f).m_82490_((double)pGreen);
        Vec3 vec32 = VoxelShapeRenderer.mixColor((pHue + 0.6666667f) % 1.0f).m_82490_((double)pBlue);
        Vec3 vec33 = vec3.m_82549_(vec31).m_82549_(vec32);
        double d0 = Math.max(Math.max(1.0, vec33.f_82479_), Math.max(vec33.f_82480_, vec33.f_82481_));
        return new Vec3(vec33.f_82479_ / d0, vec33.f_82480_ / d0, vec33.f_82481_ / d0);
    }

    private static Vec3 mixColor(float pHue) {
        float f = 5.99999f;
        int i = (int)(Mth.m_14036_((float)pHue, (float)0.0f, (float)1.0f) * 5.99999f);
        float f1 = pHue * 5.99999f - (float)i;
        return switch (i) {
            case 0 -> new Vec3(1.0, (double)f1, 0.0);
            case 1 -> new Vec3((double)(1.0f - f1), 1.0, 0.0);
            case 2 -> new Vec3(0.0, 1.0, (double)f1);
            case 3 -> new Vec3(0.0, 1.0 - (double)f1, 1.0);
            case 4 -> new Vec3((double)f1, 0.0, 1.0);
            case 5 -> new Vec3(1.0, 0.0, 1.0 - (double)f1);
            default -> throw new IllegalStateException("Unexpected value: " + i);
        };
    }
}

