/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.rs_channel;

import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.shao.valkyrien_space_war.function.render.ModGuiUtil;
import net.shao.valkyrien_space_war.function.rs_channel.IRsChannelProvider;
import net.shao.valkyrien_space_war.function.rs_channel.IRsChannelReceiver;
import org.valkyrienskies.core.api.ships.ServerShip;

public class RsChannelManager {
    private static HashSet<IRsChannelReceiver> ALL_RECEIVERS = new HashSet();

    public static void registerReceiver(IRsChannelReceiver receiver) {
        ALL_RECEIVERS.add(receiver);
    }

    public static void removeReceiver(IRsChannelReceiver receiver) {
        ALL_RECEIVERS.remove(receiver);
    }

    public static void sendRsChannel(String channelName, int power) {
        for (IRsChannelReceiver receiver : ALL_RECEIVERS) {
            receiver.receiveRsChannel(channelName, power);
        }
    }

    public static void onPaste(BlockEntity be, ServerLevel level, Map<Long, ServerShip> newShips, Map<Long, AABB> newShipAABBs, BlockPos pos, BlockState state, CompoundTag tag) {
        if (be instanceof IRsChannelReceiver) {
            IRsChannelReceiver receiver = (IRsChannelReceiver)be;
            String channelName = tag.m_128461_("rs_channel");
            String[] strings = ModGuiUtil.splitFirstOccurrence(channelName, "-");
            if (strings[0] != null && !strings[0].isEmpty()) {
                long oldId = ModGuiUtil.filterToInt(strings[0]);
                long newId = newShips.get(oldId).getId();
                String newChannelName = newId + "-" + (strings[1] == null ? "" : strings[1]);
                tag.m_128359_("rs_channel", newChannelName);
            }
        } else if (be instanceof IRsChannelProvider) {
            IRsChannelProvider provider = (IRsChannelProvider)be;
            ListTag list = tag.m_128437_("rs_channels", 8);
            ListTag newList = new ListTag();
            for (int i = 0; i < list.size(); ++i) {
                long oldId;
                ServerShip serverShip;
                String oldName = list.m_128778_(i);
                Object newName = "";
                String[] strings = ModGuiUtil.splitFirstOccurrence(oldName, "-");
                if (strings[0] != null && !strings[0].isEmpty() && (serverShip = newShips.get(oldId = (long)ModGuiUtil.filterToInt(strings[0]))) != null) {
                    long newId = newShips.get(oldId).getId();
                    newName = newId + "-" + (strings[1] == null ? "" : strings[1]);
                }
                newList.add((Object)StringTag.m_129297_((String)newName));
            }
            tag.m_128365_("rs_channels", (Tag)newList);
        }
    }
}

