/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.schematic;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.AABB;
import net.shao.valkyrien_space_war.function.schematic.ICopyableBE;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.LoadedServerShip;

public class VsswSchematic
extends SavedData {
    public static final String PATH = "vssw-schematics";
    private final Map<Long, Structure> structures = new HashMap<Long, Structure>();
    private long mainShipId = -1L;
    private String name;

    public VsswSchematic() {
    }

    public VsswSchematic(String name) {
        this.name = name;
    }

    public void addShip(ServerLevel level, LoadedServerShip ship) {
        long id = ship.getId();
        if (this.mainShipId == -1L) {
            this.mainShipId = id;
        }
        AABBic shipAABB = ship.getShipAABB();
        Structure structure = new Structure(id, new BoundingBox(shipAABB.minX(), shipAABB.minY(), shipAABB.minZ(), shipAABB.maxX(), shipAABB.maxY(), shipAABB.maxZ()));
        AABB area = new AABB((double)Math.min(shipAABB.minX(), shipAABB.maxX()), (double)Math.min(shipAABB.minY(), shipAABB.maxY()), (double)Math.min(shipAABB.minZ(), shipAABB.maxZ()), (double)(Math.max(shipAABB.minX(), shipAABB.maxX()) + 1), (double)(Math.max(shipAABB.minY(), shipAABB.maxY()) + 1), (double)(Math.max(shipAABB.minZ(), shipAABB.maxZ()) + 1));
        BlockPos.m_121921_((AABB)area).forEach(pos -> {
            BlockState state = level.m_8055_(pos);
            if (state.m_60795_()) {
                return;
            }
            CompoundTag entityData = null;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity != null) {
                entityData = blockEntity.m_187480_();
                if (blockEntity instanceof ICopyableBE) {
                    ICopyableBE be = (ICopyableBE)blockEntity;
                    be.onCopy(level, (BlockPos)pos, state, entityData);
                }
            }
            structure.addBlock(pos.m_7949_(), state, entityData);
        });
        this.structures.put(id, structure);
    }

    public void addStructure(long id, Structure structure) {
        this.structures.put(id, structure);
    }

    public Map<Long, Structure> getStructures() {
        return this.structures;
    }

    public long getMainShipId() {
        return this.mainShipId;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag tags = new ListTag();
        this.structures.forEach((id, structure) -> tags.add((Object)structure.m_7176_(new CompoundTag())));
        tag.m_128365_("structures", (Tag)tags);
        tag.m_128359_("name", this.name);
        return tag;
    }

    public static VsswSchematic load(CompoundTag tag, HolderGetter<Block> blockGetter) {
        VsswSchematic schematic = new VsswSchematic();
        ListTag list = tag.m_128437_("structures", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag structureTag = list.m_128728_(i);
            long id = structureTag.m_128454_("shipId");
            schematic.addStructure(id, Structure.load(structureTag, blockGetter));
        }
        return schematic;
    }

    public void saveToFile() throws IOException {
        File dir = new File(PATH);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, this.name + ".vssw");
        NbtIo.m_128955_((CompoundTag)this.m_7176_(new CompoundTag()), (File)file);
    }

    public static VsswSchematic loadFromFile(String name, ServerLevel level) throws IOException {
        File file = new File(PATH, name + ".vssw");
        if (!file.exists()) {
            throw new IOException("Schematic file not found: " + file.getPath());
        }
        CompoundTag tag = NbtIo.m_128953_((File)file);
        if (tag == null) {
            throw new IOException("Failed to read schematic file: " + file.getPath());
        }
        HolderLookup.RegistryLookup blockGetter = level.m_9598_().m_255025_(Registries.f_256747_);
        return VsswSchematic.load(tag, (HolderGetter<Block>)blockGetter);
    }

    public static class Structure
    extends SavedData {
        private final Map<BlockPos, BlockState> blockStates = new HashMap<BlockPos, BlockState>();
        private final Map<BlockPos, CompoundTag> blockEntities = new HashMap<BlockPos, CompoundTag>();
        private BoundingBox boundingBox;
        private long shipId;

        public Structure(long shipId, BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            this.shipId = shipId;
        }

        public void addBlock(BlockPos pos, BlockState state, CompoundTag entityData) {
            this.blockStates.put(pos, state);
            if (entityData != null) {
                this.blockEntities.put(pos, entityData);
            }
        }

        public Map<BlockPos, BlockState> getBlockStates() {
            return this.blockStates;
        }

        public Map<BlockPos, CompoundTag> getBlockEntities() {
            return this.blockEntities;
        }

        public BoundingBox getBoundingBox() {
            return this.boundingBox;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            CompoundTag boundsTag = new CompoundTag();
            boundsTag.m_128405_("minX", this.boundingBox.m_162395_());
            boundsTag.m_128405_("minY", this.boundingBox.m_162396_());
            boundsTag.m_128405_("minZ", this.boundingBox.m_162398_());
            boundsTag.m_128405_("maxX", this.boundingBox.m_162399_());
            boundsTag.m_128405_("maxY", this.boundingBox.m_162400_());
            boundsTag.m_128405_("maxZ", this.boundingBox.m_162401_());
            tag.m_128365_("bounds", (Tag)boundsTag);
            tag.m_128356_("shipId", this.shipId);
            ListTag blocksTag = new ListTag();
            for (Map.Entry<BlockPos, BlockState> entry : this.blockStates.entrySet()) {
                CompoundTag blockTag = new CompoundTag();
                blockTag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)entry.getKey()));
                blockTag.m_128365_("state", (Tag)NbtUtils.m_129202_((BlockState)entry.getValue()));
                blocksTag.add((Object)blockTag);
            }
            tag.m_128365_("blocks", (Tag)blocksTag);
            ListTag entitiesTag = new ListTag();
            for (Map.Entry<BlockPos, CompoundTag> entry : this.blockEntities.entrySet()) {
                CompoundTag entityTag = entry.getValue().m_6426_();
                entityTag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)entry.getKey()));
                entitiesTag.add((Object)entityTag);
            }
            tag.m_128365_("entities", (Tag)entitiesTag);
            return tag;
        }

        public static Structure load(CompoundTag tag, HolderGetter<Block> blockGetter) {
            CompoundTag boundsTag = tag.m_128469_("bounds");
            Structure structure = new Structure(tag.m_128454_("shipId"), new BoundingBox(boundsTag.m_128451_("minX"), boundsTag.m_128451_("minY"), boundsTag.m_128451_("minZ"), boundsTag.m_128451_("maxX"), boundsTag.m_128451_("maxY"), boundsTag.m_128451_("maxZ")));
            ListTag blocksTag = tag.m_128437_("blocks", 10);
            for (int i = 0; i < blocksTag.size(); ++i) {
                CompoundTag blockTag = blocksTag.m_128728_(i);
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)blockTag.m_128469_("pos"));
                BlockState state = NbtUtils.m_247651_(blockGetter, (CompoundTag)blockTag.m_128469_("state"));
                structure.blockStates.put(pos, state);
            }
            ListTag entitiesTag = tag.m_128437_("entities", 10);
            for (int i = 0; i < entitiesTag.size(); ++i) {
                CompoundTag entityTag = entitiesTag.m_128728_(i);
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)entityTag.m_128469_("pos"));
                entityTag.m_128473_("pos");
                structure.blockEntities.put(pos, entityTag);
            }
            return structure;
        }
    }
}

