/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.schematic;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.shao.valkyrien_space_war.ValkyrienSpaceWar;
import net.shao.valkyrien_space_war.event.ServerEvent;
import net.shao.valkyrien_space_war.function.schematic.ICopyableBE;
import net.shao.valkyrien_space_war.function.schematic.VsswSchematic;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.apigame.ShipTeleportData;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.impl.game.ShipTeleportDataImpl;
import org.valkyrienskies.core.util.datastructures.DenseBlockPosSet;
import org.valkyrienskies.mod.common.assembly.ShipAssemblyKt;

public class VsswVsManager {
    public static void saveBlueprint(ServerLevel level, ServerShip ship, String name) {
        try {
            VsswSchematic schematic = new VsswSchematic(name);
            HashMap<Long, HashSet<VSConstraint>> allRelatedShips = VsUtil.getAllRelatedShips((Level)level, ship.getId());
            allRelatedShips.put(ship.getId(), new HashSet());
            allRelatedShips.forEach((relatedShip, constraints) -> schematic.addShip(level, VsUtil.getLoadedShipById(level, relatedShip)));
            schematic.saveToFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadBlueprint(ServerLevel level, VsswSchematic schematic, BlockPos centerPos, Quaterniond rot) {
        Map<Long, VsswSchematic.Structure> structures = schematic.getStructures();
        HashMap newAABBs = new HashMap();
        HashMap offsets = new HashMap();
        HashMap datas = new HashMap();
        HashMap newShips = new HashMap();
        structures.forEach((id, structure) -> {
            BoundingBox originalBox = structure.getBoundingBox();
            BlockPos originalCenter = new BlockPos((originalBox.m_162395_() + originalBox.m_162399_()) / 2, (originalBox.m_162396_() + originalBox.m_162400_()) / 2, (originalBox.m_162398_() + originalBox.m_162401_()) / 2);
            BlockPos offset = centerPos.m_121996_((Vec3i)originalCenter);
            HashMap positionMap = new HashMap();
            DenseBlockPosSet blocksToLoad = new DenseBlockPosSet();
            structure.getBlockStates().forEach((pos, state) -> {
                BlockPos newPos = pos.m_121955_((Vec3i)offset);
                positionMap.put(pos, newPos);
                level.m_7731_(newPos, state, 2);
                if (!state.m_60795_()) {
                    blocksToLoad.add(newPos.m_123341_(), newPos.m_123342_(), newPos.m_123343_());
                }
            });
            HashMap tempEntityData = new HashMap();
            structure.getBlockEntities().forEach((pos, entityData) -> {
                BlockPos newPos = (BlockPos)positionMap.get(pos);
                if (newPos != null) {
                    CompoundTag copy = entityData.m_6426_();
                    copy.m_128405_("x", newPos.m_123341_());
                    copy.m_128405_("y", newPos.m_123342_());
                    copy.m_128405_("z", newPos.m_123343_());
                    tempEntityData.put(newPos, copy);
                }
            });
            level.m_7726_().m_7827_().m_6191_(SectionPos.m_123199_((BlockPos)centerPos), true);
            ServerShip newShip = ShipAssemblyKt.createNewShipWithBlocks((BlockPos)centerPos, (DenseBlockPosSet)blocksToLoad, (ServerLevel)level);
            newShip.setStatic(true);
            int shipChunkX = newShip.getChunkClaim().getXMiddle();
            int shipChunkZ = newShip.getChunkClaim().getZMiddle();
            int worldChunkX = centerPos.m_123341_() >> 4;
            int worldChunkZ = centerPos.m_123343_() >> 4;
            int deltaX = worldChunkX - shipChunkX;
            int deltaZ = worldChunkZ - shipChunkZ;
            BlockPos p1 = VsswVsManager.calculateShipPosition(new BlockPos(originalBox.m_162395_(), originalBox.m_162396_(), originalBox.m_162398_()).m_121955_((Vec3i)offset), deltaX, deltaZ);
            BlockPos p2 = VsswVsManager.calculateShipPosition(new BlockPos(originalBox.m_162399_(), originalBox.m_162400_(), originalBox.m_162401_()).m_121955_((Vec3i)offset), deltaX, deltaZ);
            AABB newAABBOnShip = new AABB((double)p1.m_123341_(), (double)p1.m_123342_(), (double)p1.m_123343_(), (double)p2.m_123341_(), (double)p2.m_123342_(), (double)p2.m_123343_());
            newAABBs.put(id, newAABBOnShip);
            offsets.put(id, new deltaOffset(deltaX, deltaZ));
            datas.put(id, tempEntityData);
            newShips.put(id, newShip);
        });
        structures.forEach((id, structure) -> {
            Map tempEntityData = (Map)datas.get(id);
            ServerShip newShip = (ServerShip)newShips.get(id);
            int deltaX = ((deltaOffset)offsets.get((Object)id)).deltaX;
            int deltaZ = ((deltaOffset)offsets.get((Object)id)).deltaZ;
            tempEntityData.forEach((worldPos, entityData) -> {
                BlockPos posOnShip = VsswVsManager.calculateShipPosition(worldPos, deltaX, deltaZ);
                LevelChunk shipChunk = level.m_6325_(posOnShip.m_123341_() >> 4, posOnShip.m_123343_() >> 4);
                BlockEntity blockEntity = shipChunk.m_7702_(posOnShip);
                if (blockEntity != null) {
                    try {
                        if (blockEntity instanceof ICopyableBE) {
                            ICopyableBE be = (ICopyableBE)blockEntity;
                            be.onPaste(level, newShips, newAABBs, posOnShip, shipChunk.m_8055_(posOnShip), (CompoundTag)entityData);
                        }
                        blockEntity.m_142466_(entityData);
                        blockEntity.m_6596_();
                        BlockState state = shipChunk.m_8055_(posOnShip);
                        level.m_7260_(posOnShip, state, state, 3);
                    }
                    catch (Exception e) {
                        ValkyrienSpaceWar.LOGGER.error("Failed to apply block entity data", (Throwable)e);
                    }
                }
            });
            ServerEvent.addOnServerTickListener(id.longValue() == schematic.getMainShipId() ? 2 : 1, () -> {
                if (id.longValue() == schematic.getMainShipId()) {
                    ShipTeleportDataImpl shipTeleportData = new ShipTeleportDataImpl((Vector3dc)new Vector3d((double)centerPos.m_123341_(), (double)centerPos.m_123342_(), (double)centerPos.m_123343_()), (Quaterniondc)rot, (Vector3dc)new Vector3d(), (Vector3dc)new Vector3d(), null, null);
                    VsUtil.getShipObjectWorldCore(level).teleportShip(newShip, (ShipTeleportData)shipTeleportData);
                }
                newShip.setStatic(false);
            });
        });
    }

    private static BlockPos calculateShipPosition(BlockPos worldPos, int deltaX, int deltaZ) {
        int chunkX = (worldPos.m_123341_() >> 4) - deltaX;
        int chunkZ = (worldPos.m_123343_() >> 4) - deltaZ;
        return new BlockPos((chunkX << 4) + (worldPos.m_123341_() & 0xF), worldPos.m_123342_(), (chunkZ << 4) + (worldPos.m_123343_() & 0xF));
    }

    public static Vector3d calculateShipPosition(Vector3d worldPos, int deltaX, int deltaZ) {
        double blockOffsetX = (double)deltaX * 16.0;
        double blockOffsetZ = (double)deltaZ * 16.0;
        return new Vector3d(worldPos.x - blockOffsetX, worldPos.y, worldPos.z - blockOffsetZ);
    }

    public static void deleteShip(ServerLevel level, Ship ship) {
        AABBic aabb = ship.getShipAABB();
        for (BlockPos pos : BlockPos.m_121976_((int)aabb.minX(), (int)aabb.minY(), (int)aabb.minZ(), (int)aabb.maxX(), (int)aabb.maxY(), (int)aabb.maxZ())) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 0);
        }
    }

    public static void deleteShip(ServerLevel level, String shipName) {
        VsswVsManager.deleteShip(level, VsswVsManager.getShipByName(level, shipName));
    }

    public static void deleteAllRelatedShips(ServerLevel level, String shipName) {
        Ship shipByName = VsswVsManager.getShipByName(level, shipName);
        HashMap<Long, HashSet<VSConstraint>> allRelatedShips = VsUtil.getAllRelatedShips((Level)level, shipByName.getId(), true);
        allRelatedShips.forEach((relatedShip, constraints) -> VsswVsManager.deleteShip(level, (Ship)VsUtil.getLoadedShipById(level, relatedShip)));
    }

    public static Ship getShipByName(ServerLevel level, String shipName) {
        return VsUtil.getLoadedShips(level).stream().filter(ship -> ship.getSlug().equals(shipName)).findFirst().orElse(null);
    }

    public record deltaOffset(int deltaX, int deltaZ) {
    }
}

