/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.terrain;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.shao.valkyrien_space_war.mixinducks.IMinecraftServerDuck;

public class ChunkLoadManager {
    public static final TicketType<Long> CHUNK_LOAD_TICKET = TicketType.m_9462_((String)"valkyrien_space_war:chunk_load", Long::compareTo);
    private static final Map<ResourceKey<Level>, ChunkLoadManager> managers = new ConcurrentHashMap<ResourceKey<Level>, ChunkLoadManager>();
    private static final long EXPIRATION_TIME_MS = 10000L;
    public final Map<ChunkPos, ChunkEntry> forcedChunks = new ConcurrentHashMap<ChunkPos, ChunkEntry>();
    public final ServerLevel serverLevel;

    public static ChunkLoadManager getManagerForLevel(ServerLevel level) {
        return managers.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), k -> new ChunkLoadManager(level));
    }

    public ChunkLoadManager(ServerLevel level) {
        this.serverLevel = level;
    }

    public void addOrUpdateChunkPos(int chunkX, int chunkZ, int range) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        if (this.forcedChunks.containsKey(chunkPos)) {
            this.forcedChunks.computeIfPresent(chunkPos, (key, entry) -> {
                entry.expirationTime = System.currentTimeMillis() + 10000L;
                return entry;
            });
            return;
        }
        if (!this.serverLevel.m_7726_().m_5563_(chunkPos.f_45578_, chunkPos.f_45579_) && !ChunkLoadManager.isChunkGenerated(this.serverLevel, chunkPos)) {
            return;
        }
        long holderId = chunkPos.m_45588_();
        long newExpiration = System.currentTimeMillis() + 10000L;
        this.serverLevel.m_7726_().addRegionTicket(CHUNK_LOAD_TICKET, chunkPos, range, (Object)holderId, false);
        this.forcedChunks.put(chunkPos, new ChunkEntry(holderId, newExpiration, range));
    }

    public static boolean isChunkGenerated(ServerLevel level, ChunkPos chunkPos) {
        boolean bl;
        if (level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
            return true;
        }
        Path worldPath = ((IMinecraftServerDuck)level.m_7654_()).getStorageSource().m_197394_(level.m_46472_());
        Path regionDir = worldPath.resolve("region");
        int regionX = chunkPos.f_45578_ >> 5;
        int regionZ = chunkPos.f_45579_ >> 5;
        String regionFile = String.format("r.%d.%d.mca", regionX, regionZ);
        Path regionPath = regionDir.resolve(regionFile);
        if (!Files.exists(regionPath, new LinkOption[0])) {
            return false;
        }
        RandomAccessFile raf = new RandomAccessFile(regionPath.toFile(), "r");
        try {
            int chunkOffset = (chunkPos.f_45578_ & 0x1F) + (chunkPos.f_45579_ & 0x1F) * 32;
            long locationOffset = (long)chunkOffset * 4L;
            raf.seek(locationOffset);
            int location = raf.readInt();
            bl = location >> 8 != 0;
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        raf.close();
        return bl;
    }

    public void checkExpiredChunks() {
        long currentTime = System.currentTimeMillis();
        this.forcedChunks.entrySet().removeIf(entry -> {
            ChunkPos pos = (ChunkPos)entry.getKey();
            ChunkEntry chunkEntry = (ChunkEntry)entry.getValue();
            if (currentTime >= chunkEntry.expirationTime) {
                this.serverLevel.m_7726_().removeRegionTicket(CHUNK_LOAD_TICKET, pos, chunkEntry.range, (Object)chunkEntry.holderId, false);
                return true;
            }
            return false;
        });
    }

    public int getLoadedChunkCount() {
        return this.forcedChunks.size();
    }

    public void unloadAllChunks() {
        this.forcedChunks.forEach((pos, entry) -> this.serverLevel.m_7726_().removeRegionTicket(CHUNK_LOAD_TICKET, pos, entry.range, (Object)entry.holderId, false));
        this.forcedChunks.clear();
    }

    public void onWorldUnload() {
        this.unloadAllChunks();
        managers.remove(this.serverLevel.m_46472_());
    }

    public static ChunkPos[] calculateChunkPath(double startX, double startZ, double endX, double endZ) {
        int startChunkX = (int)Math.floor(startX / 16.0);
        int startChunkZ = (int)Math.floor(startZ / 16.0);
        int endChunkX = (int)Math.floor(endX / 16.0);
        int endChunkZ = (int)Math.floor(endZ / 16.0);
        ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
        int dx = Math.abs(endChunkX - startChunkX);
        int dz = Math.abs(endChunkZ - startChunkZ);
        int sx = startChunkX < endChunkX ? 1 : -1;
        int sz = startChunkZ < endChunkZ ? 1 : -1;
        int err = dx - dz;
        int currentX = startChunkX;
        int currentZ = startChunkZ;
        chunks.add(new ChunkPos(currentX, currentZ));
        while (currentX != endChunkX || currentZ != endChunkZ) {
            int e2 = 2 * err;
            if (e2 > -dz) {
                err -= dz;
                currentX += sx;
            }
            if (e2 < dx) {
                err += dx;
                currentZ += sz;
            }
            chunks.add(new ChunkPos(currentX, currentZ));
        }
        return chunks.toArray(new ChunkPos[0]);
    }

    private static class ChunkEntry {
        final long holderId;
        long expirationTime;
        int range;

        ChunkEntry(long holderId, long expirationTime, int range) {
            this.holderId = holderId;
            this.expirationTime = expirationTime;
            this.range = range;
        }
    }
}

