/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.terrain;

import com.google.common.collect.MapMaker;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.BitSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.storage.LevelResource;

public class ServerTerrainCache3d {
    private static final int MAX_CACHE_SIZE = 4096;
    private static final int SECTION_SIZE = 16;
    private static final int WORLD_MIN_Y = Short.MIN_VALUE;
    private static final int WORLD_MAX_Y = Short.MAX_VALUE;
    private static final int TOTAL_SECTIONS = 4096;
    private static final int BITS_PER_SECTION = 256;
    private static final ConcurrentMap<ChunkKey, ChunkBlockCache> CACHE = new MapMaker().concurrencyLevel(4).makeMap();
    private static final ConcurrentLinkedDeque<ChunkKey> ACCESS_QUEUE = new ConcurrentLinkedDeque();
    private static final Object LOCK = new Object();
    private static final ExecutorService CACHE_EXECUTOR = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), r -> {
        Thread t = new Thread(r, "Terrain-Cache-Worker");
        t.setDaemon(true);
        return t;
    });
    private static final int REGION_BITS = 5;
    private static final int REGION_SIZE = 32;
    private static final ConcurrentHashMap<Path, Long> FILE_READ_CACHE = new ConcurrentHashMap();
    private static final Object CACHE_LOCK = new Object();
    private static final ScheduledExecutorService CLEANER = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "CacheCleaner");
        t.setDaemon(true);
        return t;
    });

    public static void updateCache(ServerLevel level, ChunkPos chunkPos) {
        ResourceKey dim = level.m_46472_();
        ChunkKey key = new ChunkKey((ResourceKey<Level>)dim, chunkPos.m_45588_());
        CACHE_EXECUTOR.submit(() -> {
            try {
                CompressedHeightMap heightMap = ServerTerrainCache3d.computeHeightMap(level, chunkPos);
                ChunkBlockCache cache = new ChunkBlockCache(heightMap);
                Object object = LOCK;
                synchronized (object) {
                    CACHE.put(key, cache);
                    ACCESS_QUEUE.addLast(key);
                    ServerTerrainCache3d.maintainCacheSize();
                    level.m_7654_().execute(() -> ServerTerrainCache3d.writeToFile(level, chunkPos, heightMap.serialize()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static CompressedHeightMap computeHeightMap(ServerLevel level, ChunkPos chunkPos) {
        int minY = level.m_141937_();
        int maxY = level.m_151558_();
        CompressedHeightMap heightMap = new CompressedHeightMap(minY, maxY);
        ChunkAccess chunk = level.m_7726_().m_7587_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, false);
        if (chunk != null) {
            int startX = chunkPos.m_45604_();
            int startZ = chunkPos.m_45605_();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockState state;
                    int y;
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(startX + x, minY, startZ + z);
                    for (y = minY; y <= maxY; ++y) {
                        pos.m_142448_(y);
                        state = chunk.m_8055_((BlockPos)pos);
                        if (state.m_60795_() || state.m_278721_()) continue;
                        heightMap.setBlock(x, y, z, true);
                        break;
                    }
                    for (y = minY + 1; y <= maxY; ++y) {
                        pos.m_142448_(y);
                        state = chunk.m_8055_((BlockPos)pos);
                        if (state.m_60795_() || state.m_278721_()) continue;
                        heightMap.setBlock(x, y, z, true);
                    }
                }
            }
        }
        return heightMap;
    }

    private static void maintainCacheSize() {
        while (CACHE.size() > 4096 && !ACCESS_QUEUE.isEmpty()) {
            ChunkKey oldestKey = ACCESS_QUEUE.pollFirst();
            if (oldestKey == null) continue;
            CACHE.remove(oldestKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasBlock(ServerLevel level, BlockPos pos) {
        CompressedHeightMap heightMap;
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkKey key = new ChunkKey((ResourceKey<Level>)level.m_46472_(), chunkPos.m_45588_());
        int x = pos.m_123341_() & 0xF;
        int z = pos.m_123343_() & 0xF;
        int y = pos.m_123342_();
        ChunkBlockCache cache = (ChunkBlockCache)CACHE.get(key);
        if (cache != null) {
            ServerTerrainCache3d.updateAccessOrder(key);
            return cache.hasBlock(x, y, z);
        }
        byte[] fileData = ServerTerrainCache3d.readFromFile(level, chunkPos);
        if (fileData != null && (heightMap = CompressedHeightMap.deserialize(fileData)) != null) {
            ChunkBlockCache newCache = new ChunkBlockCache(heightMap);
            Object object = LOCK;
            synchronized (object) {
                CACHE.put(key, newCache);
                ACCESS_QUEUE.addLast(key);
                ServerTerrainCache3d.maintainCacheSize();
            }
            return newCache.hasBlock(x, y, z);
        }
        return false;
    }

    public static boolean hasChunk(ServerLevel level, ChunkPos chunkPos) {
        ChunkKey key = new ChunkKey((ResourceKey<Level>)level.m_46472_(), chunkPos.m_45588_());
        ChunkBlockCache cache = (ChunkBlockCache)CACHE.get(key);
        if (cache != null) {
            return true;
        }
        byte[] fileData = ServerTerrainCache3d.readFromFile(level, chunkPos);
        return fileData != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getHeight(ServerLevel level, BlockPos pos) {
        CompressedHeightMap heightMap;
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkKey key = new ChunkKey((ResourceKey<Level>)level.m_46472_(), chunkPos.m_45588_());
        int x = pos.m_123341_() & 0xF;
        int z = pos.m_123343_() & 0xF;
        ChunkBlockCache cache = (ChunkBlockCache)CACHE.get(key);
        if (cache != null) {
            ServerTerrainCache3d.updateAccessOrder(key);
            return cache.getHeight(x, z);
        }
        byte[] fileData = ServerTerrainCache3d.readFromFile(level, chunkPos);
        if (fileData != null && (heightMap = CompressedHeightMap.deserialize(fileData)) != null) {
            ChunkBlockCache newCache = new ChunkBlockCache(heightMap);
            Object object = LOCK;
            synchronized (object) {
                CACHE.put(key, newCache);
                ACCESS_QUEUE.addLast(key);
                ServerTerrainCache3d.maintainCacheSize();
            }
            return newCache.getHeight(x, z);
        }
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateAccessOrder(ChunkKey key) {
        Object object = LOCK;
        synchronized (object) {
            ACCESS_QUEUE.remove(key);
            ACCESS_QUEUE.addLast(key);
        }
    }

    private static Path getRegionPath(ServerLevel level, ChunkPos chunkPos) {
        Path worldPath = level.m_7654_().m_129843_(LevelResource.f_78182_);
        int regionX = chunkPos.f_45578_ >> 5;
        int regionZ = chunkPos.f_45579_ >> 5;
        return worldPath.resolve("height_cache").resolve(level.m_46472_().m_135782_().m_135815_()).resolve("region").resolve(String.format("r.%d.%d.hcache", regionX, regionZ));
    }

    public static void writeToFile(ServerLevel level, ChunkPos pos, byte[] data) {
        Path regionFile = ServerTerrainCache3d.getRegionPath(level, pos);
        try {
            Files.createDirectories(regionFile.getParent(), new FileAttribute[0]);
            CompoundTag root = new CompoundTag();
            if (Files.exists(regionFile, new LinkOption[0])) {
                try (DataInputStream dis = new DataInputStream(Files.newInputStream(regionFile, new OpenOption[0]));){
                    root = NbtIo.m_128939_((InputStream)dis);
                }
                catch (IOException e) {
                    root = new CompoundTag();
                }
            }
            CompoundTag chunkTag = new CompoundTag();
            chunkTag.m_128356_("Pos", pos.m_45588_());
            chunkTag.m_128382_("Data", data);
            root.m_128365_(String.valueOf(pos.m_45588_()), (Tag)chunkTag);
            Path tempFile = regionFile.resolveSibling(regionFile.getFileName() + ".tmp");
            try (OutputStream os = Files.newOutputStream(tempFile, new OpenOption[0]);){
                NbtIo.m_128947_((CompoundTag)root, (OutputStream)os);
            }
            Files.move(tempFile, regionFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            System.err.println("\u5199\u5165\u9ad8\u5ea6\u7f13\u5b58\u5931\u8d25: " + regionFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readFromFile(ServerLevel level, ChunkPos pos) {
        Path regionFile = ServerTerrainCache3d.getRegionPath(level, pos);
        Long lastRead = FILE_READ_CACHE.get(regionFile);
        if (lastRead != null && System.currentTimeMillis() - lastRead < 10000L) {
            return null;
        }
        Object object = CACHE_LOCK;
        synchronized (object) {
            if (!Files.exists(regionFile, new LinkOption[0])) {
                FILE_READ_CACHE.remove(regionFile);
                return null;
            }
            try (DataInputStream dis = new DataInputStream(Files.newInputStream(regionFile, new OpenOption[0]));){
                CompoundTag root = NbtIo.m_128939_((InputStream)dis);
                String chunkKey = String.valueOf(pos.m_45588_());
                if (root.m_128441_(chunkKey)) {
                    CompoundTag chunkTag = root.m_128469_(chunkKey);
                    long storedPos = chunkTag.m_128454_("Pos");
                    if (storedPos != pos.m_45588_()) {
                        FILE_READ_CACHE.remove(regionFile);
                        byte[] byArray = null;
                        return byArray;
                    }
                    byte[] data = chunkTag.m_128463_("Data");
                    FILE_READ_CACHE.put(regionFile, System.currentTimeMillis());
                    byte[] byArray = data;
                    return byArray;
                }
            }
            catch (IOException e) {
                System.err.println("\u8bfb\u53d6\u9ad8\u5ea6\u7f13\u5b58\u5931\u8d25: " + regionFile);
                FILE_READ_CACHE.remove(regionFile);
            }
            return null;
        }
    }

    public static void shutdown() {
        CACHE_EXECUTOR.shutdownNow();
    }

    static {
        CLEANER.scheduleAtFixedRate(() -> {
            long threshold = System.currentTimeMillis() - 10000L;
            FILE_READ_CACHE.values().removeIf(v -> v < threshold);
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    private record ChunkKey(ResourceKey<Level> dimension, long chunkPos) {
    }

    private static class CompressedHeightMap {
        private final short[] minHeights;
        private BitSet solidFlags;
        private final int minY;
        private final int maxY;

        public CompressedHeightMap(int minY, int maxY) {
            this.minY = minY;
            this.maxY = maxY;
            this.minHeights = new short[256];
            this.solidFlags = new BitSet(4096);
        }

        public void setBlock(int x, int y, int z, boolean isSolid) {
            int heightIndex;
            int columnIndex = x * 16 + z;
            if (isSolid && (y < this.minHeights[columnIndex] || this.minHeights[columnIndex] == 0)) {
                this.minHeights[columnIndex] = (short)y;
            }
            if ((heightIndex = (y - this.minY) / 16) >= 0 && heightIndex < 16) {
                int bitIndex = columnIndex * 16 + heightIndex;
                this.solidFlags.set(bitIndex, isSolid);
            }
        }

        public boolean isSolid(int x, int y, int z) {
            int columnIndex = x * 16 + z;
            if (y <= this.minHeights[columnIndex]) {
                return true;
            }
            int heightIndex = (y - this.minY) / 16;
            if (heightIndex >= 0 && heightIndex < 16) {
                int bitIndex = columnIndex * 16 + heightIndex;
                return this.solidFlags.get(bitIndex);
            }
            return false;
        }

        public int getHeight(int x, int z) {
            return this.minHeights[x * 16 + z];
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public byte[] serialize() {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (DataOutputStream dos = new DataOutputStream(bos);){
                    dos.writeShort(this.minY);
                    dos.writeShort(this.maxY);
                    for (short height : this.minHeights) {
                        dos.writeShort(height);
                    }
                    byte[] flagBytes = this.solidFlags.toByteArray();
                    dos.writeInt(flagBytes.length);
                    dos.write(flagBytes);
                    byArray = bos.toByteArray();
                }
                return byArray;
            }
            catch (IOException e) {
                return new byte[0];
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public static CompressedHeightMap deserialize(byte[] data) {
            try (ByteArrayInputStream bis = new ByteArrayInputStream(data);){
                CompressedHeightMap compressedHeightMap;
                try (DataInputStream dis = new DataInputStream(bis);){
                    short minY = dis.readShort();
                    short maxY = dis.readShort();
                    CompressedHeightMap map = new CompressedHeightMap(minY, maxY);
                    for (int i = 0; i < map.minHeights.length; ++i) {
                        map.minHeights[i] = dis.readShort();
                    }
                    int length = dis.readInt();
                    byte[] flagBytes = new byte[length];
                    dis.readFully(flagBytes);
                    map.solidFlags = BitSet.valueOf(flagBytes);
                    compressedHeightMap = map;
                }
                return compressedHeightMap;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private static class ChunkBlockCache {
        final CompressedHeightMap heightMap;
        final long timestamp;

        public ChunkBlockCache(CompressedHeightMap heightMap) {
            this.heightMap = heightMap;
            this.timestamp = System.currentTimeMillis();
        }

        public boolean hasBlock(int x, int y, int z) {
            return this.heightMap.isSolid(x, y, z);
        }

        public int getHeight(int x, int z) {
            return this.heightMap.getHeight(x, z);
        }
    }
}

