/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.util;

import com.mojang.blaze3d.platform.Window;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.input.InputInterceptor;
import net.shao.valkyrien_space_war.input.VsswInputState;
import net.shao.valkyrien_space_war.input.VsswKeyConfigData;
import org.joml.Vector3d;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryStack;

public class ModClientUtil {
    private static double[] lastMousePos = new double[]{427.0, 240.0};
    private static double[] lastMouseOutput = new double[]{0.0, 0.0};
    private static long lastMouseTime = System.currentTimeMillis();
    private static final float FACTOR = 1000000.0f;
    private static final ThreadLocal<StringBuilder> CACHED_BUILDER = ThreadLocal.withInitial(() -> new StringBuilder(16));

    public static boolean isGameFocused() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.m_91302_() && !mc.m_91104_();
    }

    public static BlockHitResult getTargetedBlock(Player player, double maxDistance) {
        float partialTick = Minecraft.m_91087_().m_91296_();
        Vec3 eyePos = player.m_20299_(partialTick);
        Vec3 lookVec = player.m_20252_(partialTick);
        Vec3 endPos = eyePos.m_82520_(lookVec.f_82479_ * maxDistance, lookVec.f_82480_ * maxDistance, lookVec.f_82481_ * maxDistance);
        return player.m_9236_().m_45547_(new ClipContext(eyePos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
    }

    public static void resetPlayerLookAt(float yaw, float pitch) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null) {
            player.m_146922_(yaw);
            player.m_146926_(pitch);
        }
    }

    public static Vector3d getVector3dFromBlockPos(BlockPos blockPos) {
        return new Vector3d((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
    }

    public static void addTestParticle(double x, double y, double z) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        level.m_6493_((ParticleOptions)ParticleTypes.f_235902_, true, x, y, z, 0.0, 0.0, 0.0);
    }

    public static double[] getMousePos() {
        double[] xPos = new double[1];
        double[] yPos = new double[1];
        GLFW.glfwGetCursorPos((long)Minecraft.m_91087_().m_91268_().m_85439_(), (double[])xPos, (double[])yPos);
        return new double[]{xPos[0], yPos[0]};
    }

    public static void setMousePos(double x, double y) {
        Minecraft.m_91087_().execute(() -> GLFW.glfwSetCursorPos((long)Minecraft.m_91087_().m_91268_().m_85439_(), (double)x, (double)y));
    }

    public static int[] getWindowSize() {
        int[] width = new int[1];
        int[] height = new int[1];
        GLFW.glfwGetWindowSize((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int[])width, (int[])height);
        return new int[]{width[0], height[0]};
    }

    public static float[] getWindowCenter() {
        int[] windowSize = ModClientUtil.getWindowSize();
        return new float[]{(float)windowSize[0] / 2.0f, (float)windowSize[1] / 2.0f};
    }

    public static void setMouseToCenter() {
        Window window = Minecraft.m_91087_().m_91268_();
        Minecraft.m_91087_().execute(() -> GLFW.glfwSetCursorPos((long)window.m_85439_(), (double)(window.m_85443_() / 2), (double)(window.m_85444_() / 2)));
    }

    public static void getInputState(VsswKeyConfigData configData, VsswInputState inputState) {
        inputState.reset();
        HashSet<Integer> jidSet = new HashSet<Integer>();
        configData.binds.forEach((index, bind) -> {
            if (bind.jid >= 0) {
                jidSet.add(bind.jid);
            }
        });
        jidSet.removeIf(jid -> !GLFW.glfwJoystickPresent((int)jid));
        HashMap<Integer, HashMap<Integer, Float>> rawAxisList = new HashMap<Integer, HashMap<Integer, Float>>();
        HashMap<Integer, HashMap<Integer, Byte>> rawButtonList = new HashMap<Integer, HashMap<Integer, Byte>>();
        Iterator iterator = jidSet.iterator();
        while (iterator.hasNext()) {
            int jid2 = (Integer)iterator.next();
            rawAxisList.put(jid2, ModClientUtil.getRawBindAxisState(jid2));
            rawButtonList.put(jid2, ModClientUtil.getBindButtonState(jid2));
        }
        AtomicBoolean[] isFirst = new AtomicBoolean[]{new AtomicBoolean(true)};
        float[] mouseMappingX = new float[]{0.0f};
        float[] mouseMappingY = new float[1];
        for (Map.Entry<Integer, VsswKeyConfigData.CustomBind> entry : configData.binds.entrySet()) {
            Integer index2 = entry.getKey();
            VsswKeyConfigData.CustomBind bind2 = entry.getValue();
            if (bind2.jid >= 0 && jidSet.contains(bind2.jid)) {
                if (bind2.type == VsswKeyConfigData.InputType.GAMEPAD_AXIS || bind2.type == VsswKeyConfigData.InputType.GAMEPAD_AXIS_NEGATIVE) {
                    inputState.setInput(index2, ModClientUtil.getBindAxisMapping(bind2.type, bind2.getMinDeadzone(), bind2.getMaxDeadzone(), ((Float)((HashMap)rawAxisList.get(bind2.jid)).get(bind2.code)).floatValue()));
                    continue;
                }
                if (bind2.type != VsswKeyConfigData.InputType.GAMEPAD_BUTTON) continue;
                inputState.setInput(index2, ((Byte)((HashMap)rawButtonList.get(bind2.jid)).get(bind2.code)).byteValue());
                continue;
            }
            if (bind2.type == VsswKeyConfigData.InputType.MOUSE_MOVEMENT_X || bind2.type == VsswKeyConfigData.InputType.MOUSE_MOVEMENT_Y || bind2.type == VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NX || bind2.type == VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NY) {
                if (!InputInterceptor.isMouseUsing) {
                    inputState.setInput(index2, 0.0f);
                    continue;
                }
                if (isFirst[0].get()) {
                    float[] mouseMapping = ModClientUtil.getMouseMapping(1.0f, bind2.isVelocityMode());
                    mouseMappingX[0] = mouseMapping[0];
                    mouseMappingY[0] = mouseMapping[1];
                    isFirst[0].set(false);
                }
                float mouseSpeed = bind2.getMouseSpeed();
                float mouseX = mouseMappingX[0] * mouseSpeed;
                float mouseY = mouseMappingY[0] * mouseSpeed;
                float mouseMap = switch (bind2.type) {
                    case VsswKeyConfigData.InputType.MOUSE_MOVEMENT_X -> {
                        if (mouseX < 0.0f) {
                            yield 0.0f;
                        }
                        if (mouseX > 1.0f) {
                            yield 1.0f;
                        }
                        yield mouseX;
                    }
                    case VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NX -> {
                        if (mouseX > 0.0f) {
                            yield 0.0f;
                        }
                        if (mouseX < -1.0f) {
                            yield 1.0f;
                        }
                        yield -mouseX;
                    }
                    case VsswKeyConfigData.InputType.MOUSE_MOVEMENT_Y -> {
                        if (mouseY < 0.0f) {
                            yield 0.0f;
                        }
                        if (mouseY > 1.0f) {
                            yield 1.0f;
                        }
                        yield mouseY;
                    }
                    case VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NY -> {
                        if (mouseY > 0.0f) {
                            yield 0.0f;
                        }
                        if (mouseY < -1.0f) {
                            yield 1.0f;
                        }
                        yield -mouseY;
                    }
                    default -> 0.0f;
                };
                inputState.setInput(index2, mouseMap);
                continue;
            }
            if (bind2.type == VsswKeyConfigData.InputType.KEYBOARD) {
                inputState.setInput(index2, ModClientUtil.getKeyboardKeyState(bind2.code));
                continue;
            }
            if (bind2.type != VsswKeyConfigData.InputType.MOUSE_CLICK) continue;
            inputState.setInput(index2, ModClientUtil.getMouseButtonState(bind2.code));
        }
    }

    public static HashMap<Integer, Float> getRawBindAxisState(int jid) {
        HashMap<Integer, Float> result = new HashMap<Integer, Float>();
        FloatBuffer axes = GLFW.glfwGetJoystickAxes((int)jid);
        ModClientUtil.populateMapFromBuffer(axes, result);
        return result;
    }

    public static float getBindAxisMapping(VsswKeyConfigData.InputType type, float min, float max, float axisValue) {
        axisValue = ModClientUtil.clamp(axisValue, min, max);
        float scale = max - min;
        if (type == VsswKeyConfigData.InputType.GAMEPAD_AXIS) {
            return (axisValue - min) / scale;
        }
        if (type == VsswKeyConfigData.InputType.GAMEPAD_AXIS_NEGATIVE) {
            return (max - axisValue) / scale;
        }
        return 0.0f;
    }

    public static HashMap<Integer, Byte> getBindButtonState(int jid) {
        HashMap<Integer, Byte> result = new HashMap<Integer, Byte>();
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer buttons = GLFW.glfwGetJoystickButtons((int)jid);
            ModClientUtil.populateMapFromBuffer(buttons, result);
        }
        return result;
    }

    private static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float[] getMouseMapping(float mouseSpeed, boolean isVelocityMode) {
        double[] mousePos = ModClientUtil.getMousePos();
        if (isVelocityMode) {
            float dx = (float)(mousePos[0] - lastMousePos[0]) / 10.0f * mouseSpeed;
            float dy = (float)(mousePos[1] - lastMousePos[1]) / 10.0f * mouseSpeed;
            dx = Math.max(Math.min(dx, 1.0f), -1.0f);
            dy = Math.max(Math.min(dy, 1.0f), -1.0f);
            if (System.currentTimeMillis() - lastMouseTime > 7L) {
                lastMousePos = mousePos;
                lastMouseTime = System.currentTimeMillis();
            }
            return new float[]{dx, dy};
        }
        float maxDistance = 400.0f / mouseSpeed;
        float dx = (float)(mousePos[0] - lastMousePos[0]) / maxDistance;
        float dy = (float)(mousePos[1] - lastMousePos[1]) / maxDistance;
        if (System.currentTimeMillis() - lastMouseTime > 7L) {
            lastMousePos = mousePos;
            lastMouseTime = System.currentTimeMillis();
        }
        double xResult = lastMouseOutput[0] + (double)dx;
        double yResult = lastMouseOutput[1] + (double)dy;
        xResult = Math.max(Math.min(xResult, 1.0), -1.0);
        yResult = Math.max(Math.min(yResult, 1.0), -1.0);
        lastMouseOutput = new double[]{xResult, yResult};
        return new float[]{(float)xResult, (float)yResult};
    }

    public static void resetMouseState() {
        lastMousePos = ModClientUtil.getMousePos();
        lastMouseOutput = new double[]{0.0, 0.0};
    }

    public static byte getKeyboardKeyState(int keycode) {
        return (byte)GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keycode);
    }

    public static byte getMouseButtonState(int keycode) {
        return (byte)GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keycode);
    }

    public static int getJoystickCount() {
        int joystickCount = GLFW.glfwJoystickPresent((int)0) ? 1 : 0;
        for (int i = 1; i <= 15; ++i) {
            if (!GLFW.glfwJoystickPresent((int)i)) continue;
            ++joystickCount;
        }
        return joystickCount;
    }

    public static CopyOnWriteArrayList<Integer> getConnectedJoystickList() {
        CopyOnWriteArrayList<Integer> joystickList = new CopyOnWriteArrayList<Integer>();
        for (int i = 0; i <= 15; ++i) {
            if (!GLFW.glfwJoystickPresent((int)i)) continue;
            joystickList.add(i);
        }
        return joystickList;
    }

    public static Map<String, Object> getJoyState(int jid) {
        if (GLFW.glfwJoystickPresent((int)jid)) {
            HashMap<Integer, Byte> joyButtons = new HashMap<Integer, Byte>();
            HashMap<Integer, Float> joyAxis = new HashMap<Integer, Float>();
            HashMap<Integer, Byte> joyHats = new HashMap<Integer, Byte>();
            try (MemoryStack stack = MemoryStack.stackPush();){
                ByteBuffer buttons = GLFW.glfwGetJoystickButtons((int)jid);
                ModClientUtil.populateMapFromBuffer(buttons, joyButtons);
                FloatBuffer axes = GLFW.glfwGetJoystickAxes((int)jid);
                ModClientUtil.populateMapFromBuffer(axes, joyAxis);
                ByteBuffer hats = GLFW.glfwGetJoystickHats((int)jid);
                ModClientUtil.populateMapFromBuffer(hats, joyHats);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("buttons", joyButtons);
            result.put("axes", joyAxis);
            result.put("hats", joyHats);
            return result;
        }
        return new HashMap<String, Object>();
    }

    public static Map<String, Object> computeStateDiff(Map<String, Object> oldState, Map<String, Object> newState, float acc) {
        HashMap<String, Object> diff = new HashMap<String, Object>();
        Map oldButtons = oldState.getOrDefault("buttons", Collections.emptyMap());
        Map newButtons = newState.getOrDefault("buttons", Collections.emptyMap());
        diff.put("buttons", ModClientUtil.findChangedEntries(oldButtons, newButtons, acc));
        Map oldAxes = oldState.getOrDefault("axes", Collections.emptyMap());
        Map newAxes = newState.getOrDefault("axes", Collections.emptyMap());
        diff.put("axes", ModClientUtil.findChangedEntries(oldAxes, newAxes, acc));
        Map oldHats = oldState.getOrDefault("hats", Collections.emptyMap());
        Map newHats = newState.getOrDefault("hats", Collections.emptyMap());
        diff.put("hats", ModClientUtil.findChangedEntries(oldHats, newHats, acc));
        return diff;
    }

    private static <K, V> Map<K, V> findChangedEntries(Map<K, V> oldMap, Map<K, V> newMap, float acc) {
        HashMap changes = new HashMap();
        newMap.forEach((key, newValue) -> {
            Object oldValue = oldMap.getOrDefault(key, null);
            if (!ModClientUtil.isEqual(oldValue, newValue, acc)) {
                changes.put(key, newValue);
            }
        });
        return changes;
    }

    private static boolean isEqual(Object a, Object b, float acc) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof Float && b instanceof Float) {
            return Math.abs(((Float)a).floatValue() - ((Float)b).floatValue()) < Math.abs(acc);
        }
        return a.equals(b);
    }

    public static void populateMapFromBuffer(ByteBuffer buffer, Map<Integer, Byte> map) {
        if (buffer != null) {
            int index = 0;
            while (buffer.hasRemaining()) {
                byte value = buffer.get();
                map.put(index, value);
                ++index;
            }
        }
    }

    public static void populateMapFromBuffer(FloatBuffer buffer, Map<Integer, Float> map) {
        if (buffer != null) {
            int index = 0;
            while (buffer.hasRemaining()) {
                map.put(index, Float.valueOf(buffer.get()));
                ++index;
            }
        }
    }

    public static void sendMsgToLocalPlayer(String msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.m_213846_((Component)Component.m_237113_((String)msg));
        }
    }

    public static void printControllerInfo() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        for (int i = 0; i <= 15; ++i) {
            if (!GLFW.glfwJoystickPresent((int)i)) continue;
            String joyName = GLFW.glfwGetJoystickName((int)i);
            player.m_213846_((Component)Component.m_237113_((String)("\u63a7\u5236\u5668:" + joyName)));
            try (MemoryStack stack = MemoryStack.stackPush();){
                ByteBuffer hats;
                FloatBuffer axes;
                ByteBuffer buttons = GLFW.glfwGetJoystickButtons((int)i);
                if (buttons != null) {
                    int index = 0;
                    while (buttons.hasRemaining()) {
                        byte buttonState = buttons.get();
                        if (buttonState > 0) {
                            player.m_213846_((Component)Component.m_237113_((String)("\u63a7\u5236\u5668" + joyName + "\u6309\u952e" + index + "\u6309\u4e0b")));
                        }
                        ++index;
                    }
                }
                if ((axes = GLFW.glfwGetJoystickAxes((int)i)) != null) {
                    int index = 0;
                    while (axes.hasRemaining()) {
                        float axisValue = axes.get();
                        if ((double)Math.abs(axisValue) > 0.1) {
                            player.m_213846_((Component)Component.m_237113_((String)("\u63a7\u5236\u5668" + joyName + "\u8f74" + index + "\u503c\u4e3a" + axisValue)));
                        }
                        ++index;
                    }
                }
                if ((hats = GLFW.glfwGetJoystickHats((int)i)) == null) continue;
                int index = 0;
                while (hats.hasRemaining()) {
                    byte hatValue = hats.get();
                    if (hatValue > 0) {
                        player.m_213846_((Component)Component.m_237113_((String)("\u63a7\u5236\u5668" + joyName + "hat" + index + "\u503c\u4e3a" + hatValue)));
                    }
                    ++index;
                }
                continue;
            }
        }
    }

    public static float truncateToSixDecimalPlaces(float value) {
        return (float)((int)(value * 1000000.0f)) / 1000000.0f;
    }

    public static String formatFloat6(double value) {
        if (Double.isNaN(value)) {
            return "NaN";
        }
        if (Double.isInfinite(value)) {
            return value > 0.0 ? "Infinity" : "-Infinity";
        }
        StringBuilder sb = CACHED_BUILDER.get();
        sb.setLength(0);
        if (value < 0.0) {
            sb.append('-');
            value = -value;
        }
        long integral = (long)value;
        double fractional = value - (double)integral;
        sb.append(integral).append('.');
        long scaled = (long)(fractional * 1000000.0 + 0.5);
        if (scaled >= 1000000L) {
            scaled -= 1000000L;
            sb.setCharAt(sb.indexOf(".") - 1, (char)(++integral % 10L + 48L));
        }
        if (scaled < 100000L) {
            sb.append('0');
        }
        if (scaled < 10000L) {
            sb.append('0');
        }
        if (scaled < 1000L) {
            sb.append('0');
        }
        if (scaled < 100L) {
            sb.append('0');
        }
        if (scaled < 10L) {
            sb.append('0');
        }
        sb.append(scaled);
        return sb.toString();
    }

    public static String getKeyName(int key) {
        switch (key) {
            case 257: {
                return "Enter";
            }
            case 258: {
                return "Tab";
            }
            case 259: {
                return "Backspace";
            }
            case 260: {
                return "Insert";
            }
            case 261: {
                return "Delete";
            }
            case 262: {
                return "Right";
            }
            case 263: {
                return "Left";
            }
            case 264: {
                return "Down";
            }
            case 265: {
                return "Up";
            }
            case 266: {
                return "Page Up";
            }
            case 267: {
                return "Page Down";
            }
            case 268: {
                return "Home";
            }
            case 269: {
                return "End";
            }
            case 280: {
                return "Caps Lock";
            }
            case 281: {
                return "Scroll Lock";
            }
            case 282: {
                return "Num Lock";
            }
            case 283: {
                return "Print Screen";
            }
            case 284: {
                return "Pause";
            }
            case 32: {
                return "Space";
            }
            case 340: {
                return "Left Shift";
            }
            case 344: {
                return "Right Shift";
            }
            case 341: {
                return "Left Control";
            }
            case 345: {
                return "Right Control";
            }
            case 290: {
                return "F1";
            }
            case 291: {
                return "F2";
            }
            case 292: {
                return "F3";
            }
            case 293: {
                return "F4";
            }
            case 294: {
                return "F5";
            }
            case 295: {
                return "F6";
            }
            case 296: {
                return "F7";
            }
            case 297: {
                return "F8";
            }
            case 298: {
                return "F9";
            }
            case 299: {
                return "F10";
            }
            case 300: {
                return "F11";
            }
            case 301: {
                return "F12";
            }
            case 320: {
                return "Num 0";
            }
            case 321: {
                return "Num 1";
            }
            case 322: {
                return "Num 2";
            }
            case 323: {
                return "Num 3";
            }
            case 324: {
                return "Num 4";
            }
            case 325: {
                return "Num 5";
            }
            case 326: {
                return "Num 6";
            }
            case 327: {
                return "Num 7";
            }
            case 328: {
                return "Num 8";
            }
            case 329: {
                return "Num 9";
            }
            case 331: {
                return "Num /";
            }
            case 332: {
                return "Num *";
            }
            case 333: {
                return "Num -";
            }
            case 334: {
                return "Num +";
            }
            case 330: {
                return "Num .";
            }
            case 335: {
                return "Num Enter";
            }
            case 342: {
                return "Left Alt";
            }
            case 346: {
                return "Right Alt";
            }
            case 343: {
                return "Left Super";
            }
            case 347: {
                return "Right Super";
            }
            case 348: {
                return "Menu";
            }
        }
        String name = GLFW.glfwGetKeyName((int)key, (int)0);
        return name != null ? name : "Unknown";
    }
}

