/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.util;

import java.util.Random;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class ModMathUtil {
    private static final int RESOLUTION = 3600;
    private static final double[] SIN_TABLE = new double[3600];
    private static final double[] COS_TABLE = new double[3600];
    private static final double[] TAN_TABLE = new double[3600];
    private static final double TWO_PI = Math.PI * 2;

    public static double fastSin(double radians) {
        if ((radians %= Math.PI * 2) < 0.0) {
            radians += Math.PI * 2;
        }
        int index = (int)(radians / 0.0017453292519943296);
        return SIN_TABLE[index];
    }

    public static double fastCos(double radians) {
        if ((radians %= Math.PI * 2) < 0.0) {
            radians += Math.PI * 2;
        }
        int index = (int)(radians / 0.0017453292519943296);
        return COS_TABLE[index];
    }

    public static double fastTan(double radians) {
        if ((radians %= Math.PI * 2) < 0.0) {
            radians += Math.PI * 2;
        }
        int index = (int)(radians / 0.0017453292519943296);
        return TAN_TABLE[index];
    }

    public static Vector3d checkAndReplaceNaN(Vector3d input) {
        double x = input.x;
        double y = input.y;
        double z = input.z;
        double newX = ModMathUtil.isInvalidNumber(x) ? 0.0 : x;
        double newY = ModMathUtil.isInvalidNumber(y) ? 0.0 : y;
        double newZ = ModMathUtil.isInvalidNumber(z) ? 0.0 : z;
        return new Vector3d(newX, newY, newZ);
    }

    private static boolean isInvalidNumber(double value) {
        return Double.isNaN(value) || Double.isInfinite(value);
    }

    public static float roundToTenth(float num) {
        float scaled = num * 10.0f;
        if (scaled >= 0.0f) {
            return (float)((int)(scaled + 0.5f)) / 10.0f;
        }
        return (float)((int)(scaled - 0.5f)) / 10.0f;
    }

    public static boolean isInFOV(Vector3f selfPos, Vector3f radarDir, Vector3d targetPos, float maxDistanceSq, double cosHalfFOV) {
        double dx = targetPos.x - (double)selfPos.x;
        double dy = targetPos.y - (double)selfPos.y;
        double dz = targetPos.z - (double)selfPos.z;
        double distSq = dx * dx + dy * dy + dz * dz;
        if (distSq > (double)maxDistanceSq) {
            return false;
        }
        double len = Math.sqrt(distSq);
        double dotProduct = (dx * (double)radarDir.x + dy * (double)radarDir.y + dz * (double)radarDir.z) / len;
        return dotProduct >= cosHalfFOV;
    }

    public static Vector3d sanitizeVector(Vector3d vector) {
        if (vector == null) {
            return new Vector3d();
        }
        double safeX = ModMathUtil.checkComponent(vector.x());
        double safeY = ModMathUtil.checkComponent(vector.y());
        double safeZ = ModMathUtil.checkComponent(vector.z());
        return new Vector3d(safeX, safeY, safeZ);
    }

    private static double checkComponent(double value) {
        return Double.isFinite(value) ? value : 0.0;
    }

    public static Vec3 intersectionCalculator(Vec3 coordinate, double range, Vec3 pos, Vec3 delta) {
        double t2;
        double ox = pos.f_82479_;
        double dx = delta.f_82479_;
        double oy = pos.f_82480_;
        double dy = delta.f_82480_;
        double oz = pos.f_82481_;
        double dz = delta.f_82481_;
        double b = 2.0 * ((ox - coordinate.f_82479_) * dx + (oy - coordinate.f_82480_) * dy + (oz - coordinate.f_82481_) * dz);
        double a = dx * dx + dy * dy + dz * dz;
        double c = (ox - coordinate.f_82479_) * (ox - coordinate.f_82479_) + (oy - coordinate.f_82480_) * (oy - coordinate.f_82480_) + (oz - coordinate.f_82481_) * (oz - coordinate.f_82481_) - range * range;
        double discriminant = b * b - 4.0 * a * c;
        double t1 = (-b + Math.sqrt(discriminant)) / (2.0 * a);
        double t = Math.min(t1, t2 = (-b - Math.sqrt(discriminant)) / (2.0 * a)) >= 0.0 ? Math.min(t1, t2) : Math.max(t1, t2);
        return new Vec3(ox + t * dx, oy + t * dy, oz + t * dz);
    }

    public static float wrapDegrees(float pValue) {
        float f = pValue % 360.0f;
        if (f > 180.0f) {
            f -= 360.0f;
        }
        if (f < -180.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static void printVector(String name, Vector3d mul) {
        System.out.printf("%s: (%.2f, %.2f, %.2f)\n", name, mul.x, mul.y, mul.z);
    }

    public static int checkLineSphereRelation(Vec3 a1, Vec3 b1, Vec3 center1, double radius) {
        Vector3 a = new Vector3(a1.f_82479_, a1.f_82480_, a1.f_82481_);
        Vector3 b = new Vector3(b1.f_82479_, b1.f_82480_, b1.f_82481_);
        Vector3 center = new Vector3(center1.f_82479_, center1.f_82480_, center1.f_82481_);
        double EPSILON = 1.0E-9;
        Vector3 aToCenter = center.subtract(a);
        double aDistanceSq = aToCenter.lengthSquared() - 0.1;
        if (aDistanceSq <= radius * radius + 1.0E-9) {
            return 2;
        }
        Vector3 ab = b.subtract(a);
        if (ab.lengthSquared() < 1.0E-9) {
            return 0;
        }
        double t0 = aToCenter.dot(ab) / ab.dot(ab);
        double tClamped = Math.max(0.0, Math.min(1.0, t0));
        Vector3 closestPoint = a.add(ab.multiply(tClamped));
        double distanceSq = closestPoint.subtract(center).lengthSquared();
        return distanceSq <= radius * radius ? 1 : 0;
    }

    public static Vec3 randomPointInRectangle(Random random, double x1, double z1, double x2, double z2, double y) {
        double minX = Math.min(x1, x2);
        double maxX = Math.max(x1, x2);
        double minZ = Math.min(z1, z2);
        double maxZ = Math.max(z1, z2);
        double randomX = minX + random.nextDouble() * (maxX - minX);
        double randomZ = minZ + random.nextDouble() * (maxZ - minZ);
        return new Vec3(randomX, y, randomZ);
    }

    public static Vec3 randomPointInRectangleRing(Random random, double innerX1, double innerZ1, double innerX2, double innerZ2, double outerX1, double outerZ1, double outerX2, double outerZ2, double y) {
        double randomZ;
        double randomX;
        boolean isOutsideInner;
        double innerMinX = Math.min(innerX1, innerX2);
        double innerMaxX = Math.max(innerX1, innerX2);
        double innerMinZ = Math.min(innerZ1, innerZ2);
        double innerMaxZ = Math.max(innerZ1, innerZ2);
        double outerMinX = Math.min(outerX1, outerX2);
        double outerMaxX = Math.max(outerX1, outerX2);
        double outerMinZ = Math.min(outerZ1, outerZ2);
        double outerMaxZ = Math.max(outerZ1, outerZ2);
        do {
            randomX = outerMinX + random.nextDouble() * (outerMaxX - outerMinX);
            randomZ = outerMinZ + random.nextDouble() * (outerMaxZ - outerMinZ);
        } while (!(isOutsideInner = randomX < innerMinX || randomX > innerMaxX || randomZ < innerMinZ || randomZ > innerMaxZ));
        return new Vec3(randomX, y, randomZ);
    }

    static {
        for (int i = 0; i < 3600; ++i) {
            double radians = (double)i * 0.1 * Math.PI / 180.0;
            ModMathUtil.TAN_TABLE[i] = Math.tan(radians);
            ModMathUtil.SIN_TABLE[i] = Math.sin(radians);
            ModMathUtil.COS_TABLE[i] = Math.cos(radians);
        }
    }

    static class Vector3 {
        public final double x;
        public final double y;
        public final double z;

        public Vector3(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vector3 subtract(Vector3 other) {
            return new Vector3(this.x - other.x, this.y - other.y, this.z - other.z);
        }

        public Vector3 add(Vector3 other) {
            return new Vector3(this.x + other.x, this.y + other.y, this.z + other.z);
        }

        public Vector3 multiply(double scalar) {
            return new Vector3(this.x * scalar, this.y * scalar, this.z * scalar);
        }

        public double dot(Vector3 other) {
            return this.x * other.x + this.y * other.y + this.z * other.z;
        }

        public double lengthSquared() {
            return this.x * this.x + this.y * this.y + this.z * this.z;
        }
    }
}

