/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.vs;

import java.util.HashSet;
import net.shao.valkyrien_space_war.function.vs.RigidBody;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class CombinedRigidBodyCalculator {
    public static RigidBody combineRigidBodies(HashSet<RigidBody> bodies) {
        if (bodies == null || bodies.size() == 0) {
            throw new IllegalArgumentException("\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u521a\u4f53");
        }
        double totalMass = 0.0;
        Vector3d combinedCOM = new Vector3d(0.0, 0.0, 0.0);
        for (RigidBody body : bodies) {
            totalMass += body.mass;
            combinedCOM.fma(body.mass, (Vector3dc)body.centerOfMass);
        }
        combinedCOM.div(totalMass);
        double combinedInertia = 0.0;
        for (RigidBody body : bodies) {
            Vector3d displacement = new Vector3d((Vector3dc)body.centerOfMass).sub((Vector3dc)combinedCOM);
            double dx = displacement.x;
            double dy = displacement.y;
            double dz = displacement.z;
            double d2 = dx * dx + dy * dy + dz * dz;
            double inertiaIncrement = body.mass * d2;
            combinedInertia += body.inertiaScalar + inertiaIncrement;
        }
        return new RigidBody(totalMass, combinedCOM, combinedInertia);
    }
}

