/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.vs;

import net.minecraft.core.Direction;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class DirectionRotationCalculator {
    private static final double HALF_PI = 1.5707963267948966;
    private static final double PI = Math.PI;

    public static Quaterniond getRotationBetweenDirections(Direction a, Direction b) {
        if (a == b) {
            return new Quaterniond();
        }
        if (a == b.m_122424_()) {
            return DirectionRotationCalculator.getOppositeRotation(a);
        }
        return DirectionRotationCalculator.calculateRotation(a, b);
    }

    private static Quaterniond getOppositeRotation(Direction dir) {
        switch (dir) {
            case UP: 
            case DOWN: {
                return new Quaterniond().rotateX(Math.PI);
            }
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                return new Quaterniond().rotateY(Math.PI);
            }
        }
        return new Quaterniond();
    }

    private static Quaterniond calculateRotation(Direction a, Direction b) {
        Quaterniond rotation = new Quaterniond();
        switch (a) {
            case NORTH: {
                rotation = DirectionRotationCalculator.rotationFromNorth(b);
                break;
            }
            case SOUTH: {
                rotation = DirectionRotationCalculator.rotationFromSouth(b);
                break;
            }
            case EAST: {
                rotation = DirectionRotationCalculator.rotationFromEast(b);
                break;
            }
            case WEST: {
                rotation = DirectionRotationCalculator.rotationFromWest(b);
                break;
            }
            case UP: {
                rotation = DirectionRotationCalculator.rotationFromUp(b);
                break;
            }
            case DOWN: {
                rotation = DirectionRotationCalculator.rotationFromDown(b);
            }
        }
        return rotation;
    }

    private static Quaterniond rotationFromNorth(Direction to) {
        switch (to) {
            case SOUTH: {
                return new Quaterniond().rotateY(Math.PI);
            }
            case EAST: {
                return new Quaterniond().rotateY(-1.5707963267948966);
            }
            case WEST: {
                return new Quaterniond().rotateY(1.5707963267948966);
            }
            case UP: {
                return new Quaterniond().rotateX(1.5707963267948966).rotateZ(Math.PI);
            }
            case DOWN: {
                return new Quaterniond().rotateX(-1.5707963267948966).rotateZ(Math.PI);
            }
        }
        return new Quaterniond();
    }

    private static Quaterniond rotationFromSouth(Direction to) {
        switch (to) {
            case NORTH: {
                return new Quaterniond().rotateY(Math.PI);
            }
            case EAST: {
                return new Quaterniond().rotateY(1.5707963267948966);
            }
            case WEST: {
                return new Quaterniond().rotateY(-1.5707963267948966);
            }
            case UP: {
                return new Quaterniond().rotateX(-1.5707963267948966);
            }
            case DOWN: {
                return new Quaterniond().rotateX(1.5707963267948966);
            }
        }
        return new Quaterniond();
    }

    private static Quaterniond rotationFromEast(Direction to) {
        switch (to) {
            case NORTH: {
                return new Quaterniond().rotateY(1.5707963267948966);
            }
            case SOUTH: {
                return new Quaterniond().rotateY(-1.5707963267948966);
            }
            case WEST: {
                return new Quaterniond().rotateY(Math.PI);
            }
            case UP: {
                return new Quaterniond().rotateZ(1.5707963267948966).rotateX(-1.5707963267948966);
            }
            case DOWN: {
                return new Quaterniond().rotateZ(-1.5707963267948966).rotateX(1.5707963267948966);
            }
        }
        return new Quaterniond();
    }

    private static Quaterniond rotationFromWest(Direction to) {
        switch (to) {
            case NORTH: {
                return new Quaterniond().rotateY(-1.5707963267948966);
            }
            case SOUTH: {
                return new Quaterniond().rotateY(1.5707963267948966);
            }
            case EAST: {
                return new Quaterniond().rotateY(Math.PI);
            }
            case UP: {
                return new Quaterniond().rotateZ(-1.5707963267948966).rotateX(-1.5707963267948966);
            }
            case DOWN: {
                return new Quaterniond().rotateZ(1.5707963267948966).rotateX(1.5707963267948966);
            }
        }
        return new Quaterniond();
    }

    private static Quaterniond rotationFromUp(Direction to) {
        switch (to) {
            case NORTH: {
                return new Quaterniond().rotateX(-1.5707963267948966).rotateY(Math.PI);
            }
            case SOUTH: {
                return new Quaterniond().rotateX(1.5707963267948966);
            }
            case EAST: {
                return new Quaterniond().rotateZ(-1.5707963267948966).rotateY(1.5707963267948966);
            }
            case WEST: {
                return new Quaterniond().rotateZ(1.5707963267948966).rotateY(-1.5707963267948966);
            }
            case DOWN: {
                return new Quaterniond().rotateX(Math.PI);
            }
        }
        return new Quaterniond();
    }

    private static Quaterniond rotationFromDown(Direction to) {
        switch (to) {
            case NORTH: {
                return new Quaterniond().rotateX(1.5707963267948966).rotateY(Math.PI);
            }
            case SOUTH: {
                return new Quaterniond().rotateX(-1.5707963267948966);
            }
            case EAST: {
                return new Quaterniond().rotateZ(1.5707963267948966).rotateY(1.5707963267948966);
            }
            case WEST: {
                return new Quaterniond().rotateZ(-1.5707963267948966).rotateY(-1.5707963267948966);
            }
            case UP: {
                return new Quaterniond().rotateX(Math.PI);
            }
        }
        return new Quaterniond();
    }

    public static Quaterniond getRotationBetweenDirectionsMath(Direction a, Direction b) {
        Vector3d vecB;
        Vector3d vecA = DirectionRotationCalculator.directionToVector(a);
        Vector3d axis = vecA.cross((Vector3dc)(vecB = DirectionRotationCalculator.directionToVector(b)), new Vector3d());
        if (axis.lengthSquared() < 1.0E-10) {
            if (vecA.dot((Vector3dc)vecB) > 0.0) {
                return new Quaterniond();
            }
            return DirectionRotationCalculator.getOppositeRotation(a);
        }
        axis.normalize();
        double dot = vecA.dot((Vector3dc)vecB);
        double angle = Math.acos(Math.max(-1.0, Math.min(1.0, dot)));
        return new Quaterniond().setAngleAxis(angle, axis.x, axis.y, axis.z);
    }

    private static Quaterniond getOppositeRotation2(Direction dir) {
        switch (dir) {
            case UP: 
            case DOWN: {
                return new Quaterniond().rotateX(Math.PI);
            }
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                return new Quaterniond().rotateY(Math.PI);
            }
        }
        return new Quaterniond();
    }

    private static Vector3d directionToVector(Direction dir) {
        return new Vector3d((double)dir.m_122429_(), (double)dir.m_122430_(), (double)dir.m_122431_());
    }
}

