/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.vs;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class VsConstraintUtil {
    public static final String TAG_ATTACHMENT_CONSTRAINT = "attach_cst";
    public static final String TAG_HINGE_CONSTRAINT = "hinge_cst";

    public static CompoundTag newPosTag(Vector3dc vec) {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("x", vec.x());
        tag.m_128347_("y", vec.y());
        tag.m_128347_("z", vec.z());
        return tag;
    }

    public static CompoundTag serializeAttachmentConstraint(AttachmentConstraintRecord constraint) {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("sid0", constraint.shipId0());
        tag.m_128356_("sid1", constraint.shipId1());
        Vector3dc pos0 = constraint.localPos0();
        tag.m_128365_("lp0", (Tag)VsConstraintUtil.newPosTag(pos0));
        Vector3dc pos1 = constraint.localPos1();
        tag.m_128365_("lp1", (Tag)VsConstraintUtil.newPosTag(pos1));
        tag.m_128347_("fdist", constraint.fixedDistance());
        return tag;
    }

    public static AttachmentConstraintRecord deserializeAttachmentConstraint(CompoundTag tag) {
        long shipId0 = tag.m_128441_("sid0") ? tag.m_128454_("sid0") : Long.MIN_VALUE;
        long shipId1 = tag.m_128441_("sid1") ? tag.m_128454_("sid1") : Long.MIN_VALUE;
        Vector3d localPos0 = new Vector3d(tag.m_128425_("lp0", 10) ? tag.m_128469_("lp0").m_128459_("x") : 0.0, tag.m_128425_("lp0", 10) ? tag.m_128469_("lp0").m_128459_("y") : 0.0, tag.m_128425_("lp0", 10) ? tag.m_128469_("lp0").m_128459_("z") : 0.0);
        Vector3d localPos1 = new Vector3d(tag.m_128425_("lp1", 10) ? tag.m_128469_("lp1").m_128459_("x") : 0.0, tag.m_128425_("lp1", 10) ? tag.m_128469_("lp1").m_128459_("y") : 0.0, tag.m_128425_("lp1", 10) ? tag.m_128469_("lp1").m_128459_("z") : 0.0);
        double fixedDistance = tag.m_128441_("fdist") ? tag.m_128459_("fdist") : 0.0;
        return new AttachmentConstraintRecord(shipId0, shipId1, (Vector3dc)localPos0, (Vector3dc)localPos1, fixedDistance);
    }

    public static CompoundTag serializeSlideConstraint(SlideConstraintRecord constraint) {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("sid0", constraint.shipId0());
        tag.m_128356_("sid1", constraint.shipId1());
        Vector3dc pos0 = constraint.localPos0();
        tag.m_128365_("lp0", (Tag)VsConstraintUtil.newPosTag(pos0));
        Vector3dc pos1 = constraint.localPos1();
        tag.m_128365_("lp1", (Tag)VsConstraintUtil.newPosTag(pos1));
        tag.m_128365_("axis", (Tag)VsConstraintUtil.newPosTag(constraint.axis()));
        tag.m_128347_("maxDist", constraint.maxDist());
        return tag;
    }

    public static SlideConstraintRecord deserializeSlideConstraint(CompoundTag tag) {
        long shipId0 = tag.m_128441_("sid0") ? tag.m_128454_("sid0") : Long.MIN_VALUE;
        long shipId1 = tag.m_128441_("sid1") ? tag.m_128454_("sid1") : Long.MIN_VALUE;
        Vector3d localPos0 = new Vector3d(tag.m_128425_("lp0", 10) ? tag.m_128469_("lp0").m_128459_("x") : 0.0, tag.m_128425_("lp0", 10) ? tag.m_128469_("lp0").m_128459_("y") : 0.0, tag.m_128425_("lp0", 10) ? tag.m_128469_("lp0").m_128459_("z") : 0.0);
        Vector3d localPos1 = new Vector3d(tag.m_128425_("lp1", 10) ? tag.m_128469_("lp1").m_128459_("x") : 0.0, tag.m_128425_("lp1", 10) ? tag.m_128469_("lp1").m_128459_("y") : 0.0, tag.m_128425_("lp1", 10) ? tag.m_128469_("lp1").m_128459_("z") : 0.0);
        Vector3d axis = new Vector3d(tag.m_128425_("axis", 10) ? tag.m_128469_("axis").m_128459_("x") : 0.0, tag.m_128425_("axis", 10) ? tag.m_128469_("axis").m_128459_("y") : 0.0, tag.m_128425_("axis", 10) ? tag.m_128469_("axis").m_128459_("z") : 0.0);
        double maxDist = tag.m_128441_("maxDist") ? tag.m_128459_("maxDist") : 0.0;
        return new SlideConstraintRecord(shipId0, shipId1, (Vector3dc)localPos0, (Vector3dc)localPos1, (Vector3dc)axis, maxDist);
    }

    public static CompoundTag serializeHingeConstraint(HingeConstraintRecord constraint) {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("sid0", constraint.shipId0());
        tag.m_128356_("sid1", constraint.shipId1());
        Quaterniondc rot0 = constraint.localRot0();
        CompoundTag rotTag0 = new CompoundTag();
        rotTag0.m_128347_("x", rot0.x());
        rotTag0.m_128347_("y", rot0.y());
        rotTag0.m_128347_("z", rot0.z());
        rotTag0.m_128347_("w", rot0.w());
        tag.m_128365_("rot0", (Tag)rotTag0);
        Quaterniondc rot1 = constraint.localRot1();
        CompoundTag rotTag1 = new CompoundTag();
        rotTag1.m_128347_("x", rot1.x());
        rotTag1.m_128347_("y", rot1.y());
        rotTag1.m_128347_("z", rot1.z());
        rotTag1.m_128347_("w", rot1.w());
        tag.m_128365_("rot1", (Tag)rotTag1);
        tag.m_128379_("isFixed", constraint.isFixed());
        return tag;
    }

    public static HingeConstraintRecord deserializeHingeConstraint(CompoundTag tag) {
        long shipId0 = tag.m_128441_("sid0") ? tag.m_128454_("sid0") : Long.MIN_VALUE;
        long shipId1 = tag.m_128441_("sid1") ? tag.m_128454_("sid1") : Long.MIN_VALUE;
        Quaterniond localRot0 = new Quaterniond();
        if (tag.m_128425_("rot0", 10)) {
            CompoundTag rotTag = tag.m_128469_("rot0");
            localRot0 = new Quaterniond(VsConstraintUtil.getDoubleWithDefault(rotTag, "x", 0.0), VsConstraintUtil.getDoubleWithDefault(rotTag, "y", 0.0), VsConstraintUtil.getDoubleWithDefault(rotTag, "z", 0.0), VsConstraintUtil.getDoubleWithDefault(rotTag, "w", 1.0));
        }
        Quaterniond localRot1 = new Quaterniond();
        if (tag.m_128425_("rot1", 10)) {
            CompoundTag rotTag = tag.m_128469_("rot1");
            localRot1.set(VsConstraintUtil.getDoubleWithDefault(rotTag, "x", 0.0), VsConstraintUtil.getDoubleWithDefault(rotTag, "y", 0.0), VsConstraintUtil.getDoubleWithDefault(rotTag, "z", 0.0), VsConstraintUtil.getDoubleWithDefault(rotTag, "w", 1.0));
        }
        boolean isFixed = tag.m_128441_("isFixed") && tag.m_128471_("isFixed");
        return new HingeConstraintRecord(shipId0, shipId1, (Quaterniondc)localRot0, (Quaterniondc)localRot1, isFixed);
    }

    private static double getDoubleWithDefault(CompoundTag tag, String key, double defaultValue) {
        return tag.m_128425_(key, 6) ? tag.m_128459_(key) : defaultValue;
    }

    public record AttachmentConstraintRecord(long shipId0, long shipId1, Vector3dc localPos0, Vector3dc localPos1, double fixedDistance) {
    }

    public record SlideConstraintRecord(long shipId0, long shipId1, Vector3dc localPos0, Vector3dc localPos1, Vector3dc axis, double maxDist) {
    }

    public record HingeConstraintRecord(long shipId0, long shipId1, Quaterniondc localRot0, Quaterniondc localRot1, boolean isFixed) {
    }
}

