/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.vs;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.function.vs.CombinedRigidBodyCalculator;
import net.shao.valkyrien_space_war.function.vs.RigidBody;
import net.shao.valkyrien_space_war.mixin.ShipObjectWorldAccessor;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix4dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipInertiaData;
import org.valkyrienskies.core.apigame.constraints.VSAttachmentConstraint;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.constraints.VSForceConstraint;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.apigame.world.ShipWorldCore;
import org.valkyrienskies.core.impl.game.ships.PhysInertia;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.mod.common.VSClientGameUtils;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.physics_api.PoseVel;

public class VsUtil {
    private static final double HALF_PI = 1.5707963267948966;
    private static final double PI = Math.PI;

    public static LoadedShip getShip(Level level, BlockPos pos) {
        return VSGameUtilsKt.getShipObjectManagingPos((Level)level, (Vec3i)pos);
    }

    public static LoadedServerShip getShip(ServerLevel level, BlockPos pos) {
        return VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)level, (Vec3i)pos);
    }

    public static Ship getShip(Level level, Vec3 pos) {
        return VSGameUtilsKt.getShipObjectManagingPos((Level)level, (double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_);
    }

    public static ClientShip getClientShip(double x, double y, double z) {
        return VSClientGameUtils.getClientShip((double)x, (double)y, (double)z);
    }

    public static Vector3d getWorldToShip(ClientShip ship, Vec3 vec3) {
        return ship.getRenderTransform().getWorldToShip().transformPosition(new Vector3d(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_()));
    }

    public static ServerShipWorldCore getShipObjectWorldCore(ServerLevel level) {
        return VSGameUtilsKt.getShipObjectWorld((ServerLevel)level);
    }

    public static ShipWorldCore getShipObjectWorldCore(Level level) {
        return VSGameUtilsKt.getShipObjectWorld((Level)level);
    }

    public static Set<Integer> getShipConstraintsID(Level level, long shipId) {
        ShipObjectWorldAccessor accessor;
        Set<Integer> rawSet;
        ShipWorldCore shipObjectWorldCore = VsUtil.getShipObjectWorldCore(level);
        if (shipObjectWorldCore instanceof ShipObjectWorldAccessor && (rawSet = (accessor = (ShipObjectWorldAccessor)shipObjectWorldCore).getShipIdToConstraints().get(shipId)) != null) {
            try {
                return Set.copyOf(rawSet);
            }
            catch (Exception e) {
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    public static VSConstraint getConstraintsByID(Level level, int id) {
        return ((ShipObjectWorldAccessor)VsUtil.getShipObjectWorldCore(level)).getConstraints().get(id);
    }

    public static HashMap<Long, HashSet<VSConstraint>> getAllRelatedShips(Level level, long shipId) {
        return VsUtil.getAllRelatedShips(level, shipId, false);
    }

    public static HashSet<Ship> getCloserShips(Level level, long shipId) {
        Ship targetShip = VsUtil.getShipById(level, shipId);
        if (targetShip == null) {
            return new HashSet<Ship>();
        }
        AABBd worldAABB = new AABBd(targetShip.getWorldAABB());
        List<Ship> list = VsUtil.getShipObjectWorldCore(level).getAllShips().stream().filter(ship -> {
            AABBd aabBd = new AABBd(ship.getWorldAABB());
            boolean contains = worldAABB.intersectsAABB(aabBd);
            if (contains) {
                worldAABB.union((AABBdc)aabBd);
            }
            return contains;
        }).toList();
        return new HashSet<Ship>(list);
    }

    public static HashMap<Long, HashSet<VSConstraint>> getAllRelatedShips(Level level, long shipId, boolean includeSelf) {
        HashSet<Long> visited = new HashSet<Long>();
        LinkedList<Long> queue = new LinkedList<Long>();
        HashMap<Long, HashSet<VSConstraint>> result = new HashMap<Long, HashSet<VSConstraint>>();
        queue.add(shipId);
        visited.add(shipId);
        result.put(shipId, new HashSet());
        while (!queue.isEmpty()) {
            long currentShipId = (Long)queue.poll();
            HashSet<VSConstraint> currentConstraints = result.get(currentShipId);
            Set<Integer> constraintIds = VsUtil.getShipConstraintsID(level, currentShipId);
            for (int constraintId : constraintIds) {
                VSConstraint constraint = VsUtil.getConstraintsByID(level, constraintId);
                if (constraint == null || currentConstraints.contains(constraint)) continue;
                currentConstraints.add(constraint);
                long ship0 = constraint.getShipId0();
                long ship1 = constraint.getShipId1();
                VsUtil.processShip(level, queue, visited, result, currentShipId, ship0, constraint);
                VsUtil.processShip(level, queue, visited, result, currentShipId, ship1, constraint);
            }
        }
        if (!includeSelf) {
            result.remove(shipId);
        }
        return result;
    }

    private static void processShip(Level level, Queue<Long> queue, Set<Long> visited, HashMap<Long, HashSet<VSConstraint>> result, long currentShipId, long targetShipId, VSConstraint constraint) {
        if (targetShipId == currentShipId) {
            return;
        }
        HashSet targetConstraints = result.computeIfAbsent(targetShipId, k -> new HashSet());
        targetConstraints.add(constraint);
        if (!visited.contains(targetShipId)) {
            visited.add(targetShipId);
            queue.add(targetShipId);
            result.putIfAbsent(targetShipId, new HashSet());
        }
    }

    public static QueryableShipData<LoadedServerShip> getLoadedShips(ServerLevel level) {
        return VsUtil.getShipObjectWorldCore(level).getLoadedShips();
    }

    public static LoadedServerShip getLoadedShipById(ServerLevel level, long shipId) {
        return (LoadedServerShip)VsUtil.getLoadedShips(level).getById(shipId);
    }

    public static Ship getShipById(Level level, long shipId) {
        return VsUtil.getShipObjectWorldCore(level).getLoadedShips().getById(shipId);
    }

    public static Integer createNewConstraint(ServerLevel level, VSConstraint constraint) {
        return VsUtil.getShipObjectWorldCore(level).createNewConstraint(constraint);
    }

    public static boolean updateConstraint(ServerLevel level, int id, VSConstraint constraint) {
        return VsUtil.getShipObjectWorldCore(level).updateConstraint(id, constraint);
    }

    public static boolean removeConstraint(ServerLevel level, int id) {
        return VsUtil.removeConstraint(VsUtil.getShipObjectWorldCore(level), id);
    }

    public static boolean removeConstraint(ServerShipWorldCore shipObjectWorldCore, int id) {
        return shipObjectWorldCore.removeConstraint(id);
    }

    public static int deleteMasslessShips(ServerLevel level) {
        AtomicInteger count = new AtomicInteger();
        ServerShipWorldCore shipObjectWorldCore = VsUtil.getShipObjectWorldCore(level);
        shipObjectWorldCore.getAllShips().stream().filter(ship -> ship.getInertiaData().getMass() == 0.0).forEach(s -> {
            shipObjectWorldCore.deleteShip(s);
            count.getAndIncrement();
        });
        return count.get();
    }

    public static BlockPos getShipToWorldBlockPos(Ship ship, BlockPos blockPos) {
        Vector3d vector3d = ship.getShipToWorld().transformPosition(new Vector3d((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()));
        return new BlockPos((int)vector3d.x, (int)vector3d.y, (int)vector3d.z);
    }

    public static Vector3f getShipToWorldPos(Ship ship, Vector3f pos) {
        Vector3d vector3d = ship.getShipToWorld().transformPosition(new Vector3d((double)pos.x(), (double)pos.y(), (double)pos.z()));
        return new Vector3f((float)vector3d.x, (float)vector3d.y, (float)vector3d.z);
    }

    public static Matrix4dc getWorldToShipTransform(Ship ship) {
        return ship.getWorldToShip();
    }

    public static Quaterniond getRotationHingeFromState(BlockState state) {
        Direction value = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        return VsUtil.getRotationHingeFromState(value);
    }

    public static Quaterniond getRotationHingeFromState(Direction value) {
        return switch (value) {
            case Direction.DOWN -> new Quaterniond().rotateX(Math.PI);
            case Direction.NORTH -> new Quaterniond().rotateY(Math.PI).mul((Quaterniondc)new Quaterniond().rotateX(1.5707963267948966)).normalize();
            case Direction.SOUTH -> new Quaterniond().rotateX(1.5707963267948966).normalize();
            case Direction.EAST -> new Quaterniond().rotateY(1.5707963267948966).mul((Quaterniondc)new Quaterniond().rotateX(1.5707963267948966)).normalize();
            case Direction.WEST -> new Quaterniond().rotateY(-1.5707963267948966).mul((Quaterniondc)new Quaterniond().rotateX(1.5707963267948966)).normalize();
            default -> new Quaterniond();
        };
    }

    public static int getShipMaxSize(Ship ship) {
        AABBic shipAABB = ship.getShipAABB();
        if (shipAABB != null) {
            int sizeX = shipAABB.maxX() - shipAABB.minX();
            int sizeY = shipAABB.maxY() - shipAABB.minY();
            int sizeZ = shipAABB.maxZ() - shipAABB.minZ();
            return Math.max(Math.max(sizeX, sizeY), sizeZ);
        }
        return 0;
    }

    public static boolean isBlockInShipYard(Level level, BlockPos pos) {
        return VSGameUtilsKt.isBlockInShipyard((Level)level, (BlockPos)pos);
    }

    public static double getRotationAngleDegrees(BlockState state, Quaterniond quat) {
        return Math.toDegrees(VsUtil.getRotationAngle(state, quat));
    }

    public static double getRotationAngle(BlockState state, Quaterniond quat) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        switch (dir) {
            case EAST: {
                return VsUtil.calculateAxisAngle(quat, Axis.X, false);
            }
            case UP: {
                return VsUtil.calculateAxisAngle(quat, Axis.Y, false);
            }
            case SOUTH: {
                return VsUtil.calculateAxisAngle(quat, Axis.Z, false);
            }
            case WEST: {
                return VsUtil.calculateAxisAngle(quat, Axis.X, true);
            }
            case DOWN: {
                return VsUtil.calculateAxisAngle(quat, Axis.Y, true);
            }
            case NORTH: {
                return VsUtil.calculateAxisAngle(quat, Axis.Z, true);
            }
        }
        throw new IllegalArgumentException("Unexpected direction: " + dir);
    }

    private static double calculateAxisAngle(Quaterniond quat, Axis axis, boolean reverse) {
        double angle = VsUtil.calculateRawAngle(quat, axis);
        angle = VsUtil.normalizeAngle(angle);
        return reverse ? -angle : angle;
    }

    private static double calculateRawAngle(Quaterniond quat, Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> 2.0 * Math.atan2(quat.x, quat.w);
            case Axis.Y -> 2.0 * Math.atan2(quat.y, quat.w);
            case Axis.Z -> 2.0 * Math.atan2(quat.z, quat.w);
        };
    }

    private static double normalizeAngle(double angle) {
        return (angle %= Math.PI * 2) > Math.PI ? angle - Math.PI * 2 : (angle < -Math.PI ? angle + Math.PI * 2 : angle);
    }

    public static Quaterniond getReverseRotationFromState(BlockState state) {
        Direction value = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        return switch (value) {
            case Direction.DOWN -> new Quaterniond().rotateX(Math.PI);
            case Direction.NORTH -> new Quaterniond().rotateX(1.5707963267948966);
            case Direction.SOUTH -> new Quaterniond().rotateX(-1.5707963267948966);
            case Direction.EAST -> new Quaterniond().rotateZ(1.5707963267948966);
            case Direction.WEST -> new Quaterniond().rotateZ(-1.5707963267948966);
            default -> new Quaterniond();
        };
    }

    public static PhysImplSnapshot createPhysImplSnapshotWithConstraints(ServerLevel level, PhysShip physShip) {
        HashMap<Long, HashSet<VSConstraint>> allRelatedShips = VsUtil.getAllRelatedShips((Level)level, physShip.getId());
        if (allRelatedShips.isEmpty()) {
            return VsUtil.createPhysImplSnapshot(physShip);
        }
        HashMap constraintGraph = new HashMap();
        HashSet processedPairs = new HashSet();
        allRelatedShips.forEach((shipId, constraints) -> {
            constraintGraph.putIfAbsent((Long)shipId, new HashMap());
            for (VSConstraint constraint : constraints) {
                long maxId;
                long id1;
                VSForceConstraint attach;
                long id0;
                long minId;
                long pairKey;
                if (!(constraint instanceof VSForceConstraint) || processedPairs.contains(pairKey = (minId = Math.min(id0 = (attach = (VSForceConstraint)constraint).getShipId0(), id1 = attach.getShipId1())) ^ (maxId = Math.max(id0, id1)) << 32)) continue;
                processedPairs.add(pairKey);
                constraintGraph.computeIfAbsent(id0, k -> new HashMap()).put(id1, constraint);
                constraintGraph.computeIfAbsent(id1, k -> new HashMap()).put(id0, constraint);
            }
        });
        constraintGraph.putIfAbsent(physShip.getId(), new HashMap());
        HashMap pathToPhysShip = new HashMap();
        HashMap<Long, Long> parentShip = new HashMap<Long, Long>();
        LinkedList<Long> queue = new LinkedList<Long>();
        HashSet<Long> visited = new HashSet<Long>();
        queue.add(physShip.getId());
        visited.add(physShip.getId());
        parentShip.put(physShip.getId(), null);
        while (!queue.isEmpty()) {
            long current = (Long)queue.poll();
            Map neighbors = constraintGraph.getOrDefault(current, Collections.emptyMap());
            Iterator iterator = neighbors.keySet().iterator();
            while (iterator.hasNext()) {
                long neighbor = (Long)iterator.next();
                if (visited.contains(neighbor)) continue;
                visited.add(neighbor);
                queue.add(neighbor);
                parentShip.put(neighbor, current);
                ArrayList<Long> path = new ArrayList<Long>();
                long node = neighbor;
                while (node != physShip.getId()) {
                    path.add(node);
                    node = (Long)parentShip.get(node);
                }
                Collections.reverse(path);
                pathToPhysShip.put(neighbor, path);
            }
        }
        HashMap<Long, Vector3d> finalOffsets = new HashMap<Long, Vector3d>();
        for (long shipId2 : allRelatedShips.keySet()) {
            List path;
            if (!pathToPhysShip.containsKey(shipId2) || (path = (List)pathToPhysShip.get(shipId2)).isEmpty()) continue;
            Quaterniond currentRotation = new Quaterniond();
            Vector3d accumulatedOffset = new Vector3d();
            long currentShipId = physShip.getId();
            Iterator iterator = path.iterator();
            while (iterator.hasNext()) {
                Vector3d localPosNext;
                Vector3d localPosCurrent;
                LoadedServerShip nextShip;
                LoadedServerShip currentShip;
                long nextShipId = (Long)iterator.next();
                VSConstraint constraint = (VSConstraint)((Map)constraintGraph.get(currentShipId)).get(nextShipId);
                if (!(constraint instanceof VSAttachmentConstraint)) break;
                VSAttachmentConstraint attach = (VSAttachmentConstraint)constraint;
                if (attach.getShipId0() == currentShipId) {
                    currentShip = VsUtil.getLoadedShipById(level, attach.getShipId0());
                    nextShip = VsUtil.getLoadedShipById(level, attach.getShipId1());
                    if (currentShip == null || nextShip == null) {
                        return VsUtil.createPhysImplSnapshot(physShip);
                    }
                    localPosCurrent = attach.getLocalPos0().sub(currentShip.getTransform().getPositionInShip(), new Vector3d());
                    localPosNext = attach.getLocalPos1().sub(nextShip.getTransform().getPositionInShip(), new Vector3d());
                } else {
                    currentShip = VsUtil.getLoadedShipById(level, attach.getShipId1());
                    nextShip = VsUtil.getLoadedShipById(level, attach.getShipId0());
                    if (currentShip == null || nextShip == null) {
                        return VsUtil.createPhysImplSnapshot(physShip);
                    }
                    localPosCurrent = attach.getLocalPos1().sub(currentShip.getTransform().getPositionInShip(), new Vector3d());
                    localPosNext = attach.getLocalPos0().sub(nextShip.getTransform().getPositionInShip(), new Vector3d());
                }
                Quaterniond nextRotation = currentShip.getTransform().getShipToWorldRotation().conjugate(new Quaterniond()).mul(nextShip.getTransform().getShipToWorldRotation());
                Vector3d constraintWorldFromCurrent = new Vector3d((Vector3dc)localPosCurrent).rotate((Quaterniondc)currentRotation);
                Vector3d constraintWorldFromNext = new Vector3d((Vector3dc)localPosNext).rotate((Quaterniondc)nextRotation);
                Vector3d offsetToNext = constraintWorldFromCurrent.sub((Vector3dc)constraintWorldFromNext);
                accumulatedOffset.add((Vector3dc)offsetToNext);
                currentShipId = nextShipId;
                currentRotation = nextRotation;
            }
            finalOffsets.put(shipId2, accumulatedOffset);
        }
        HashSet<RigidBody> bodies = new HashSet<RigidBody>();
        finalOffsets.forEach((ship, offset) -> {
            LoadedServerShip loadedShipById = VsUtil.getLoadedShipById(level, ship);
            if (loadedShipById != null) {
                ShipInertiaData inertiaData = loadedShipById.getInertiaData();
                bodies.add(new RigidBody(inertiaData.getMass(), new Vector3d((Vector3dc)offset), inertiaData.getMomentOfInertiaTensor().m00()));
            }
        });
        PhysShipImpl physImpl = (PhysShipImpl)physShip;
        bodies.add(new RigidBody(physImpl.getInertia().getShipMass(), new Vector3d(), physImpl.getInertia().getMomentOfInertiaTensor().m00()));
        RigidBody rigidBody = CombinedRigidBodyCalculator.combineRigidBodies(bodies);
        PoseVel poseVel = physImpl.getPoseVel();
        Vector3d pos = new Vector3d(poseVel.getPos());
        Vector3d centerOfMass = rigidBody.centerOfMass;
        Quaterniond rot = new Quaterniond(poseVel.getRot());
        Vector3d omega = new Vector3d(poseVel.getOmega());
        Vector3d velocity = new Vector3d(poseVel.getVel());
        Matrix3d momentOfInertiaTensor = new Matrix3d(rigidBody.inertiaScalar, 0.0, 0.0, 0.0, rigidBody.inertiaScalar, 0.0, 0.0, 0.0, rigidBody.inertiaScalar);
        double shipMass = rigidBody.mass;
        return new PhysImplSnapshot(pos, centerOfMass, finalOffsets, (Quaterniondc)rot, (Vector3dc)omega, (Vector3dc)velocity, (Matrix3dc)momentOfInertiaTensor, shipMass);
    }

    public static PhysImplSnapshot createPhysImplSnapshot(PhysShip physShip) {
        PhysShipImpl physImpl = (PhysShipImpl)physShip;
        PoseVel poseVel = physImpl.getPoseVel();
        Vector3d pos = new Vector3d(poseVel.getPos());
        Quaterniond rot = new Quaterniond(poseVel.getRot());
        Vector3d omega = new Vector3d(poseVel.getOmega());
        Vector3d velocity = new Vector3d(poseVel.getVel());
        PhysInertia inertia = physImpl.getInertia();
        Matrix3d momentOfInertiaTensor = new Matrix3d(inertia.getMomentOfInertiaTensor());
        double shipMass = inertia.getShipMass();
        return new PhysImplSnapshot(pos, new Vector3d(), new HashMap<Long, Vector3d>(), (Quaterniondc)rot, (Vector3dc)omega, (Vector3dc)velocity, (Matrix3dc)momentOfInertiaTensor, shipMass);
    }

    public static Vector3i toJOMLPos(BlockPos pos) {
        BlockPos offset = pos.m_7918_(0, 1, 0);
        return new Vector3i(offset.m_123341_(), offset.m_123342_(), offset.m_123343_());
    }

    public static String getDimensionId(ServerLevel level) {
        return VSGameUtilsKt.getDimensionId((Level)level);
    }

    private static enum Axis {
        X,
        Y,
        Z;

    }

    public record PhysImplSnapshot(Vector3d pos, Vector3d centerOfMass, Map<Long, Vector3d> finalOffsets, Quaterniondc rot, Vector3dc omega, Vector3dc velocity, Matrix3dc momentOfInertiaTensor, double shipMass) {
    }

    private static class ConcurrentHashSet<T>
    extends AbstractSet<T> {
        private final transient CopyOnWriteArrayList<T> list = new CopyOnWriteArrayList();

        public ConcurrentHashSet(Collection<? extends T> c) {
            this.list.addAllAbsent(c);
        }

        @Override
        public Iterator<T> iterator() {
            return this.list.iterator();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean add(T e) {
            return this.list.addIfAbsent(e);
        }
    }
}

