/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.vs.inducer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.concurrent.ConcurrentHashMap;
import net.shao.valkyrien_space_war.block.flight_control.base.AbstractFlightControlBE;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import net.shao.valkyrien_space_war.function.vs.inducer.IBEShipForceInducer;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;

public class BlockEntityShipForcesInducer
implements ShipForcesInducer {
    @JsonIgnore
    private final ConcurrentHashMap<IBEShipForceInducer, Integer> blockEntities = new ConcurrentHashMap();

    public static BlockEntityShipForcesInducer getOrCreate(ServerShip ship) {
        BlockEntityShipForcesInducer obj = (BlockEntityShipForcesInducer)ship.getAttachment(BlockEntityShipForcesInducer.class);
        if (obj == null) {
            obj = new BlockEntityShipForcesInducer();
            ship.saveAttachment(BlockEntityShipForcesInducer.class, (Object)obj);
        }
        return obj;
    }

    public void update(IBEShipForceInducer blockEntity) {
        this.blockEntities.put(blockEntity, 20);
    }

    public void refresh() {
        this.blockEntities.entrySet().forEach(e -> e.setValue((Integer)e.getValue() - 1));
        this.blockEntities.entrySet().removeIf(e -> (Integer)e.getValue() < 0);
    }

    public void applyForces(@NotNull PhysShip physShip) {
        this.refresh();
        this.blockEntities.forEach((be, cd) -> {
            VsUtil.PhysImplSnapshot snapshot = be instanceof AbstractFlightControlBE ? VsUtil.createPhysImplSnapshotWithConstraints(be.getServerLevel(), physShip) : VsUtil.createPhysImplSnapshot(physShip);
            be.updatePhysics(physShip, snapshot);
        });
    }
}

