/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.function.vs.inducer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.jvm.functions.Function1;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;

public class GlobalShipForcesInducer
implements ShipForcesInducer {
    @JsonIgnore
    private final ConcurrentHashMap<ServerShip, Integer> otherShips = new ConcurrentHashMap();
    @JsonIgnore
    public final ConcurrentHashMap<ServerShip, Queue<ApplyForcesCallback>> callbacks = new ConcurrentHashMap();

    public static GlobalShipForcesInducer getOrCreate(ServerShip ship) {
        GlobalShipForcesInducer obj = (GlobalShipForcesInducer)ship.getAttachment(GlobalShipForcesInducer.class);
        if (obj == null) {
            obj = new GlobalShipForcesInducer();
            ship.saveAttachment(GlobalShipForcesInducer.class, (Object)obj);
        }
        return obj;
    }

    public void update(ServerShip otherShip) {
        this.otherShips.put(otherShip, 20);
    }

    public void refresh() {
        this.otherShips.entrySet().forEach(e -> e.setValue((Integer)e.getValue() - 1));
        this.otherShips.entrySet().removeIf(e -> (Integer)e.getValue() < 0);
    }

    public void addCallback(ServerShip ship, ApplyForcesCallback callback) {
        Queue applyForcesCallbacks = this.callbacks.computeIfAbsent(ship, k -> new ConcurrentLinkedQueue());
        applyForcesCallbacks.add(callback);
    }

    public void applyForcesAndLookupPhysShips(@NotNull PhysShip physShip, @NotNull Function1<? super Long, ? extends PhysShip> lookupPhysShip) {
    }

    public void applyForces(@NotNull PhysShip physShip) {
        this.refresh();
        this.otherShips.forEach((ship, cd) -> {
            VsUtil.PhysImplSnapshot snapshot = VsUtil.createPhysImplSnapshot(physShip);
            Queue<ApplyForcesCallback> applyForcesCallbacks = this.callbacks.get(ship);
            if (applyForcesCallbacks != null) {
                while (!applyForcesCallbacks.isEmpty()) {
                    applyForcesCallbacks.poll().applyForces(physShip, snapshot);
                }
            }
        });
    }

    public static interface ApplyForcesCallback {
        public void applyForces(PhysShip var1, VsUtil.PhysImplSnapshot var2);
    }
}

