/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.input;

import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.shao.valkyrien_space_war.function.util.ModClientUtil;
import net.shao.valkyrien_space_war.input.KeyConfigManager;
import net.shao.valkyrien_space_war.input.SeatInputThread;
import net.shao.valkyrien_space_war.input.VsswInputState;
import net.shao.valkyrien_space_war.input.VsswKeyConfigData;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallbackI;

public class InputInterceptor {
    public static boolean isInputBlocked = false;
    private static long windowHandle;
    private static GLFWKeyCallbackI originalKeyCallback;
    private static GLFWCursorPosCallbackI originalCursorCallback;
    private static GLFWMouseButtonCallbackI originalMouseButtonCallback;
    private static GLFWScrollCallbackI originalScrollCallback;
    public static VsswInputState inputState;
    public static VsswKeyConfigData configData;
    public static SeatInputThread inputThread;
    public static boolean isMouseUsing;
    public static boolean isMouseUsingInConfigData;
    private static final GLFWKeyCallbackI KeyInterceptor;
    private static final GLFWCursorPosCallbackI MouseInterceptor;
    private static final GLFWMouseButtonCallbackI MouseButtonInterceptor;
    private static final GLFWScrollCallbackI ScrollInterceptor;

    public static void start(VsswKeyConfigData configData, VsswInputState inputState) {
        InputInterceptor.stop();
        InputInterceptor.configData = configData;
        isMouseUsingInConfigData = false;
        Set<Map.Entry<Integer, VsswKeyConfigData.CustomBind>> entries = configData.binds.entrySet();
        for (Map.Entry<Integer, VsswKeyConfigData.CustomBind> entry : entries) {
            VsswKeyConfigData.CustomBind bind = entry.getValue();
            if (bind.type != VsswKeyConfigData.InputType.MOUSE_MOVEMENT_X && bind.type != VsswKeyConfigData.InputType.MOUSE_MOVEMENT_Y && bind.type != VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NX && bind.type != VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NY) continue;
            isMouseUsingInConfigData = true;
            break;
        }
        isMouseUsing = isMouseUsingInConfigData;
        InputInterceptor.inputState = inputState;
        Minecraft instance = Minecraft.m_91087_();
        windowHandle = instance.m_91268_().m_85439_();
        InputInterceptor.takeOver();
    }

    public static void reloadConfig() {
        if (inputThread != null && inputThread.isAlive()) {
            inputThread.loadLastConfig();
        }
        configData = KeyConfigManager.loadConfig(KeyConfigManager.getLastConfigFile());
    }

    public static void stop() {
        isInputBlocked = false;
        inputThread = null;
        InputInterceptor.releaseInput();
    }

    public static void takeOver() {
        int key;
        originalKeyCallback = GLFW.glfwSetKeyCallback((long)windowHandle, (GLFWKeyCallbackI)KeyInterceptor);
        for (key = 32; key <= 348; ++key) {
            if (GLFW.glfwGetKey((long)windowHandle, (int)key) != 1) continue;
            originalKeyCallback.invoke(windowHandle, key, 0, 0, 0);
        }
        originalCursorCallback = GLFW.glfwSetCursorPosCallback((long)windowHandle, (GLFWCursorPosCallbackI)MouseInterceptor);
        originalMouseButtonCallback = GLFW.glfwSetMouseButtonCallback((long)windowHandle, (GLFWMouseButtonCallbackI)MouseButtonInterceptor);
        originalScrollCallback = GLFW.glfwSetScrollCallback((long)windowHandle, (GLFWScrollCallbackI)ScrollInterceptor);
        for (key = 0; key <= 7; ++key) {
            if (GLFW.glfwGetMouseButton((long)windowHandle, (int)key) != 1) continue;
            originalMouseButtonCallback.invoke(windowHandle, key, 0, 0);
        }
    }

    public static void releaseInput() {
        if (originalMouseButtonCallback != null && MouseButtonInterceptor != originalMouseButtonCallback) {
            originalMouseButtonCallback.invoke(windowHandle, 0, 0, 0);
            originalMouseButtonCallback.invoke(windowHandle, 1, 0, 0);
        }
        if (originalCursorCallback != null) {
            GLFW.glfwSetCursorPosCallback((long)windowHandle, (GLFWCursorPosCallbackI)originalCursorCallback);
        }
        if (originalMouseButtonCallback != null) {
            GLFW.glfwSetMouseButtonCallback((long)windowHandle, (GLFWMouseButtonCallbackI)originalMouseButtonCallback);
        }
        if (originalScrollCallback != null) {
            GLFW.glfwSetScrollCallback((long)windowHandle, (GLFWScrollCallbackI)originalScrollCallback);
        }
        if (originalKeyCallback != null) {
            GLFW.glfwSetKeyCallback((long)windowHandle, (GLFWKeyCallbackI)originalKeyCallback);
        }
    }

    public static void toggleLock() {
        isInputBlocked = !isInputBlocked;
    }

    static {
        isMouseUsing = false;
        isMouseUsingInConfigData = false;
        KeyInterceptor = (window, key, scancode, action, mods) -> {
            if (!isInputBlocked || key == 294) {
                originalKeyCallback.invoke(window, key, scancode, action, mods);
            }
            if (isInputBlocked && key == 342) {
                if (action == 1) {
                    isMouseUsing = false;
                }
                if (action == 0) {
                    isMouseUsing = isMouseUsingInConfigData;
                    ModClientUtil.resetMouseState();
                    inputThread.resetPlayerLookAt();
                }
            }
        };
        MouseInterceptor = (window, xpos, ypos) -> {
            if (!isInputBlocked || !isMouseUsing) {
                originalCursorCallback.invoke(window, xpos, ypos);
            }
        };
        MouseButtonInterceptor = (window, button, action, mods) -> {
            if (!isInputBlocked) {
                originalMouseButtonCallback.invoke(window, button, action, mods);
            }
        };
        ScrollInterceptor = (window, xoffset, yoffset) -> {
            if (isInputBlocked) {
                if (yoffset != 0.0) {
                    int y = (int)yoffset;
                    InputInterceptor.configData.binds.forEach((index, bind) -> {
                        if (bind.type == VsswKeyConfigData.InputType.MOUSE_SCROLL && bind.code == y) {
                            inputState.pullScroll((int)index);
                        }
                    });
                }
            } else {
                originalScrollCallback.invoke(window, xoffset, yoffset);
            }
        };
    }
}

