/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.input;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.shao.valkyrien_space_war.ValkyrienSpaceWar;
import net.shao.valkyrien_space_war.input.InputInterceptor;
import net.shao.valkyrien_space_war.input.VsswKeyConfigData;

public class KeyConfigManager {
    public static final String LAST_CONFIG_FILE = "last_config";
    public static final Path CONTROLS_DIR = ValkyrienSpaceWar.ROOT_DIR.resolve("controls");
    public static final String CONFIG_FILE = "default.json";
    private static final ExecutorService threadPool = Executors.newCachedThreadPool();

    public static VsswKeyConfigData loadConfig(String configFile) {
        try {
            if (!Files.exists(CONTROLS_DIR, new LinkOption[0])) {
                Files.createDirectories(CONTROLS_DIR, new FileAttribute[0]);
            }
            if (Files.exists(CONTROLS_DIR.resolve(configFile), new LinkOption[0])) {
                KeyConfigManager.setLastConfigFile(configFile);
                return (VsswKeyConfigData)new Gson().fromJson((Reader)Files.newBufferedReader(CONTROLS_DIR.resolve(configFile)), VsswKeyConfigData.class);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        VsswKeyConfigData defConfig = KeyConfigManager.createDefaultConfig();
        KeyConfigManager.saveConfig(defConfig, CONFIG_FILE);
        KeyConfigManager.setLastConfigFile(CONFIG_FILE);
        InputInterceptor.reloadConfig();
        return defConfig;
    }

    public static VsswKeyConfigData createDefaultConfig() {
        VsswKeyConfigData config = new VsswKeyConfigData();
        config.binds.put(0, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 87));
        config.binds.put(1, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 83));
        config.binds.put(2, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 81));
        config.binds.put(3, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 69));
        config.binds.put(4, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 32));
        config.binds.put(5, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 341));
        config.binds.put(6, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 65));
        config.binds.put(7, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 68));
        config.binds.put(8, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NX, 1.0f, false));
        config.binds.put(9, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.MOUSE_MOVEMENT_X, 1.0f, false));
        config.binds.put(10, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.MOUSE_MOVEMENT_NY, 1.0f, false));
        config.binds.put(11, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.MOUSE_MOVEMENT_Y, 1.0f, false));
        config.binds.put(12, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.MOUSE_CLICK, 0));
        config.binds.put(13, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.MOUSE_CLICK, 1));
        config.binds.put(14, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 340));
        config.binds.put(15, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 90));
        config.binds.put(16, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 257));
        config.binds.put(17, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 259));
        config.binds.put(18, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 89));
        config.binds.put(19, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 82));
        config.binds.put(20, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 334));
        config.binds.put(21, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 333));
        config.binds.put(22, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 265));
        config.binds.put(23, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 264));
        config.binds.put(24, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 67));
        config.binds.put(25, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 61));
        config.binds.put(26, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 45));
        config.binds.put(27, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 74));
        config.binds.put(28, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 75));
        config.binds.put(29, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 88));
        config.binds.put(30, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 48));
        config.binds.put(31, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 49));
        config.binds.put(32, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 50));
        config.binds.put(33, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 51));
        config.binds.put(34, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 52));
        config.binds.put(35, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 53));
        config.binds.put(36, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 54));
        config.binds.put(37, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 55));
        config.binds.put(38, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 56));
        config.binds.put(39, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 57));
        config.binds.put(40, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 320));
        config.binds.put(41, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 321));
        config.binds.put(42, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 322));
        config.binds.put(43, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 323));
        config.binds.put(44, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 324));
        config.binds.put(45, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 325));
        config.binds.put(46, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 326));
        config.binds.put(47, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 327));
        config.binds.put(48, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 328));
        config.binds.put(49, new VsswKeyConfigData.CustomBind(VsswKeyConfigData.InputType.KEYBOARD, 329));
        return config;
    }

    public static void saveConfig(VsswKeyConfigData config, String configFile) {
        threadPool.submit(() -> {
            try (BufferedWriter writer = Files.newBufferedWriter(CONTROLS_DIR.resolve(configFile), new OpenOption[0]);){
                new GsonBuilder().setPrettyPrinting().registerTypeAdapter(VsswKeyConfigData.InputType.class, (Object)new InputTypeAdapter()).create().toJson((Object)config, (Appendable)writer);
                KeyConfigManager.setLastConfigFile(configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            InputInterceptor.reloadConfig();
        });
    }

    public static String getLastConfigFile() {
        Path configFile = ValkyrienSpaceWar.ROOT_DIR.resolve(LAST_CONFIG_FILE);
        try {
            if (!Files.exists(ValkyrienSpaceWar.ROOT_DIR, new LinkOption[0])) {
                Files.createDirectories(ValkyrienSpaceWar.ROOT_DIR, new FileAttribute[0]);
            }
            if (Files.exists(configFile, new LinkOption[0]) && Files.size(configFile) != 0L) {
                String content = Files.readString(configFile);
                if (KeyConfigManager.isValidConfigContent(content)) {
                    return content;
                }
                KeyConfigManager.setLastConfigFile(CONFIG_FILE);
                return CONFIG_FILE;
            }
            KeyConfigManager.setLastConfigFile(CONFIG_FILE);
            return CONFIG_FILE;
        }
        catch (IOException e) {
            e.printStackTrace();
            KeyConfigManager.setLastConfigFile(CONFIG_FILE);
            return CONFIG_FILE;
        }
    }

    public static void setLastConfigFile(String configFileName) {
        try {
            Files.deleteIfExists(ValkyrienSpaceWar.ROOT_DIR.resolve(LAST_CONFIG_FILE));
            Files.writeString(ValkyrienSpaceWar.ROOT_DIR.resolve(LAST_CONFIG_FILE), (CharSequence)configFileName, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean isValidConfigContent(String content) {
        for (char c : content.toCharArray()) {
            if (!Character.isISOControl(c)) continue;
            return false;
        }
        return true;
    }

    private static class InputTypeAdapter
    extends TypeAdapter<VsswKeyConfigData.InputType> {
        private InputTypeAdapter() {
        }

        public void write(JsonWriter out, VsswKeyConfigData.InputType value) throws IOException {
            out.value(value.name());
        }

        public VsswKeyConfigData.InputType read(JsonReader in) throws IOException {
            return VsswKeyConfigData.InputType.valueOf(in.nextString());
        }
    }
}

