/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.input;

import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.shao.valkyrien_space_war.block.seat.base.BaseShipControlSeatBE;
import net.shao.valkyrien_space_war.block.seat.base.ShipControlSeatEntity;
import net.shao.valkyrien_space_war.function.camera.CameraZoomHandler;
import net.shao.valkyrien_space_war.function.camera.VsCameraDistHelper;
import net.shao.valkyrien_space_war.function.util.ModClientUtil;
import net.shao.valkyrien_space_war.input.InputInterceptor;
import net.shao.valkyrien_space_war.input.KeyConfigManager;
import net.shao.valkyrien_space_war.input.VsswInputState;
import net.shao.valkyrien_space_war.input.VsswKeyConfigData;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.control.PacketControlData;
import net.shao.valkyrien_space_war.network.control.SyncIsControllingPacket;

public class SeatInputThread
extends Thread {
    private ShipControlSeatEntity seat;
    private BaseShipControlSeatBE be;
    private VsswKeyConfigData configData;
    private VsswInputState inputState;
    private static final Component START_CONTROL_MSG = Component.m_237115_((String)"gui.valkyrien_space_war.msg_start_control").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)65280)).m_131136_(Boolean.valueOf(true)));
    private static final Component RELEASE_CONTROL_MSG = Component.m_237115_((String)"gui.valkyrien_space_war.msg_release_control").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)).m_131136_(Boolean.valueOf(true)));

    public SeatInputThread(ShipControlSeatEntity seat, BaseShipControlSeatBE be) {
        this.seat = seat;
        this.be = be;
        if (be == null) {
            return;
        }
        if (be.isResetCameraRot()) {
            this.resetPlayerLookAt();
        }
        this.inputState = new VsswInputState();
    }

    public void sendInitPacket(VsswInputState inputState) {
        if (inputState == null) {
            return;
        }
        PacketControlData initPacket = inputState.getInitPacket();
        if (initPacket != null) {
            ModNetworkHandler.sendToServer(initPacket);
        }
    }

    public void loadLastConfig() {
        this.configData = KeyConfigManager.loadConfig(KeyConfigManager.getLastConfigFile());
    }

    @Override
    public void run() {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91302_()) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        this.loadLastConfig();
        InputInterceptor.start(this.configData, this.inputState);
        this.sendInitPacket(this.inputState);
        float[] lastFloats = new float[13];
        boolean[] lastBools = new boolean[VsswInputState.KEY_LENGTH];
        boolean isStartControlPressed = false;
        boolean controlling = this.be.isControlling();
        while (ModClientUtil.isGameFocused() && player != null && this.seat != null && this.seat.m_6084_() && player.m_20202_() == this.seat && !(mc.f_91080_ instanceof ChatScreen)) {
            if (InputInterceptor.inputThread == null) {
                InputInterceptor.inputThread = this;
            }
            ModClientUtil.getInputState(this.configData, this.inputState);
            float[] floats = this.inputState.getFloats();
            boolean[] bools = this.inputState.getBools();
            if (!isStartControlPressed && bools[24]) {
                ModClientUtil.resetMouseState();
                this.resetClientInputs();
                if (this.be.isResetCameraRot()) {
                    this.resetPlayerLookAt();
                }
                isStartControlPressed = true;
                InputInterceptor.toggleLock();
                Component msg = InputInterceptor.isInputBlocked ? START_CONTROL_MSG : RELEASE_CONTROL_MSG;
                player.m_5661_(msg, true);
                CameraZoomHandler.resetZoom();
            }
            if (isStartControlPressed && !bools[24]) {
                isStartControlPressed = false;
            }
            CameraType cameraType = mc.f_91066_.m_92176_();
            if (bools[25]) {
                if (cameraType == CameraType.FIRST_PERSON) {
                    CameraZoomHandler.zoomIn();
                } else {
                    VsCameraDistHelper.zoomIn();
                }
            }
            if (bools[26]) {
                if (cameraType == CameraType.FIRST_PERSON) {
                    CameraZoomHandler.zoomOut();
                } else {
                    VsCameraDistHelper.zoomOut();
                }
            }
            if (InputInterceptor.isInputBlocked) {
                PacketControlData deltaPacket;
                if (this.be != null) {
                    this.be.setClientInput(floats, bools);
                    this.be.setControlling(true);
                    if (controlling != this.be.isControlling()) {
                        ModNetworkHandler.sendToServer(new SyncIsControllingPacket(this.be.m_58899_(), this.be.isControlling()));
                        controlling = this.be.isControlling();
                    }
                }
                if ((deltaPacket = this.inputState.getPacket(lastFloats, lastBools)) != null) {
                    ModNetworkHandler.sendToServer(deltaPacket);
                }
                lastFloats = floats;
                lastBools = bools;
            }
            this.sleep(8);
        }
        this.sendInitPacket(this.inputState);
        InputInterceptor.stop();
        this.be.resetClientInputs();
        this.be.setControlling(false);
        ModNetworkHandler.sendToServer(new SyncIsControllingPacket(this.be.m_58899_(), this.be.isControlling()));
        CameraZoomHandler.resetZoom();
    }

    public void resetPlayerLookAt() {
        ModClientUtil.resetPlayerLookAt(Mth.m_14177_((float)(this.be.faceAngle + this.be.getYaw())), this.be.getPitch());
    }

    public void resetClientInputs() {
        this.sendInitPacket(this.inputState);
        this.be.resetClientInputs();
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

