/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.input;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.shao.valkyrien_space_war.network.control.PacketControlData;

public class VsswInputState {
    public static final byte FORWARD = 0;
    public static final byte BACKWARD = 1;
    public static final byte LEFT = 2;
    public static final byte RIGHT = 3;
    public static final byte UP = 4;
    public static final byte DOWN = 5;
    public static final byte ROLL_LEFT = 6;
    public static final byte ROLL_RIGHT = 7;
    public static final byte YAW_LEFT = 8;
    public static final byte YAW_RIGHT = 9;
    public static final byte PITCH_UP = 10;
    public static final byte PITCH_DOWN = 11;
    public static final byte FIRE = 12;
    public static final byte MISSILE = 13;
    public static final byte BURNER_MODE = 14;
    public static final byte COUPLED = 15;
    public static final byte AUTO_LEVEL = 16;
    public static final byte BACK = 17;
    public static final byte DISTRIBUTED_LOCKING = 18;
    public static final byte SWITCH_RADAR = 19;
    public static final byte SWITCH_TARGET_NEXT = 20;
    public static final byte SWITCH_TARGET_PREV = 21;
    public static final byte THRUSTER_UP = 22;
    public static final byte THRUSTER_DOWN = 23;
    public static final byte START_CONTROL = 24;
    public static final byte ZOOM_IN = 25;
    public static final byte ZOOM_OUT = 26;
    public static final byte PREV_GUN_LEVEL = 27;
    public static final byte NEXT_GUN_LEVEL = 28;
    public static final byte ENGINE_ON = 29;
    public static final byte RED_STONE_OUTPUT_0 = 30;
    public static final String[] keyNames = new String[]{"key.valkyrien_space_war.move_forward", "key.valkyrien_space_war.move_backward", "key.valkyrien_space_war.move_left", "key.valkyrien_space_war.move_right", "key.valkyrien_space_war.move_up", "key.valkyrien_space_war.move_down", "key.valkyrien_space_war.roll_left", "key.valkyrien_space_war.roll_right", "key.valkyrien_space_war.yaw_left", "key.valkyrien_space_war.yaw_right", "key.valkyrien_space_war.pitch_up", "key.valkyrien_space_war.pitch_down", "key.valkyrien_space_war.fire", "key.valkyrien_space_war.missile", "key.valkyrien_space_war.burner_mode", "key.valkyrien_space_war.coupled", "key.valkyrien_space_war.auto_level", "key.valkyrien_space_war.back", "key.valkyrien_space_war.distributed_locking", "key.valkyrien_space_war.switch_radar", "key.valkyrien_space_war.switch_target_next", "key.valkyrien_space_war.switch_target_prev", "key.valkyrien_space_war.thruster_up", "key.valkyrien_space_war.thruster_down", "key.valkyrien_space_war.start_control", "key.valkyrien_space_war.zoom_in", "key.valkyrien_space_war.zoom_out", "key.valkyrien_space_war.prev_gun_level", "key.valkyrien_space_war.next_gun_level", "key.valkyrien_space_war.engine_on", "key.valkyrien_space_war.red_stone_output_0", "key.valkyrien_space_war.red_stone_output_1", "key.valkyrien_space_war.red_stone_output_2", "key.valkyrien_space_war.red_stone_output_3", "key.valkyrien_space_war.red_stone_output_4", "key.valkyrien_space_war.red_stone_output_5", "key.valkyrien_space_war.red_stone_output_6", "key.valkyrien_space_war.red_stone_output_7", "key.valkyrien_space_war.red_stone_output_8", "key.valkyrien_space_war.red_stone_output_9", "key.valkyrien_space_war.red_stone_output_10", "key.valkyrien_space_war.red_stone_output_11", "key.valkyrien_space_war.red_stone_output_12", "key.valkyrien_space_war.red_stone_output_13", "key.valkyrien_space_war.red_stone_output_14", "key.valkyrien_space_war.red_stone_output_15", "key.valkyrien_space_war.red_stone_output_16", "key.valkyrien_space_war.red_stone_output_17", "key.valkyrien_space_war.red_stone_output_18", "key.valkyrien_space_war.red_stone_output_19"};
    public static String[] keyNamesForLua = new String[keyNames.length];
    public static final byte FLOAT_COUNT = 13;
    public static final int KEY_LENGTH;
    private final float[] floats = new float[13];
    private final boolean[] booleans = new boolean[KEY_LENGTH];
    private int scrollIndex = -1;
    private int scrollOver = -1;

    public PacketControlData getInitPacket() {
        return new PacketControlData(-1L, new boolean[KEY_LENGTH], new float[13]);
    }

    public PacketControlData getPacket(float[] lastFloats, boolean[] lastBooleans) {
        long mask = 0L;
        boolean needScroll = this.scrollIndex > 0 || this.scrollOver > 0;
        for (int i = 0; i < KEY_LENGTH; ++i) {
            if (needScroll && (i == this.scrollIndex || i == this.scrollOver)) {
                if (i == this.scrollIndex) {
                    if (i < 13) {
                        this.floats[i] = 1.0f;
                    }
                    needScroll = false;
                    mask |= 1L << i;
                    this.scrollOver = this.scrollIndex;
                    this.scrollIndex = -1;
                    continue;
                }
                if (i < 13) {
                    this.floats[i] = 0.0f;
                    mask |= 1L << i;
                }
                this.scrollOver = -1;
                needScroll = false;
                continue;
            }
            if (i < 13) {
                if (Float.compare(this.floats[i], lastFloats[i]) == 0) continue;
                mask |= 1L << i;
                continue;
            }
            if (this.booleans[i] == lastBooleans[i]) continue;
            mask |= 1L << i;
        }
        if (mask != 0L) {
            return new PacketControlData(mask, this.booleans, this.floats);
        }
        return null;
    }

    public void pullScroll(int index) {
        this.scrollIndex = index;
    }

    public float[] getFloats() {
        float[] result = new float[13];
        for (int i = 0; i < 13; ++i) {
            result[i] = this.floats[i];
        }
        return result;
    }

    public boolean[] getBools() {
        boolean[] result = new boolean[KEY_LENGTH];
        for (int i = 0; i < KEY_LENGTH; ++i) {
            result[i] = this.booleans[i];
        }
        return result;
    }

    public void reset() {
        int i;
        for (i = 0; i < 13; ++i) {
            this.floats[i] = 0.0f;
        }
        for (i = 13; i < KEY_LENGTH; ++i) {
            this.booleans[i] = false;
        }
    }

    public void setInput(int index, float value) {
        if (index < 13) {
            this.floats[index] = value = value > 1.0f ? 1.0f : value;
        } else {
            boolean valueBool;
            this.booleans[index] = valueBool = value > 0.0f;
        }
    }

    public void printInput() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            int i;
            for (i = 0; i < 13; ++i) {
                if (!(this.floats[i] > 0.0f)) continue;
                player.m_213846_((Component)Component.m_237115_((String)keyNames[i]).m_130946_(" = " + this.floats[i]));
            }
            for (i = 13; i < KEY_LENGTH; ++i) {
                if (!this.booleans[i]) continue;
                player.m_213846_((Component)Component.m_237115_((String)keyNames[i]).m_130946_(" isPressed"));
            }
        }
    }

    static {
        for (int i = 0; i < keyNames.length; ++i) {
            VsswInputState.keyNamesForLua[i] = keyNames[i].replace("key.valkyrien_space_war.", "");
        }
        KEY_LENGTH = keyNames.length;
    }
}

