/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.input;

import java.util.LinkedHashMap;

public class VsswKeyConfigData {
    public LinkedHashMap<Integer, CustomBind> binds = new LinkedHashMap();

    public void syncVelocityMode(boolean b) {
        this.binds.forEach((k, v) -> {
            if (v.type == InputType.MOUSE_MOVEMENT_X || v.type == InputType.MOUSE_MOVEMENT_Y || v.type == InputType.MOUSE_MOVEMENT_NX || v.type == InputType.MOUSE_MOVEMENT_NY) {
                v.setVelocityMode(b);
            }
        });
    }

    public static class CustomBind {
        public InputType type;
        public int jid = -1;
        public int code;
        public boolean isBoolean;
        private float mouseSpeed = 1.0f;
        private boolean velocityMode = false;
        private float minDeadzone = 0.0f;
        private float maxDeadzone = 1.0f;

        public CustomBind(InputType type, int code) {
            this.type = type;
            this.code = code;
            this.isBoolean = true;
        }

        public CustomBind(InputType type, float mouseSpeed, boolean velocityMode) {
            this.type = type;
            this.mouseSpeed = mouseSpeed;
            this.isBoolean = false;
            this.velocityMode = velocityMode;
        }

        public CustomBind(InputType type, int jid, int code, float minDeadzone, float maxDeadzone) {
            this.type = type;
            this.jid = jid;
            this.code = code;
            this.minDeadzone = minDeadzone;
            this.maxDeadzone = maxDeadzone;
            this.isBoolean = false;
        }

        public CustomBind(InputType type, int jid, int code) {
            this.type = type;
            this.jid = jid;
            this.code = code;
            this.isBoolean = true;
        }

        public void setMouseSpeed(float mouseSpeed) {
            this.mouseSpeed = mouseSpeed = Math.copySign(mouseSpeed, Math.max(10.0f, Math.abs(mouseSpeed)));
        }

        public float getMouseSpeed() {
            return this.mouseSpeed;
        }

        public boolean setMinDeadzone(float minDeadzone) {
            this.minDeadzone = minDeadzone = Math.max(-1.0f, minDeadzone);
            return minDeadzone > -1.0f;
        }

        public float getMinDeadzone() {
            return this.minDeadzone;
        }

        public boolean setMaxDeadzone(float maxDeadzone) {
            this.maxDeadzone = maxDeadzone = Math.min(1.0f, maxDeadzone);
            return maxDeadzone < 1.0f;
        }

        public float getMaxDeadzone() {
            return this.maxDeadzone;
        }

        public boolean isVelocityMode() {
            return this.velocityMode;
        }

        public void setVelocityMode(boolean velocityMode) {
            this.velocityMode = velocityMode;
        }
    }

    public static enum InputType {
        MOUSE_MOVEMENT_X,
        MOUSE_MOVEMENT_NX,
        MOUSE_MOVEMENT_Y,
        MOUSE_MOVEMENT_NY,
        KEYBOARD,
        MOUSE_CLICK,
        MOUSE_SCROLL,
        GAMEPAD_BUTTON,
        GAMEPAD_HAT,
        GAMEPAD_AXIS,
        GAMEPAD_AXIS_NEGATIVE;

    }
}

