/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.item.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BlockItemJavaModelRenderer
extends BlockEntityWithoutLevelRenderer {
    private final Model model;
    protected ResourceLocation textureLocation;
    protected float scale = 1.0f;
    protected Vector3f offset = new Vector3f(0.0f, 0.0f, 0.0f);
    protected Quaternionf rotation = new Quaternionf();

    public BlockItemJavaModelRenderer(Class<? extends Model> modelClass, ModelLayerLocation location, ResourceLocation textureLocation) {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        this.textureLocation = textureLocation;
        this.model = BlockItemJavaModelRenderer.createModel(modelClass, Minecraft.m_91087_().m_167973_().m_171103_(location));
    }

    public static <T extends Model> T createModel(Class<T> modelClass, ModelPart rootPart) {
        try {
            Constructor<T> constructor = modelClass.getDeclaredConstructor(ModelPart.class);
            constructor.setAccessible(true);
            return (T)((Model)constructor.newInstance(rootPart));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(modelClass.getName() + " \u5fc5\u987b\u5305\u542b ModelPart \u53c2\u6570\u7684\u6784\u9020\u65b9\u6cd5", e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("\u65e0\u6cd5\u5b9e\u4f8b\u5316\u62bd\u8c61\u7c7b: " + modelClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("\u6784\u9020\u65b9\u6cd5\u6267\u884c\u5f02\u5e38", e.getCause());
        }
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setOffset(Vector3f offset) {
        this.offset = offset;
    }

    public void setRotation(Quaternionf rotation) {
        this.rotation = rotation;
    }

    public void m_108829_(ItemStack pStack, ItemDisplayContext pDisplayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        switch (pDisplayContext) {
            case GUI: {
                this.setupGuiTransform(poseStack);
                break;
            }
            case GROUND: {
                this.setupGroundTransform(poseStack);
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                this.setupLeftHandTransform(poseStack);
                break;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                this.setupRightHandTransform(poseStack);
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                this.setupThirdLeftPersonTransform(poseStack);
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                this.setupThirdRightPersonTransform(poseStack);
                break;
            }
            case FIXED: {
                this.setupFixedTransform(poseStack);
                break;
            }
            default: {
                this.setupDefaultTransform(poseStack);
            }
        }
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)this.textureLocation));
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        poseStack.m_252880_(this.offset.x(), this.offset.y(), this.offset.z());
        poseStack.m_252781_(this.rotation);
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    private void setupGuiTransform(PoseStack poseStack) {
        poseStack.m_85837_(0.45, 0.25, 0.5);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-45.0f));
        poseStack.m_85841_(0.4f, 0.4f, 0.4f);
    }

    private void setupGroundTransform(PoseStack poseStack) {
        poseStack.m_85837_(0.5, 0.25, 0.5);
        poseStack.m_85841_(0.25f, 0.25f, 0.25f);
    }

    private void setupThirdLeftPersonTransform(PoseStack poseStack) {
        poseStack.m_85837_(0.5, 0.45, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-45.0f));
        poseStack.m_85841_(0.25f, 0.25f, 0.25f);
    }

    private void setupThirdRightPersonTransform(PoseStack poseStack) {
        poseStack.m_85837_(0.5, 0.45, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
        poseStack.m_85841_(0.25f, 0.25f, 0.25f);
    }

    private void setupLeftHandTransform(PoseStack poseStack) {
        poseStack.m_85837_(0.5, 0.25, 0.5);
        poseStack.m_85841_(0.4f, 0.4f, 0.4f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-45.0f));
    }

    private void setupRightHandTransform(PoseStack poseStack) {
        poseStack.m_85837_(0.5, 0.25, 0.5);
        poseStack.m_85841_(0.4f, 0.4f, 0.4f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
    }

    private void setupFixedTransform(PoseStack poseStack) {
        poseStack.m_85837_(0.5, 0.1, 0.5);
        poseStack.m_85841_(0.4f, 0.4f, 0.4f);
        poseStack.m_85837_(0.4, 0.0, -0.4);
    }

    private void setupDefaultTransform(PoseStack poseStack) {
    }
}

