/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.item.tool;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.shao.valkyrien_space_war.block.monitors.base.IVsswMonitorProvider;
import net.shao.valkyrien_space_war.block.monitors.base.VsswMonitorComponent;
import net.shao.valkyrien_space_war.item.tool.VsswTools;
import net.shao.valkyrien_space_war.sound.ModSounds;

public class ModWrench
extends VsswTools {
    public static final byte ROTATE = 0;
    public static final byte MOVE = 1;
    private static final String TAG_STATE = "ModeState";
    private static final String TAG_VALUE = "Value";

    public ModWrench(Item.Properties pProperties) {
        super(pProperties);
    }

    public byte getState(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_(TAG_STATE) ? tag.m_128445_(TAG_STATE) : (byte)0;
    }

    public void setState(ItemStack stack, byte state) {
        stack.m_41784_().m_128344_(TAG_STATE, state);
    }

    public float getValue(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_(TAG_VALUE) ? tag.m_128457_(TAG_VALUE) : 1.0f;
    }

    public void setValue(ItemStack stack, float value) {
        stack.m_41784_().m_128350_(TAG_VALUE, value);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        if (pContext.m_43725_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        Player player = pContext.m_43723_();
        boolean shiftKeyDown = player.m_6144_();
        Level level = pContext.m_43725_();
        BlockEntity clickedBE = level.getExistingBlockEntity(pContext.m_8083_());
        if (clickedBE instanceof IVsswMonitorProvider) {
            IVsswMonitorProvider be = (IVsswMonitorProvider)clickedBE;
            ItemStack itemInHand = pContext.m_43722_();
            byte state = this.getState(itemInHand);
            float result = shiftKeyDown ? this.getValue(itemInHand) : -this.getValue(itemInHand);
            VsswMonitorComponent monitorComponent = be.getMonitorComponent();
            if (state == 0) {
                if (pContext.m_43719_() == Direction.UP || pContext.m_43719_() == Direction.DOWN) {
                    monitorComponent.setAngles(monitorComponent.getPitch(), monitorComponent.getYaw() + result);
                } else {
                    monitorComponent.setAngles(monitorComponent.getPitch() + result, monitorComponent.getYaw());
                }
                player.m_5661_((Component)Component.m_237115_((String)"tip.valkyrien_space_war.block_rotate").m_130946_(String.format("yaw: %.1f, pitch: %.1f", Float.valueOf(monitorComponent.getYaw()), Float.valueOf(monitorComponent.getPitch()))), true);
            } else {
                if (pContext.m_43719_() == Direction.UP || pContext.m_43719_() == Direction.DOWN) {
                    monitorComponent.setOffset(monitorComponent.getWidthOffset(), monitorComponent.getHeightOffset() + result);
                } else {
                    monitorComponent.setOffset(monitorComponent.getWidthOffset() + result, monitorComponent.getHeightOffset());
                }
                player.m_5661_((Component)Component.m_237115_((String)"tip.valkyrien_space_war.block_offset").m_130946_(String.format("offset_x: %.1f, offset_y: %.1f", Float.valueOf(monitorComponent.getWidthOffset()), Float.valueOf(monitorComponent.getHeightOffset()))), true);
            }
            level.m_5594_(null, pContext.m_8083_(), (SoundEvent)ModSounds.WRENCH_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (!pLevel.m_5776_()) {
            ItemStack itemInHand = pPlayer.m_21120_(pUsedHand);
            if (pPlayer.m_6144_()) {
                this.setValue(itemInHand, this.getValue(itemInHand) - 0.5f);
            } else {
                this.setValue(itemInHand, this.getValue(itemInHand) + 0.5f);
            }
            pPlayer.m_5661_((Component)Component.m_237115_((String)"tip.valkyrien_space_war.tool_strength").m_130946_(String.format("%.1f", Float.valueOf(this.getValue(itemInHand)))), true);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }
}

