/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.item.tool;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.block.base.ModConnectorBE;
import net.shao.valkyrien_space_war.block.base.ModGuestBE;
import net.shao.valkyrien_space_war.block.base.ModHostBE;
import net.shao.valkyrien_space_war.item.tool.VsswTools;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;

public class P2PConnector
extends VsswTools {
    private static final Component SAME_HOST_MSG = Component.m_237115_((String)"tip.valkyrien_space_war.same_host").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)4244735)).m_131136_(Boolean.valueOf(true)));
    private static final Component SAME_CLIENT_MSG = Component.m_237115_((String)"tip.valkyrien_space_war.same_client").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)6942894)).m_131136_(Boolean.valueOf(true)));
    private static final Component ADD_CHILD = Component.m_237115_((String)"tip.valkyrien_space_war.add_p2p_child").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x66FF66)).m_131136_(Boolean.valueOf(true)));
    private static final Component REMOVED_CHILD_MSG = Component.m_237115_((String)"tip.valkyrien_space_war.removed_child").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xC30000)).m_131136_(Boolean.valueOf(true)));

    public P2PConnector(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        boolean isSameBlockBE;
        if (pContext.m_43725_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (pContext.m_43723_().m_6144_()) {
            return InteractionResult.SUCCESS;
        }
        Level level = pContext.m_43725_();
        Player player = pContext.m_43723_();
        ItemStack stack = pContext.m_43722_();
        BlockEntity alreadySelectedBE = null;
        BlockPos selectionPos = P2PConnector.getSelectionPos(stack);
        if (selectionPos != null) {
            alreadySelectedBE = level.getExistingBlockEntity(selectionPos);
        }
        BlockPos clickedPos = pContext.m_8083_();
        BlockEntity clickedBE = level.getExistingBlockEntity(pContext.m_8083_());
        boolean bl = isSameBlockBE = alreadySelectedBE == clickedBE;
        if (!isSameBlockBE && clickedBE instanceof ModConnectorBE) {
            if (alreadySelectedBE == null) {
                P2PConnector.setSelectionPos(stack, clickedPos);
            } else if (alreadySelectedBE instanceof ModHostBE && clickedBE instanceof ModHostBE) {
                P2PConnector.setSelectionPos(stack, clickedPos);
            } else if (alreadySelectedBE instanceof ModGuestBE && clickedBE instanceof ModGuestBE) {
                P2PConnector.setSelectionPos(stack, clickedPos);
            } else if (alreadySelectedBE instanceof ModHostBE) {
                ModHostBE hostBE = (ModHostBE)alreadySelectedBE;
                this.addOrRemoveConnect(player, hostBE, (ModGuestBE)clickedBE);
            } else if (clickedBE instanceof ModHostBE) {
                ModHostBE hostBE = (ModHostBE)clickedBE;
                this.addOrRemoveConnect(player, hostBE, (ModGuestBE)alreadySelectedBE);
                P2PConnector.removeSelectionPos(stack);
            }
        } else {
            P2PConnector.removeSelectionPos(stack);
        }
        int slot = player.m_150109_().m_36030_(stack);
        ModNetworkHandler.sendToPlayer((ServerPlayer)pContext.m_43723_(), new SyncSelectionPacket(stack, slot));
        return InteractionResult.SUCCESS;
    }

    private void addOrRemoveConnect(Player player, ModHostBE hostBE, ModGuestBE guestBE) {
        BlockPos gPos = guestBE.m_58899_();
        if (!hostBE.addChild(gPos)) {
            hostBE.removeChildren(gPos);
            guestBE.removeParent();
            player.m_5661_(REMOVED_CHILD_MSG, true);
        } else {
            guestBE.setParent(hostBE.m_58899_());
            player.m_5661_(ADD_CHILD, true);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pLevel.m_5776_()) {
            return InteractionResultHolder.m_19098_((Object)pPlayer.m_21120_(pUsedHand));
        }
        if (pPlayer.m_6144_()) {
            ItemStack stack = pPlayer.m_21120_(pUsedHand);
            int slot = pPlayer.m_150109_().m_36030_(stack);
            P2PConnector.removeSelectionPos(stack);
            ModNetworkHandler.sendToPlayer((ServerPlayer)pPlayer, new SyncSelectionPacket(stack, slot));
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public static BlockPos getSelectionPos(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("SelectionPos")) {
            return BlockPos.m_122022_((long)tag.m_128454_("SelectionPos"));
        }
        return null;
    }

    public static void setSelectionPos(ItemStack stack, BlockPos pos) {
        CompoundTag tag = stack.m_41784_();
        if (pos != null) {
            tag.m_128356_("SelectionPos", pos.m_121878_());
        } else {
            tag.m_128473_("SelectionPos");
        }
    }

    public static void removeSelectionPos(ItemStack stack) {
        P2PConnector.setSelectionPos(stack, null);
    }

    public static class SyncSelectionPacket {
        private final ItemStack stack;
        private final int slot;

        public SyncSelectionPacket(ItemStack stack, int slot) {
            this.stack = stack;
            this.slot = slot;
        }

        public void encode(FriendlyByteBuf buffer) {
            buffer.m_130055_(this.stack);
            buffer.writeInt(this.slot);
        }

        public SyncSelectionPacket(FriendlyByteBuf buffer) {
            this.stack = buffer.m_130267_();
            this.slot = buffer.readInt();
        }

        public static void handle(SyncSelectionPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ != null) {
                    mc.f_91074_.m_150109_().m_6836_(msg.slot, msg.stack);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

