/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.mixin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.shao.valkyrien_space_war.function.camera.VsCameraDistHelper;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import net.shao.valkyrien_space_war.mixinducks.ICameraDuck;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBi;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.world.ShipWorldCore;
import org.valkyrienskies.core.impl.game.ships.ShipObjectClient;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;

@Mixin(value={Camera.class})
public abstract class MixinCamera
implements ICameraDuck {
    @Shadow
    private boolean f_90549_;
    @Shadow
    private BlockGetter f_90550_;
    @Shadow
    private Entity f_90551_;
    @Shadow
    @Final
    private Vector3f f_90554_;
    @Shadow
    @Final
    private Vector3f f_90555_;
    @Shadow
    @Final
    private Vector3f f_90556_;
    @Shadow
    private float f_90557_;
    @Shadow
    private float f_90558_;
    @Shadow
    @Final
    private Quaternionf f_90559_;
    @Shadow
    private float f_90562_;
    @Shadow
    private float f_90563_;
    @Shadow
    private Vec3 f_90552_;

    @Shadow
    protected abstract double m_90566_(double var1);

    @Shadow
    protected abstract void m_90568_(double var1, double var3, double var5);

    @Shadow
    protected abstract void m_90584_(double var1, double var3, double var5);

    @Override
    @Unique
    public void vssw$setupWithShipMounted(@NotNull BlockGetter level, @NotNull Entity renderViewEntity, boolean thirdPerson, boolean thirdPersonReverse, float partialTicks, @Nullable ClientShip shipMountedTo, @NotNull Vector3dc inShipPlayerPosition) {
        ShipTransform renderTransform = Optional.ofNullable(shipMountedTo).map(ClientShip::getRenderTransform).orElse((ShipTransform)new ShipTransformImpl((Vector3dc)new Vector3d(), (Vector3dc)new Vector3d(), (Quaterniondc)new Quaterniond(), (Vector3dc)new Vector3d(1.0, 1.0, 1.0)));
        this.f_90549_ = true;
        this.f_90550_ = level;
        this.f_90551_ = renderViewEntity;
        Vector3d playerBasePos = renderTransform.getShipToWorld().transformPosition(inShipPlayerPosition, new Vector3d());
        this.vssw$setRotationWithShipTransform(renderViewEntity.m_5675_(partialTicks), renderViewEntity.m_5686_(partialTicks), renderTransform);
        this.m_90584_(playerBasePos.x(), playerBasePos.y(), playerBasePos.z());
        if (thirdPerson && shipMountedTo != null) {
            if (thirdPersonReverse) {
                this.vssw$setRotationWithShipTransform(this.f_90558_ + 180.0f, -this.f_90557_, renderTransform);
            }
            AABBi boundingBox = (AABBi)shipMountedTo.getShipAABB();
            double dist = (double)(boundingBox.lengthX() + boundingBox.lengthY() + boundingBox.lengthZ()) / 3.0 * 1.5;
            double d = dist = (dist *= VsCameraDistHelper.getDistMultiplier()) > 4.0 ? dist : 4.0;
            if (this.f_90550_ instanceof Level) {
                this.m_90568_(-this.vssw$getMaxZoomIgnoringMountedShip((Level)this.f_90550_, 4.0 * (dist / 4.0), shipMountedTo), 0.0, 0.0);
            } else {
                this.m_90568_(-this.m_90566_(4.0 * (dist / 4.0)), 0.0, 0.0);
            }
        }
    }

    @Override
    public void vssw$setRotationWithShipTransform(float yaw, float pitch, ShipTransform renderTransform) {
        Quaterniond originalRotation = new Quaterniond().rotateY(Math.toRadians(-yaw)).rotateX(Math.toRadians(pitch)).normalize();
        Quaterniond newRotation = new Quaterniond(renderTransform.getShipToWorldRotation()).mul((Quaterniondc)originalRotation);
        this.f_90557_ = pitch;
        this.f_90558_ = yaw;
        this.f_90559_.set((Quaterniondc)newRotation);
        this.f_90554_.set(0.0f, 0.0f, 1.0f);
        this.f_90559_.transform(this.f_90554_);
        this.f_90555_.set(0.0f, 1.0f, 0.0f);
        this.f_90559_.transform(this.f_90555_);
        this.f_90556_.set(1.0f, 0.0f, 0.0f);
        this.f_90559_.transform(this.f_90556_);
    }

    @Unique
    private double vssw$getMaxZoomIgnoringMountedShip(Level level, double maxZoom, @NotNull ClientShip toIgnore) {
        for (int i = 0; i < 8; ++i) {
            double e;
            float f = (i & 1) * 2 - 1;
            float g = (i >> 1 & 1) * 2 - 1;
            float h = (i >> 2 & 1) * 2 - 1;
            Vec3 vec3 = this.f_90552_.m_82520_((double)(f *= 0.1f), (double)(g *= 0.1f), (double)(h *= 0.1f));
            Vec3 vec32 = new Vec3(this.f_90552_.f_82479_ - (double)this.f_90554_.x() * maxZoom + (double)f + (double)h, this.f_90552_.f_82480_ - (double)this.f_90554_.y() * maxZoom + (double)g, this.f_90552_.f_82481_ - (double)this.f_90554_.z() * maxZoom + (double)h);
            HashSet<Ship> closerShips = VsUtil.getCloserShips(level, toIgnore.getId());
            ArrayList<Long> relatedShips = new ArrayList<Long>();
            for (Ship closerShip : closerShips) {
                relatedShips.add(closerShip.getId());
            }
            HitResult hitResult = this.customClip(level, new ClipContext(vec3, vec32, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, this.f_90551_), true, relatedShips);
            if (hitResult.m_6662_() == HitResult.Type.MISS || !((e = hitResult.m_82450_().m_82554_(this.f_90552_)) < maxZoom)) continue;
            maxZoom = e;
        }
        return maxZoom;
    }

    private HitResult customClip(Level level, ClipContext ctx, Boolean shouldTransformHitPos, List<Long> skipShips) {
        BlockHitResult vanillaHit = this.vanillaClip(ctx);
        ShipWorldCore shipObjectWorld = VsUtil.getShipObjectWorldCore(level);
        if (shipObjectWorld == null) {
            return vanillaHit;
        }
        BlockHitResult closestHit = vanillaHit;
        Vec3 closestHitPos = vanillaHit.m_82450_();
        double closestHitDist = closestHitPos.m_82557_(ctx.m_45702_());
        AABBd clipAABB = new AABBd((Vector3fc)ctx.m_45702_().m_252839_(), (Vector3fc)ctx.m_45693_().m_252839_()).correctBounds();
        for (LoadedShip ship : shipObjectWorld.getLoadedShips().getIntersecting((AABBdc)clipAABB)) {
            if (skipShips.contains(ship.getId())) continue;
            Matrix4dc worldToShip = Optional.of((ShipObjectClient)ship).map(client -> client.getRenderTransform().getWorldToShip()).orElse(ship.getWorldToShip());
            Matrix4dc shipToWorld = Optional.of((ShipObjectClient)ship).map(client -> client.getRenderTransform().getShipToWorld()).orElse(ship.getShipToWorld());
            Vector3d start = worldToShip.transformPosition(new Vector3d((Vector3fc)ctx.m_45702_().m_252839_()));
            Vector3d end = worldToShip.transformPosition(new Vector3d((Vector3fc)ctx.m_45693_().m_252839_()));
            Vec3 shipStart = new Vec3(start.x, start.y, start.z);
            Vec3 shipEnd = new Vec3(end.x, end.y, end.z);
            ClipContext clipContext = new ClipContext(shipStart, shipEnd, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, this.f_90551_);
            BlockHitResult shipHit = level.m_45547_(clipContext);
            Vector3d shipHitPos = shipToWorld.transformPosition(new Vector3d((Vector3fc)shipHit.m_82450_().m_252839_()));
            double shipHitDist = shipHitPos.distanceSquared((Vector3dc)new Vector3d(ctx.m_45702_().m_7096_(), ctx.m_45702_().m_7098_(), ctx.m_45702_().m_7094_()));
            if (!(shipHitDist < closestHitDist) || shipHit.m_6662_() == HitResult.Type.MISS) continue;
            closestHit = shipHit;
            closestHitPos = new Vec3(shipHitPos.x(), shipHitPos.y(), shipHitPos.z());
            closestHitDist = shipHitDist;
        }
        if (shouldTransformHitPos.booleanValue()) {
            closestHit = new BlockHitResult(closestHitPos, closestHit.m_82434_(), closestHit.m_82425_(), closestHit.m_82436_());
        }
        return closestHit;
    }

    public BlockHitResult vanillaClip(ClipContext context) {
        return (BlockHitResult)BlockGetter.m_151361_((Vec3)context.m_45702_(), (Vec3)context.m_45693_(), (Object)context, (clipContext, blockPos) -> {
            double e;
            BlockState blockState = this.f_90550_.m_8055_(blockPos);
            FluidState fluidState = this.f_90550_.m_6425_(blockPos);
            Vec3 vec3 = clipContext.m_45702_();
            Vec3 vec32 = clipContext.m_45693_();
            VoxelShape voxelShape = clipContext.m_45694_(blockState, this.f_90550_, blockPos);
            BlockHitResult blockHitResult = this.f_90550_.m_45558_(vec3, vec32, blockPos, voxelShape, blockState);
            VoxelShape voxelShape2 = clipContext.m_45698_(fluidState, this.f_90550_, blockPos);
            BlockHitResult blockHitResult2 = voxelShape2.m_83220_(vec3, vec32, blockPos);
            double d = blockHitResult == null ? Double.MAX_VALUE : vec3.m_82557_(blockHitResult.m_82450_());
            double d2 = e = blockHitResult2 == null ? Double.MAX_VALUE : vec3.m_82557_(blockHitResult2.m_82450_());
            if (d <= e) {
                return blockHitResult;
            }
            return blockHitResult2;
        }, ctx -> {
            Vec3 vec3 = ctx.m_45702_().m_82546_(ctx.m_45693_());
            return BlockHitResult.m_82426_((Vec3)ctx.m_45693_(), (Direction)Direction.m_122366_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_), (BlockPos)BlockPos.m_274446_((Position)ctx.m_45693_()));
        });
    }
}

