/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.mixin;

import net.minecraft.client.MouseHandler;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.network.chat.Component;
import net.shao.valkyrien_space_war.block.turret.base.TurretCameraEntity;
import net.shao.valkyrien_space_war.block.turret.base.TurretCameraMouseHandle;
import net.shao.valkyrien_space_war.function.camera.CameraZoomHandler;
import net.shao.valkyrien_space_war.function.util.ModClientUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MouseHandler.class})
public class MouseHandlerMixin {
    private static double lastMouseX;
    private static double lastMouseY;

    @Redirect(method={"turnPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Options;sensitivity()Lnet/minecraft/client/OptionInstance;"))
    private OptionInstance<Double> injectDynamicSensitivity(Options instance) {
        if (CameraZoomHandler.isZooming()) {
            return new OptionInstance("valkyrien_space_war.dynamic_sensitivity", OptionInstance.m_231498_(), (text, value) -> Component.m_237113_((String)String.format("%.2f", value)), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE.m_231750_(v -> v, v -> v), (Object)CameraZoomHandler.getEffectiveSensitivity(), v -> {});
        }
        return instance.m_231964_();
    }

    @Inject(method={"onMove"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseMove(long window, double x, double y, CallbackInfo ci) {
        TurretCameraEntity turretCameraEntity = TurretCameraMouseHandle.getTurretCameraEntity();
        if (ModClientUtil.isGameFocused() && turretCameraEntity != null) {
            ci.cancel();
            TurretCameraMouseHandle.onMouseMove(turretCameraEntity, x - lastMouseX, y - lastMouseY);
        }
        lastMouseX = x;
        lastMouseY = y;
    }

    @Inject(method={"onScroll"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseScroll(long pWindowPointer, double pXOffset, double pYOffset, CallbackInfo ci) {
        TurretCameraEntity turretCameraEntity = TurretCameraMouseHandle.getTurretCameraEntity();
        if (ModClientUtil.isGameFocused() && turretCameraEntity != null) {
            ci.cancel();
            TurretCameraMouseHandle.onMouseScroll(turretCameraEntity, pXOffset, pYOffset);
        }
    }

    @Inject(method={"onPress"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMousePress(long pWindowPointer, int pButton, int pAction, int pModifiers, CallbackInfo ci) {
        TurretCameraEntity turretCameraEntity = TurretCameraMouseHandle.getTurretCameraEntity();
        if (ModClientUtil.isGameFocused() && turretCameraEntity != null) {
            ci.cancel();
            TurretCameraMouseHandle.onMousePress(turretCameraEntity, pButton, pAction, pModifiers);
        }
    }
}

