/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import net.shao.valkyrien_space_war.item.tool.P2PConnector;
import net.shao.valkyrien_space_war.network.control.PacketControlData;
import net.shao.valkyrien_space_war.network.control.ReleaseControlPacket;
import net.shao.valkyrien_space_war.network.control.ResetClientInputPacket;
import net.shao.valkyrien_space_war.network.control.SyncIsControllingPacket;
import net.shao.valkyrien_space_war.network.control_seat.ControlSeatSetupPacket;
import net.shao.valkyrien_space_war.network.hologram.SyncHologramRenderTargetPacket;
import net.shao.valkyrien_space_war.network.joint.ActivationMotorPacket;
import net.shao.valkyrien_space_war.network.joint.RemoveConstraintPacket;
import net.shao.valkyrien_space_war.network.joint.SwitchPdModePacket;
import net.shao.valkyrien_space_war.network.joint.UpdateAttachmentPacket;
import net.shao.valkyrien_space_war.network.joint.UpdateSeparatePacket;
import net.shao.valkyrien_space_war.network.joint.UpdateSeqCommandsPacket;
import net.shao.valkyrien_space_war.network.monitor.ModMonitorScrollPacket;
import net.shao.valkyrien_space_war.network.monitor.SyncScrollOffsetMessage;
import net.shao.valkyrien_space_war.network.monitor.VsswMonitorClickPacket;
import net.shao.valkyrien_space_war.network.particle.HighExplosionParticlePacket;
import net.shao.valkyrien_space_war.network.projectile.RemoveProjectilePacket;
import net.shao.valkyrien_space_war.network.projectile.SpawnProjectilePacket;
import net.shao.valkyrien_space_war.network.projectile.SyncProjectilePacket;
import net.shao.valkyrien_space_war.network.record.AddRecordPacket;
import net.shao.valkyrien_space_war.network.record.RecordListPacket;
import net.shao.valkyrien_space_war.network.record.RemoveRecordPacket;
import net.shao.valkyrien_space_war.network.record.RequestRecordListPacket;
import net.shao.valkyrien_space_war.network.rs_channel.SyncRsProviderChannelToClientPacket;
import net.shao.valkyrien_space_war.network.rs_channel.UpdateRsProviderChannelPacket;
import net.shao.valkyrien_space_war.network.rs_channel.UpdateRsReceiverChannelPacket;
import net.shao.valkyrien_space_war.network.shield.PacketEnergyShieldData;
import net.shao.valkyrien_space_war.network.shield.SetEnergyShieldAutoRangePacket;
import net.shao.valkyrien_space_war.network.shield.SetEnergyShieldRangePacket;
import net.shao.valkyrien_space_war.network.thruster.ThrusterSetColorPacket;
import net.shao.valkyrien_space_war.network.thruster.ThrusterSetDirPacket;
import net.shao.valkyrien_space_war.network.tools.SwitchToolModePacket;
import net.shao.valkyrien_space_war.network.turret.ActivateTurretPacket;
import net.shao.valkyrien_space_war.network.turret.EntityDataSyncPacket;
import net.shao.valkyrien_space_war.network.turret.MuzzleFlashPacket;
import net.shao.valkyrien_space_war.network.turret.ResetCameraZoomPacket;
import net.shao.valkyrien_space_war.network.turret.SyncEnergyTurretDataPacket;
import net.shao.valkyrien_space_war.network.turret.TurretAngleLimitPacket;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;

public class ModNetworkHandler {
    public static SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("valkyrien_space_war", "network")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
    private static int packetId = 0;

    private static int id() {
        return packetId++;
    }

    public static void registerPackets() {
        ModNetworkHandler.registerTurretPackets();
        ModNetworkHandler.registerProjectilePackets();
        ModNetworkHandler.registerShieldPackets();
        ModNetworkHandler.registerControlPackets();
        ModNetworkHandler.registerMonitorPackets();
        ModNetworkHandler.registerToolPackets();
        ModNetworkHandler.registerThrusterPackets();
        ModNetworkHandler.registerRecordPackets();
        ModNetworkHandler.registerJointPackets();
        ModNetworkHandler.registerRsChannelPackets();
        ModNetworkHandler.registerControlSeatPackets();
        ModNetworkHandler.registerParticlePackets();
    }

    private static void registerThrusterPackets() {
        INSTANCE.registerMessage(ModNetworkHandler.id(), ThrusterSetDirPacket.class, ThrusterSetDirPacket::encode, ThrusterSetDirPacket::new, ThrusterSetDirPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), ThrusterSetColorPacket.class, ThrusterSetColorPacket::encode, ThrusterSetColorPacket::new, ThrusterSetColorPacket::handle);
    }

    private static void registerParticlePackets() {
        INSTANCE.registerMessage(ModNetworkHandler.id(), HighExplosionParticlePacket.class, HighExplosionParticlePacket::encode, HighExplosionParticlePacket::new, HighExplosionParticlePacket::handle);
    }

    private static void registerProjectilePackets() {
        INSTANCE.registerMessage(ModNetworkHandler.id(), SpawnProjectilePacket.class, SpawnProjectilePacket::encode, SpawnProjectilePacket::new, SpawnProjectilePacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), SyncProjectilePacket.class, SyncProjectilePacket::encode, SyncProjectilePacket::new, SyncProjectilePacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), RemoveProjectilePacket.class, RemoveProjectilePacket::encode, RemoveProjectilePacket::new, RemoveProjectilePacket::handle);
    }

    private static void registerMonitorPackets() {
        INSTANCE.registerMessage(ModNetworkHandler.id(), VsswMonitorClickPacket.class, VsswMonitorClickPacket::encode, VsswMonitorClickPacket::new, VsswMonitorClickPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), ModMonitorScrollPacket.class, ModMonitorScrollPacket::encode, ModMonitorScrollPacket::new, ModMonitorScrollPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), SyncScrollOffsetMessage.class, SyncScrollOffsetMessage::encode, SyncScrollOffsetMessage::new, SyncScrollOffsetMessage::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), SyncHologramRenderTargetPacket.class, SyncHologramRenderTargetPacket::encode, SyncHologramRenderTargetPacket::new, SyncHologramRenderTargetPacket::handle);
    }

    private static void registerToolPackets() {
        INSTANCE.registerMessage(ModNetworkHandler.id(), P2PConnector.SyncSelectionPacket.class, P2PConnector.SyncSelectionPacket::encode, P2PConnector.SyncSelectionPacket::new, P2PConnector.SyncSelectionPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), SwitchToolModePacket.class, SwitchToolModePacket::encode, SwitchToolModePacket::new, SwitchToolModePacket::handle);
    }

    private static void registerControlPackets() {
        INSTANCE.registerMessage(ModNetworkHandler.id(), PacketControlData.class, PacketControlData::encode, PacketControlData::new, PacketControlData::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), SyncIsControllingPacket.class, SyncIsControllingPacket::encode, SyncIsControllingPacket::new, SyncIsControllingPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), ReleaseControlPacket.class, ReleaseControlPacket::encode, ReleaseControlPacket::new, ReleaseControlPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), ResetClientInputPacket.class, ResetClientInputPacket::encode, ResetClientInputPacket::new, ResetClientInputPacket::handle);
    }

    private static void registerShieldPackets() {
        INSTANCE.registerMessage(ModNetworkHandler.id(), PacketEnergyShieldData.class, PacketEnergyShieldData::encode, PacketEnergyShieldData::new, PacketEnergyShieldData::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), SetEnergyShieldAutoRangePacket.class, SetEnergyShieldAutoRangePacket::encode, SetEnergyShieldAutoRangePacket::new, SetEnergyShieldAutoRangePacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), SetEnergyShieldRangePacket.class, SetEnergyShieldRangePacket::encode, SetEnergyShieldRangePacket::new, SetEnergyShieldRangePacket::handle);
    }

    private static void registerTurretPackets() {
        INSTANCE.registerMessage(ModNetworkHandler.id(), ActivateTurretPacket.class, ActivateTurretPacket::encode, ActivateTurretPacket::new, ActivateTurretPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), EntityDataSyncPacket.class, EntityDataSyncPacket::encode, EntityDataSyncPacket::new, EntityDataSyncPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), TurretAngleLimitPacket.class, TurretAngleLimitPacket::encode, TurretAngleLimitPacket::new, TurretAngleLimitPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), SyncEnergyTurretDataPacket.class, SyncEnergyTurretDataPacket::encode, SyncEnergyTurretDataPacket::new, SyncEnergyTurretDataPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), MuzzleFlashPacket.class, MuzzleFlashPacket::encode, MuzzleFlashPacket::new, MuzzleFlashPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), ResetCameraZoomPacket.class, ResetCameraZoomPacket::encode, ResetCameraZoomPacket::new, ResetCameraZoomPacket::handle);
    }

    private static void registerRecordPackets() {
        INSTANCE.registerMessage(ModNetworkHandler.id(), RecordListPacket.class, RecordListPacket::encode, RecordListPacket::new, RecordListPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), RequestRecordListPacket.class, RequestRecordListPacket::encode, RequestRecordListPacket::new, RequestRecordListPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), AddRecordPacket.class, AddRecordPacket::encode, AddRecordPacket::new, AddRecordPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), RemoveRecordPacket.class, RemoveRecordPacket::encode, RemoveRecordPacket::new, RemoveRecordPacket::handle);
    }

    private static void registerJointPackets() {
        INSTANCE.registerMessage(ModNetworkHandler.id(), UpdateSeqCommandsPacket.class, UpdateSeqCommandsPacket::encode, UpdateSeqCommandsPacket::new, UpdateSeqCommandsPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), UpdateAttachmentPacket.class, UpdateAttachmentPacket::encode, UpdateAttachmentPacket::new, UpdateAttachmentPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), UpdateSeparatePacket.class, UpdateSeparatePacket::encode, UpdateSeparatePacket::new, UpdateSeparatePacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), SwitchPdModePacket.class, SwitchPdModePacket::encode, SwitchPdModePacket::new, SwitchPdModePacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), ActivationMotorPacket.class, ActivationMotorPacket::encode, ActivationMotorPacket::new, ActivationMotorPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), RemoveConstraintPacket.class, RemoveConstraintPacket::encode, RemoveConstraintPacket::new, RemoveConstraintPacket::handle);
    }

    private static void registerRsChannelPackets() {
        INSTANCE.registerMessage(ModNetworkHandler.id(), UpdateRsProviderChannelPacket.class, UpdateRsProviderChannelPacket::encode, UpdateRsProviderChannelPacket::new, UpdateRsProviderChannelPacket::handle);
        INSTANCE.registerMessage(ModNetworkHandler.id(), SyncRsProviderChannelToClientPacket.class, SyncRsProviderChannelToClientPacket::encode, SyncRsProviderChannelToClientPacket::new, SyncRsProviderChannelToClientPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        INSTANCE.registerMessage(ModNetworkHandler.id(), UpdateRsReceiverChannelPacket.class, UpdateRsReceiverChannelPacket::encode, UpdateRsReceiverChannelPacket::new, UpdateRsReceiverChannelPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    private static void registerControlSeatPackets() {
        INSTANCE.registerMessage(ModNetworkHandler.id(), ControlSeatSetupPacket.class, ControlSeatSetupPacket::encode, ControlSeatSetupPacket::new, ControlSeatSetupPacket::handle);
    }

    public static void sendToServer(Object message) {
        INSTANCE.send(PacketDistributor.SERVER.noArg(), message);
    }

    public static void sendToPlayer(ServerPlayer player, Object message) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static void sendToAllPlayers(Level level, Object message) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6907_().forEach(player -> ModNetworkHandler.sendToPlayer(player, message));
        }
    }

    public static void sendToNearbyPlayers(int chunkRange, Level level, BlockPos pos, Object message) {
        BlockPos wPos = new BlockPos((Vec3i)pos);
        LoadedShip ship = VsUtil.getShip(level, wPos);
        if (ship != null) {
            wPos = VsUtil.getShipToWorldBlockPos((Ship)ship, wPos);
        }
        ChunkPos centerChunk = new ChunkPos(wPos);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8795_(player -> {
                ChunkPos playerChunk = new ChunkPos(player.m_20183_());
                return Math.abs(playerChunk.f_45578_ - centerChunk.f_45578_) <= chunkRange && Math.abs(playerChunk.f_45579_ - centerChunk.f_45579_) <= chunkRange;
            }).forEach(player -> ModNetworkHandler.sendToPlayer(player, message));
        }
    }
}

