/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.control;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.block.seat.base.BaseShipControlSeatBE;
import net.shao.valkyrien_space_war.block.seat.base.ShipControlSeatEntity;

public class PacketControlData {
    private long mask;
    private float[] axis;
    private boolean[] buttons;
    private boolean[] axisFlags;

    public PacketControlData(long mask, boolean[] buttons, float[] axis) {
        this.mask = mask;
        this.buttons = buttons;
        this.axis = axis;
    }

    public PacketControlData(FriendlyByteBuf buf) {
        this.mask = buf.readLong();
        long bts = buf.readLong();
        this.buttons = PacketControlData.parseMask(bts, (byte)64);
        this.axis = new float[13];
        this.axisFlags = PacketControlData.parseMask(this.mask, (byte)13);
        for (int i = 0; i < this.axisFlags.length; ++i) {
            if (!this.axisFlags[i]) continue;
            this.axis[i] = buf.readFloat();
        }
    }

    public static boolean[] parseMask(long mask, byte len) {
        boolean[] flags = new boolean[len];
        for (int i = 0; i < len; ++i) {
            flags[i] = (mask & 1L << i) != 0L;
        }
        return flags;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeLong(this.mask);
        long bts = 0L;
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i]) continue;
            bts |= 1L << i;
        }
        buf.writeLong(bts);
        boolean[] axisFlags = PacketControlData.parseMask(this.mask, (byte)13);
        for (int i = 0; i < axisFlags.length; ++i) {
            if (!axisFlags[i]) continue;
            buf.writeFloat(this.axis[i]);
        }
    }

    public static int countLow13Bits(int mask) {
        mask &= 0x1FFF;
        int count = 0;
        while (mask != 0) {
            mask &= mask - 1;
            ++count;
        }
        return count;
    }

    public static int countSetBits(int mask) {
        int count = 0;
        while (mask != 0) {
            mask &= mask - 1;
            ++count;
        }
        return count;
    }

    public static float[] unPackPacket(int mask, float[] axis, boolean[] bts) {
        float[] result = new float[32];
        boolean[] axisFlags = PacketControlData.parseMask(mask, (byte)32);
        int axisIndex = 0;
        for (int i = 0; i < axisFlags.length; ++i) {
            if (axisFlags[i]) {
                if (i < 13) {
                    result[i] = axis[axisIndex];
                    ++axisIndex;
                    continue;
                }
                result[i] = 0.0f;
                continue;
            }
            result[i] = 0.0f;
        }
        return result;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            Entity vehicle = sender.m_20202_();
            if (vehicle instanceof ShipControlSeatEntity) {
                BaseShipControlSeatBE be = ((ShipControlSeatEntity)vehicle).getBlockEntity();
                if (be == null) {
                    return;
                }
                be.setInput(this.axisFlags, this.buttons, this.axis);
            }
        });
        context.setPacketHandled(true);
    }
}

