/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.control;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.block.seat.base.BaseShipControlSeatBE;

public class SyncIsControllingPacket {
    private final BlockPos blockPos;
    private final boolean isControlling;

    public SyncIsControllingPacket(BlockPos blockPos, boolean isControlling) {
        this.blockPos = blockPos;
        this.isControlling = isControlling;
    }

    public SyncIsControllingPacket(FriendlyByteBuf buf) {
        this.blockPos = buf.m_130135_();
        this.isControlling = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.writeBoolean(this.isControlling);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            BlockEntity blockEntity = context.getSender().m_9236_().m_7702_(this.blockPos);
            if (blockEntity instanceof BaseShipControlSeatBE) {
                BaseShipControlSeatBE be = (BaseShipControlSeatBE)blockEntity;
                be.setControlling(this.isControlling);
            }
        });
        context.setPacketHandled(true);
    }
}

