/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.control_seat;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.block.seat.base.BaseShipControlSeatBE;

public class ControlSeatSetupPacket {
    private final BlockPos pos;
    private final float yaw;
    private final float pitch;
    private final boolean resetHead;

    public ControlSeatSetupPacket(BlockPos pos, float yaw, float pitch, boolean resetHead) {
        this.pos = pos;
        this.yaw = yaw;
        this.pitch = pitch;
        this.resetHead = resetHead;
    }

    public ControlSeatSetupPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.yaw = buf.readFloat();
        this.pitch = buf.readFloat();
        this.resetHead = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
        buf.writeBoolean(this.resetHead);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            BlockEntity blockEntity = sender.m_9236_().m_7702_(this.pos);
            if (blockEntity instanceof BaseShipControlSeatBE) {
                BaseShipControlSeatBE seat = (BaseShipControlSeatBE)blockEntity;
                seat.setYaw(this.yaw);
                seat.setPitch(this.pitch);
                seat.setResetCameraRot(this.resetHead);
            }
        });
        context.setPacketHandled(true);
    }
}

