/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.network.hologram;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.shao.valkyrien_space_war.block.seat.base.BaseShipControlSeatBE;
import org.joml.Vector3f;

public class SyncHologramRenderTargetPacket {
    private final BlockPos blockPos;
    private final short count;
    private Vector3f[] targets;
    private boolean[] isShip;
    private long[] ids;

    public SyncHologramRenderTargetPacket(BlockPos blockPos, short count, Vector3f[] targets, boolean[] isShip, long[] ids) {
        this.blockPos = blockPos;
        this.count = count;
        this.targets = targets;
        this.isShip = isShip;
        this.ids = ids;
    }

    public SyncHologramRenderTargetPacket(FriendlyByteBuf buf) {
        this.blockPos = buf.m_130135_();
        this.count = buf.readShort();
        this.targets = new Vector3f[this.count];
        this.isShip = new boolean[this.count];
        this.ids = new long[this.count];
        if (this.count > 0) {
            for (int i = 0; i < this.count; ++i) {
                this.targets[i] = buf.m_269394_();
                this.isShip[i] = buf.readBoolean();
                this.ids[i] = buf.readLong();
            }
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.writeShort((int)this.count);
        if (this.count > 0) {
            for (int i = 0; i < this.count; ++i) {
                buf.m_269582_(this.targets[i]);
                buf.writeBoolean(this.isShip[i]);
                buf.writeLong(this.ids[i]);
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ == null) {
                return;
            }
            BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.blockPos);
            if (blockEntity instanceof BaseShipControlSeatBE) {
                BaseShipControlSeatBE be = (BaseShipControlSeatBE)blockEntity;
                be.receiveHologramRenderTarget(this.count, this.targets, this.isShip, this.ids);
            }
        });
        context.setPacketHandled(true);
    }
}

